/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.feeds;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import ch.boye.httpclientandroidlib.util.TextUtils;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.mozilla.gecko.feeds.parser.Feed;
import org.mozilla.gecko.feeds.parser.SimpleFeedParser;
import org.mozilla.gecko.util.IOUtils;

public class FeedFetcher {
    private static final int CONNECT_TIMEOUT = 15000;
    private static final int READ_TIMEOUT = 15000;

    public static FeedResponse fetchAndParseFeed(String string2) {
        return FeedFetcher.fetchAndParseFeedIfModified(string2, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FeedResponse fetchAndParseFeedIfModified(@NonNull String string2, @Nullable String string3, @Nullable String string4) {
        FeedResponse feedResponse;
        BufferedInputStream bufferedInputStream;
        block13: {
            HttpURLConnection httpURLConnection = null;
            bufferedInputStream = null;
            try {
                int n;
                httpURLConnection = (HttpURLConnection)new URL(string2).openConnection();
                httpURLConnection.setInstanceFollowRedirects(true);
                httpURLConnection.setConnectTimeout(15000);
                httpURLConnection.setReadTimeout(15000);
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    httpURLConnection.setRequestProperty("If-None-Match", string3);
                }
                if (!TextUtils.isEmpty((CharSequence)string4)) {
                    httpURLConnection.setRequestProperty("If-Modified-Since", string4);
                }
                if ((n = httpURLConnection.getResponseCode()) != 200) {
                    FeedResponse feedResponse2 = null;
                    return feedResponse2;
                }
                String string5 = httpURLConnection.getHeaderField("ETag");
                if (!TextUtils.isEmpty((CharSequence)string5) && string5.startsWith("W/")) {
                    string5 = string5.substring(2);
                }
                String string6 = httpURLConnection.getHeaderField("Last-Modified");
                bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
                SimpleFeedParser simpleFeedParser = new SimpleFeedParser();
                Feed feed = simpleFeedParser.parse(bufferedInputStream);
                feedResponse = new FeedResponse(feed, string5, string6);
                if (httpURLConnection == null) break block13;
                httpURLConnection.disconnect();
            }
            catch (IOException iOException) {
                FeedResponse feedResponse3 = null;
                return feedResponse3;
            }
            catch (SimpleFeedParser.ParserException parserException) {
                FeedResponse feedResponse4 = null;
                return feedResponse4;
            }
            finally {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                IOUtils.safeStreamClose(bufferedInputStream);
            }
        }
        IOUtils.safeStreamClose((Closeable)bufferedInputStream);
        return feedResponse;
    }

    public static class FeedResponse {
        public final Feed feed;
        public final String etag;
        public final String lastModified;

        public FeedResponse(Feed feed, String string2, String string3) {
            this.feed = feed;
            this.etag = string2;
            this.lastModified = string3;
        }
    }
}

