/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.feeds.action;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.text.TextUtils;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.db.UrlAnnotations;
import org.mozilla.gecko.feeds.FeedService;
import org.mozilla.gecko.feeds.action.FeedAction;
import org.mozilla.gecko.feeds.knownsites.KnownSite;
import org.mozilla.gecko.feeds.knownsites.KnownSiteBlogger;
import org.mozilla.gecko.feeds.knownsites.KnownSiteMedium;
import org.mozilla.gecko.feeds.knownsites.KnownSiteTumblr;
import org.mozilla.gecko.feeds.knownsites.KnownSiteWordpress;

public class EnrollSubscriptionsAction
extends FeedAction {
    private static final String LOGTAG = "FeedEnrollAction";
    private static final KnownSite[] knownSites = new KnownSite[]{new KnownSiteMedium(), new KnownSiteBlogger(), new KnownSiteWordpress(), new KnownSiteTumblr()};
    private Context context;

    public EnrollSubscriptionsAction(Context context) {
        this.context = context;
    }

    @Override
    public void perform(BrowserDB browserDB, Intent intent) {
        this.log("Searching for bookmarks to enroll in updates");
        ContentResolver contentResolver = this.context.getContentResolver();
        for (KnownSite knownSite : knownSites) {
            this.searchFor(browserDB, contentResolver, knownSite);
        }
    }

    @Override
    public boolean requiresNetwork() {
        return false;
    }

    @Override
    public boolean requiresPreferenceEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchFor(BrowserDB browserDB, ContentResolver contentResolver, KnownSite knownSite) {
        UrlAnnotations urlAnnotations = browserDB.getUrlAnnotations();
        Cursor cursor = browserDB.getBookmarksForPartialUrl(contentResolver, knownSite.getURLSearchString());
        if (cursor == null) {
            this.log("Nothing found (" + knownSite.getClass().getSimpleName() + ")");
            return;
        }
        try {
            this.log("Found " + cursor.getCount() + " websites");
            while (cursor.moveToNext()) {
                String string2 = cursor.getString(cursor.getColumnIndex("url"));
                this.log(" URL: " + string2);
                String string3 = knownSite.getFeedFromURL(string2);
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    this.log("Could not determine feed for URL: " + string2);
                    return;
                }
                if (!urlAnnotations.hasFeedUrlForWebsite(contentResolver, string2)) {
                    urlAnnotations.insertFeedUrl(contentResolver, string2, string3);
                }
                if (urlAnnotations.hasFeedSubscription(contentResolver, string3)) continue;
                FeedService.subscribe(this.context, string3);
            }
        }
        finally {
            cursor.close();
        }
    }
}

