/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.feeds.action;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.SystemClock;
import com.keepsafe.switchboard.SwitchBoard;
import java.text.DateFormat;
import java.util.Calendar;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.feeds.FeedAlarmReceiver;
import org.mozilla.gecko.feeds.action.FeedAction;

public class SetupAlarmsAction
extends FeedAction {
    private static final String LOGTAG = "FeedSetupAction";
    private Context context;

    public SetupAlarmsAction(Context context) {
        this.context = context;
    }

    @Override
    public void perform(BrowserDB browserDB, Intent intent) {
        AlarmManager alarmManager = (AlarmManager)this.context.getSystemService("alarm");
        this.cancelPreviousAlarms(alarmManager);
        this.scheduleAlarms(alarmManager);
    }

    @Override
    public boolean requiresNetwork() {
        return false;
    }

    @Override
    public boolean requiresPreferenceEnabled() {
        return false;
    }

    private void cancelPreviousAlarms(AlarmManager alarmManager) {
        PendingIntent pendingIntent = this.getWithdrawPendingIntent();
        alarmManager.cancel(pendingIntent);
        PendingIntent pendingIntent2 = this.getEnrollPendingIntent();
        alarmManager.cancel(pendingIntent2);
        PendingIntent pendingIntent3 = this.getCheckPendingIntent();
        alarmManager.cancel(pendingIntent3);
        this.log("Cancelled previous alarms");
    }

    private void scheduleAlarms(AlarmManager alarmManager) {
        alarmManager.setInexactRepeating(3, SystemClock.elapsedRealtime() + 900000L, 86400000L, this.getWithdrawPendingIntent());
        alarmManager.setInexactRepeating(3, SystemClock.elapsedRealtime() + 1800000L, 86400000L, this.getEnrollPendingIntent());
        if (SwitchBoard.isInExperiment((Context)this.context, (String)"content-notifications-12hrs")) {
            this.scheduleUpdateCheckEvery12Hours(alarmManager);
        }
        if (SwitchBoard.isInExperiment((Context)this.context, (String)"content-notifications-8am")) {
            this.scheduleUpdateAtFullHour(alarmManager, 8);
        }
        if (SwitchBoard.isInExperiment((Context)this.context, (String)"content-notifications-5pm")) {
            this.scheduleUpdateAtFullHour(alarmManager, 17);
        }
        this.log("Scheduled alarms");
    }

    private void scheduleUpdateCheckEvery12Hours(AlarmManager alarmManager) {
        alarmManager.setInexactRepeating(3, SystemClock.elapsedRealtime() + 3600000L, 43200000L, this.getCheckPendingIntent());
    }

    private void scheduleUpdateAtFullHour(AlarmManager alarmManager, int n) {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(11) >= n) {
            calendar.add(5, 1);
        }
        calendar.set(11, n);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        alarmManager.setInexactRepeating(1, calendar.getTimeInMillis(), 86400000L, this.getCheckPendingIntent());
        this.log("Scheduled update alarm at " + DateFormat.getDateTimeInstance().format(calendar.getTime()));
    }

    private PendingIntent getWithdrawPendingIntent() {
        Intent intent = new Intent(this.context, FeedAlarmReceiver.class);
        intent.setAction("org.mozilla.fennec.FEEDS.WITHDRAW");
        return PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)intent, (int)0);
    }

    private PendingIntent getEnrollPendingIntent() {
        Intent intent = new Intent(this.context, FeedAlarmReceiver.class);
        intent.setAction("org.mozilla.fennec.FEEDS.ENROLL");
        return PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)intent, (int)0);
    }

    private PendingIntent getCheckPendingIntent() {
        Intent intent = new Intent(this.context, FeedAlarmReceiver.class);
        intent.setAction("org.mozilla.fennec.FEEDS.CHECK");
        return PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)intent, (int)0);
    }
}

