/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.feeds.parser;

import android.util.Log;
import ch.boye.httpclientandroidlib.util.TextUtils;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.mozilla.gecko.feeds.parser.Feed;
import org.mozilla.gecko.feeds.parser.Item;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class SimpleFeedParser {
    private static final String LOGTAG = "Gecko/FeedParser";
    private static final String TAG_RSS = "rss";
    private static final String TAG_FEED = "feed";
    private static final String TAG_RDF = "RDF";
    private static final String TAG_TITLE = "title";
    private static final String TAG_ITEM = "item";
    private static final String TAG_LINK = "link";
    private static final String TAG_ENTRY = "entry";
    private static final String TAG_PUBDATE = "pubDate";
    private static final String TAG_UPDATED = "updated";
    private static final String TAG_DATE = "date";
    private static final String TAG_SOURCE = "source";
    private static final String TAG_IMAGE = "image";
    private static final String TAG_CONTENT = "content";

    public Feed parse(InputStream inputStream) throws ParserException, IOException {
        ParserState parserState = new ParserState();
        try {
            XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
            xmlPullParserFactory.setNamespaceAware(true);
            XmlPullParser xmlPullParser = xmlPullParserFactory.newPullParser();
            xmlPullParser.setInput(inputStream, null);
            int n = xmlPullParser.getEventType();
            while (n != 1) {
                switch (n) {
                    case 0: {
                        this.handleStartDocument(parserState);
                        break;
                    }
                    case 2: {
                        this.handleStartTag(xmlPullParser, parserState);
                        break;
                    }
                    case 3: {
                        this.handleEndTag(xmlPullParser, parserState);
                    }
                }
                n = xmlPullParser.next();
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new ParserException(xmlPullParserException);
        }
        if (!parserState.feed.isSufficientlyComplete()) {
            throw new ParserException("Feed is not sufficiently complete");
        }
        return parserState.feed;
    }

    private void handleStartDocument(ParserState parserState) {
        parserState.feed = new Feed();
    }

    private void handleStartTag(XmlPullParser xmlPullParser, ParserState parserState) throws IOException, XmlPullParserException {
        switch (xmlPullParser.getName()) {
            case "rss": {
                parserState.isRSS = true;
                break;
            }
            case "feed": {
                parserState.isATOM = true;
                break;
            }
            case "RDF": {
                parserState.isRSS = true;
                break;
            }
            case "item": 
            case "entry": {
                parserState.currentItem = new Item();
                break;
            }
            case "title": {
                this.handleTitleStartTag(xmlPullParser, parserState);
                break;
            }
            case "link": {
                this.handleLinkStartTag(xmlPullParser, parserState);
                break;
            }
            case "pubDate": {
                this.handlePubDateStartTag(xmlPullParser, parserState);
                break;
            }
            case "updated": {
                this.handleUpdatedStartTag(xmlPullParser, parserState);
                break;
            }
            case "date": {
                this.handleDateStartTag(xmlPullParser, parserState);
                break;
            }
            case "source": {
                parserState.inSource = true;
                break;
            }
            case "image": {
                parserState.inImage = true;
                break;
            }
            case "content": {
                parserState.inContent = true;
            }
        }
    }

    private void handleEndTag(XmlPullParser xmlPullParser, ParserState parserState) {
        switch (xmlPullParser.getName()) {
            case "item": 
            case "entry": {
                this.handleItemOrEntryREndTag(parserState);
                break;
            }
            case "source": {
                parserState.inSource = false;
                break;
            }
            case "image": {
                parserState.inImage = false;
                break;
            }
            case "content": {
                parserState.inContent = false;
            }
        }
    }

    private void handleTitleStartTag(XmlPullParser xmlPullParser, ParserState parserState) throws IOException, XmlPullParserException {
        if (parserState.inSource || parserState.inImage || parserState.inContent) {
            return;
        }
        String string2 = this.getTextUntilEndTag(xmlPullParser, TAG_TITLE);
        string2 = string2.replaceAll("[\r\n]", " ");
        string2 = string2.replaceAll("  +", " ");
        if (parserState.currentItem != null) {
            parserState.currentItem.setTitle(string2);
        } else {
            parserState.feed.setTitle(string2);
        }
    }

    private void handleLinkStartTag(XmlPullParser xmlPullParser, ParserState parserState) throws IOException, XmlPullParserException {
        String string2;
        if (parserState.inSource || parserState.inImage) {
            return;
        }
        Map<String, String> map = this.fetchAttributes(xmlPullParser);
        if (map.size() > 0) {
            String string3;
            string2 = map.get("rel");
            if (parserState.currentItem == null && "self".equals(string2)) {
                parserState.feed.setFeedURL(map.get("href"));
                return;
            }
            if ((string2 == null || "alternate".equals(string2)) && ((string3 = map.get("type")) == null || string3.equals("text/html"))) {
                String string4 = map.get("href");
                if (TextUtils.isEmpty((CharSequence)string4)) {
                    return;
                }
                if (parserState.currentItem != null) {
                    parserState.currentItem.setURL(string4);
                } else {
                    parserState.feed.setWebsiteURL(string4);
                }
                return;
            }
        }
        if (parserState.isRSS) {
            string2 = this.getTextUntilEndTag(xmlPullParser, TAG_LINK);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return;
            }
            if (parserState.currentItem != null) {
                parserState.currentItem.setURL(string2);
            } else {
                parserState.feed.setWebsiteURL(string2);
            }
        }
    }

    private void handleItemOrEntryREndTag(ParserState parserState) {
        if (parserState.feed.getLastItem() == null || parserState.feed.getLastItem().getTimestamp() < parserState.currentItem.getTimestamp()) {
            parserState.feed.setLastItem(parserState.currentItem);
        }
        parserState.currentItem = null;
    }

    private void handlePubDateStartTag(XmlPullParser xmlPullParser, ParserState parserState) throws IOException, XmlPullParserException {
        if (parserState.currentItem == null) {
            return;
        }
        String string2 = this.getTextUntilEndTag(xmlPullParser, TAG_PUBDATE);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
        this.updateCurrentItemTimestamp(parserState, string2, simpleDateFormat);
    }

    private void handleUpdatedStartTag(XmlPullParser xmlPullParser, ParserState parserState) throws IOException, XmlPullParserException {
        if (parserState.inSource) {
            return;
        }
        if (parserState.currentItem == null) {
            return;
        }
        String string2 = this.getTextUntilEndTag(xmlPullParser, TAG_UPDATED);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        SimpleDateFormat[] simpleDateFormatArray = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US)};
        string2 = string2.replaceFirst("Z$", "+0000");
        string2 = string2.replaceFirst("([0-9]{2})([\\+\\-])([0-9]{2}):([0-9]{2})$", "$1$2$3$4");
        this.updateCurrentItemTimestamp(parserState, string2, simpleDateFormatArray);
    }

    private void handleDateStartTag(XmlPullParser xmlPullParser, ParserState parserState) throws IOException, XmlPullParserException {
        if (parserState.currentItem == null) {
            return;
        }
        String string2 = this.getTextUntilEndTag(xmlPullParser, TAG_DATE);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        string2 = string2.replaceFirst("([0-9]{2})([\\+\\-])([0-9]{2}):([0-9]{2})$", "$1$2$3$4");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
        this.updateCurrentItemTimestamp(parserState, string2, simpleDateFormat);
    }

    private void updateCurrentItemTimestamp(ParserState parserState, String string2, SimpleDateFormat ... simpleDateFormatArray) {
        for (SimpleDateFormat simpleDateFormat : simpleDateFormatArray) {
            try {
                Date date = simpleDateFormat.parse(string2);
                parserState.currentItem.setTimestamp(date.getTime());
                return;
            }
            catch (ParseException parseException) {
                Log.w((String)LOGTAG, (String)("Could not parse 'updated': " + string2));
            }
        }
    }

    private Map<String, String> fetchAttributes(XmlPullParser xmlPullParser) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < xmlPullParser.getAttributeCount(); ++i) {
            hashMap.put(xmlPullParser.getAttributeName(i), xmlPullParser.getAttributeValue(i));
        }
        return hashMap;
    }

    private String getTextUntilEndTag(XmlPullParser xmlPullParser, String string2) throws IOException, XmlPullParserException {
        StringBuilder stringBuilder = new StringBuilder();
        while (xmlPullParser.next() != 1) {
            if (xmlPullParser.getEventType() == 4) {
                stringBuilder.append(xmlPullParser.getText());
                continue;
            }
            if (xmlPullParser.getEventType() != 3 || !string2.equals(xmlPullParser.getName())) continue;
            break;
        }
        return stringBuilder.toString().trim();
    }

    private class ParserState {
        public Feed feed;
        public Item currentItem;
        public boolean isRSS;
        public boolean isATOM;
        public boolean inSource;
        public boolean inImage;
        public boolean inContent;

        private ParserState() {
        }
    }

    public static class ParserException
    extends Exception {
        private static final long serialVersionUID = -6119538440219805603L;

        public ParserException(Throwable throwable) {
            super(throwable);
        }

        public ParserException(String string2) {
            super(string2);
        }
    }
}

