/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import org.mozilla.gecko.R;
import org.mozilla.gecko.widget.CropImageView;

public class TopSitesThumbnailView
extends CropImageView {
    private static final String LOGTAG = "GeckoTopSitesThumbnailView";
    private static final int COLOR_FILTER = 0x46FFFFFF;
    private final int mDefaultColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.top_site_default);
    private final float mStrokeWidth;
    private final Paint mBorderPaint;

    public TopSitesThumbnailView(Context context) {
        this(context, null);
        this.setWillNotDraw(false);
    }

    public TopSitesThumbnailView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.topSitesThumbnailViewStyle);
    }

    public TopSitesThumbnailView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mStrokeWidth = this.getResources().getDisplayMetrics().density * 2.0f;
        Resources resources = this.getResources();
        this.mBorderPaint = new Paint(1);
        this.mBorderPaint.setColor(ContextCompat.getColor((Context)context, (int)R.color.top_site_border));
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
    }

    @Override
    protected float getAspectRatio() {
        return 0.5714286f;
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.getBackground() == null) {
            this.mBorderPaint.setStrokeWidth(this.mStrokeWidth);
            canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.mBorderPaint);
        }
    }

    public void setBackgroundColorWithOpacityFilter(int n) {
        this.setBackgroundColor(n & 0x46FFFFFF);
    }

    public void setBackgroundColor(int n) {
        if (n == 0) {
            n = this.mDefaultColor;
        }
        Drawable drawable2 = this.getResources().getDrawable(R.drawable.top_sites_thumbnail_bg);
        drawable2.setColorFilter(n, PorterDuff.Mode.SRC_ATOP);
        this.setBackgroundDrawable(drawable2);
    }
}

