/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.overlays.service.sharemethods;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.db.RemoteClient;
import org.mozilla.gecko.db.TabsAccessor;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.overlays.service.ShareData;
import org.mozilla.gecko.overlays.service.sharemethods.ShareMethod;
import org.mozilla.gecko.sync.CommandProcessor;
import org.mozilla.gecko.sync.CommandRunner;
import org.mozilla.gecko.sync.GlobalSession;

public class SendTab
extends ShareMethod {
    private static final String LOGTAG = "GeckoSendTab";
    public static final String SEND_TAB_TARGET_DEVICES = "SEND_TAB_TARGET_DEVICES";
    public static final String EXTRA_REMOTE_CLIENT_RECORDS = "RECORDS";
    public static final String OVERRIDE_INTENT = "OVERRIDE_INTENT";
    private Set<String> validGUIDs;
    private TabSender tabSender;

    @Override
    public ShareMethod.Result handle(ShareData shareData) {
        if (shareData.extra == null) {
            Log.e((String)LOGTAG, (String)"No target devices specified!");
            return ShareMethod.Result.PERMANENT_FAILURE;
        }
        String[] stringArray = ((Bundle)shareData.extra).getStringArray(SEND_TAB_TARGET_DEVICES);
        if (!this.validGUIDs.containsAll(Arrays.asList(stringArray))) {
            Log.e((String)LOGTAG, (String)"Not all provided GUIDs are real devices:");
            for (String string2 : stringArray) {
                if (this.validGUIDs.contains(string2)) continue;
                Log.e((String)LOGTAG, (String)("Invalid GUID: " + string2));
            }
            return ShareMethod.Result.PERMANENT_FAILURE;
        }
        Log.i((String)LOGTAG, (String)"Send tab handler invoked.");
        CommandProcessor commandProcessor = CommandProcessor.getProcessor();
        String string3 = this.tabSender.getAccountGUID();
        Log.d((String)LOGTAG, (String)("Retrieved local account GUID '" + string3 + "'."));
        if (string3 == null) {
            Log.e((String)LOGTAG, (String)"Cannot determine account GUID");
            return ShareMethod.Result.TRANSIENT_FAILURE;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            commandProcessor.sendURIToClientForDisplay(shareData.url, stringArray[i], shareData.title, string3, this.context);
        }
        Log.i((String)LOGTAG, (String)"Requesting immediate clients stage sync.");
        this.tabSender.sync();
        return ShareMethod.Result.SUCCESS;
    }

    private Intent getUIStateIntent() {
        Intent intent = new Intent("org.mozilla.gecko.overlays.ACTION_SHARE_METHOD_UI_EVENT");
        intent.putExtra("SHARE_METHOD", (Parcelable)ShareMethod.Type.SEND_TAB);
        return intent;
    }

    private void broadcastUIState(Intent intent) {
        LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(intent);
    }

    public SendTab(Context context) {
        super(context);
        AccountManager accountManager = AccountManager.get((Context)this.context);
        Account[] accountArray = accountManager.getAccountsByType("org.mozilla.fennec_fxaccount");
        if (accountArray.length > 0) {
            AndroidFxAccount androidFxAccount = new AndroidFxAccount(this.context, accountArray[0]);
            if (androidFxAccount.getState().getNeededAction() != State.Action.None) {
                Log.w((String)LOGTAG, (String)("Firefox Account named like " + androidFxAccount.getObfuscatedEmail() + " needs action before it can send a tab; redirecting to status activity."));
                this.setOverrideIntentAction("org.mozilla.fennec.ACTION_FXA_STATUS");
                return;
            }
            this.tabSender = new FxAccountTabSender(androidFxAccount);
            this.updateClientList(this.tabSender);
            Log.i((String)LOGTAG, (String)"Allowing tab send for Firefox Account.");
            SendTab.registerDisplayURICommand();
            return;
        }
        this.setOverrideIntentAction("org.mozilla.fennec.ACTION_FXA_GET_STARTED");
    }

    private void updateClientList(TabSender tabSender) {
        Collection<RemoteClient> collection = this.getOtherClients(tabSender);
        Parcelable[] parcelableArray = new RemoteClient[collection.size()];
        parcelableArray = collection.toArray(parcelableArray);
        this.validGUIDs = new HashSet<String>();
        for (RemoteClient remoteClient : collection) {
            this.validGUIDs.add(remoteClient.guid);
        }
        if (this.validGUIDs.isEmpty()) {
            this.setOverrideIntentAction("org.mozilla.fennec.ACTION_FXA_GET_STARTED");
            return;
        }
        Intent intent = this.getUIStateIntent();
        intent.putExtra(EXTRA_REMOTE_CLIENT_RECORDS, parcelableArray);
        this.broadcastUIState(intent);
    }

    protected void setOverrideIntentAction(String string2) {
        Intent intent = new Intent(string2);
        intent.addFlags(65536);
        intent.addFlags(0x10000000);
        Intent intent2 = this.getUIStateIntent();
        intent2.putExtra(OVERRIDE_INTENT, (Parcelable)intent);
        this.broadcastUIState(intent2);
    }

    private static void registerDisplayURICommand() {
        CommandProcessor commandProcessor = CommandProcessor.getProcessor();
        commandProcessor.registerCommand("displayURI", new CommandRunner(3){

            public void executeCommand(GlobalSession globalSession, List<String> list) {
                CommandProcessor.displayURI(list, (Context)globalSession.getContext());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<RemoteClient> getOtherClients(TabSender tabSender) {
        if (tabSender == null) {
            Log.w((String)LOGTAG, (String)"No tab sender when fetching other client IDs.");
            return Collections.emptyList();
        }
        BrowserDB browserDB = GeckoProfile.get(this.context).getDB();
        TabsAccessor tabsAccessor = browserDB.getTabsAccessor();
        try (Cursor cursor = tabsAccessor.getRemoteClientsByRecencyCursor(this.context);){
            if (cursor.getCount() == 0) {
                List<RemoteClient> list = Collections.emptyList();
                return list;
            }
            List<RemoteClient> list = tabsAccessor.getClientsWithoutTabsByRecencyFromCursor(cursor);
            return list;
        }
    }

    private static class FxAccountTabSender
    implements TabSender {
        private final AndroidFxAccount fxAccount;

        public FxAccountTabSender(AndroidFxAccount androidFxAccount) {
            this.fxAccount = androidFxAccount;
        }

        @Override
        public String getAccountGUID() {
            try {
                SharedPreferences sharedPreferences = this.fxAccount.getSyncPrefs();
                return sharedPreferences.getString("account.guid", null);
            }
            catch (Exception exception) {
                Log.w((String)SendTab.LOGTAG, (String)"Could not get Firefox Account parameters or preferences; aborting.");
                return null;
            }
        }

        @Override
        public void sync() {
            this.fxAccount.requestImmediateSync(STAGES_TO_SYNC, null);
        }
    }

    private static interface TabSender {
        public static final String[] STAGES_TO_SYNC = new String[]{"clients", "tabs"};

        public String getAccountGUID();

        public void sync();
    }
}

