/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.overlays.ui;

import android.app.AlertDialog;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import java.util.Collection;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.R;
import org.mozilla.gecko.db.RemoteClient;
import org.mozilla.gecko.overlays.ui.OverlayDialogButton;
import org.mozilla.gecko.overlays.ui.SendTabList;
import org.mozilla.gecko.overlays.ui.SendTabTargetSelectedListener;

public class SendTabDeviceListArrayAdapter
extends ArrayAdapter<RemoteClient> {
    private static final String LOGTAG = "GeckoSendTabAdapter";
    private SendTabList.State currentState;
    private String dummyRecordName;
    private final SendTabTargetSelectedListener listener;
    private Collection<RemoteClient> records;
    private AlertDialog dialog;

    public SendTabDeviceListArrayAdapter(Context context, SendTabTargetSelectedListener sendTabTargetSelectedListener) {
        super(context, R.layout.overlay_share_send_tab_item, R.id.overlaybtn_label);
        this.listener = sendTabTargetSelectedListener;
        this.setNotifyOnChange(false);
    }

    public RemoteClient[] toArray() {
        return this.records.toArray(new RemoteClient[this.records.size()]);
    }

    public void setRemoteClientsList(Collection<RemoteClient> collection) {
        this.records = collection;
        this.updateRecordList();
    }

    public void updateRecordList() {
        if (this.currentState != SendTabList.State.LIST) {
            return;
        }
        this.clear();
        this.setNotifyOnChange(false);
        if (AppConstants.Versions.feature11Plus) {
            this.addAll(this.records);
        } else {
            for (RemoteClient remoteClient : this.records) {
                this.add(remoteClient);
            }
        }
        this.notifyDataSetChanged();
    }

    public View getView(int n, View view, ViewGroup viewGroup) {
        Object object;
        Context context = this.getContext();
        OverlayDialogButton overlayDialogButton = (OverlayDialogButton)view;
        if (overlayDialogButton == null) {
            overlayDialogButton = (OverlayDialogButton)View.inflate((Context)context, (int)R.layout.overlay_share_send_tab_item, null);
        }
        if (n == 0) {
            overlayDialogButton.setBackgroundResource(R.drawable.overlay_share_button_background_first);
        } else {
            overlayDialogButton.setBackgroundResource(R.drawable.overlay_share_button_background);
        }
        if (this.currentState != SendTabList.State.LIST) {
            object = context.getResources().getDrawable(R.drawable.shareplane);
            overlayDialogButton.setText(this.dummyRecordName);
            overlayDialogButton.setDrawable((Drawable)object);
        }
        if (this.currentState == SendTabList.State.SHOW_DEVICES) {
            overlayDialogButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    SendTabDeviceListArrayAdapter.this.dialog.show();
                }
            });
            return overlayDialogButton;
        }
        object = (RemoteClient)this.getItem(n);
        if (this.currentState == SendTabList.State.LIST) {
            Drawable drawable2 = context.getResources().getDrawable(SendTabDeviceListArrayAdapter.getImage((RemoteClient)object));
            overlayDialogButton.setText(object.name);
            overlayDialogButton.setDrawable(drawable2);
            final String string2 = object.guid;
            overlayDialogButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    SendTabDeviceListArrayAdapter.this.listener.onSendTabTargetSelected(string2);
                }
            });
        } else {
            overlayDialogButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    SendTabDeviceListArrayAdapter.this.listener.onSendTabActionSelected();
                }
            });
        }
        return overlayDialogButton;
    }

    private static int getImage(RemoteClient remoteClient) {
        if ("mobile".equals(remoteClient.deviceType)) {
            return R.drawable.device_mobile;
        }
        return R.drawable.device_desktop;
    }

    public void switchState(SendTabList.State state) {
        if (this.currentState == state) {
            return;
        }
        this.currentState = state;
        switch (state) {
            case LIST: {
                this.updateRecordList();
                break;
            }
            case NONE: {
                this.showDummyRecord(this.getContext().getResources().getString(R.string.overlay_share_send_tab_btn_label));
                break;
            }
            case SHOW_DEVICES: {
                this.showDummyRecord(this.getContext().getResources().getString(R.string.overlay_share_send_other));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected state transition: " + (Object)((Object)state));
            }
        }
    }

    private void showDummyRecord(String string2) {
        this.dummyRecordName = string2;
        this.clear();
        this.add(null);
        this.notifyDataSetChanged();
    }

    public void setDialog(AlertDialog alertDialog) {
        this.dialog = alertDialog;
    }
}

