/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.push;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.push.Fetched;
import org.mozilla.gecko.push.PushSubscription;

public class PushRegistration {
    public final String autopushEndpoint;
    public final boolean debug;
    @NonNull
    public final Fetched uaid;
    public final String secret;
    @NonNull
    protected final Map<String, PushSubscription> subscriptions;

    public PushRegistration(String string2, boolean bl, @NonNull Fetched fetched, @Nullable String string3, @NonNull Map<String, PushSubscription> map) {
        this.autopushEndpoint = string2;
        this.debug = bl;
        this.uaid = fetched;
        this.secret = string3;
        this.subscriptions = map;
    }

    public PushRegistration(String string2, boolean bl, @NonNull Fetched fetched, @Nullable String string3) {
        this(string2, bl, fetched, string3, new HashMap<String, PushSubscription>());
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (Map.Entry<String, PushSubscription> entry : this.subscriptions.entrySet()) {
            jSONObject.put(entry.getKey(), (Object)entry.getValue().toJSONObject());
        }
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("autopushEndpoint", (Object)this.autopushEndpoint);
        jSONObject2.put("debug", this.debug);
        jSONObject2.put("uaid", (Object)this.uaid.toJSONObject());
        jSONObject2.put("secret", (Object)this.secret);
        jSONObject2.put("subscriptions", (Object)jSONObject);
        return jSONObject2;
    }

    public static PushRegistration fromJSONObject(@NonNull JSONObject jSONObject) throws JSONException {
        String string2 = jSONObject.optString("autopushEndpoint", null);
        boolean bl = jSONObject.getBoolean("debug");
        Fetched fetched = Fetched.fromJSONObject(jSONObject.getJSONObject("uaid"));
        String string3 = jSONObject.optString("secret", null);
        JSONObject jSONObject2 = jSONObject.getJSONObject("subscriptions");
        HashMap<String, PushSubscription> hashMap = new HashMap<String, PushSubscription>();
        Iterator iterator = jSONObject2.keys();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            hashMap.put(string4, PushSubscription.fromJSONObject(jSONObject2.getJSONObject(string4)));
        }
        return new PushRegistration(string2, bl, fetched, string3, hashMap);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PushRegistration pushRegistration = (PushRegistration)object;
        if (this.autopushEndpoint != null ? !this.autopushEndpoint.equals(pushRegistration.autopushEndpoint) : pushRegistration.autopushEndpoint != null) {
            return false;
        }
        if (!this.uaid.equals(pushRegistration.uaid)) {
            return false;
        }
        if (this.secret != null ? !this.secret.equals(pushRegistration.secret) : pushRegistration.secret != null) {
            return false;
        }
        if (this.subscriptions != null ? !this.subscriptions.equals(pushRegistration.subscriptions) : pushRegistration.subscriptions != null) {
            return false;
        }
        return this.debug == pushRegistration.debug;
    }

    public int hashCode() {
        int n = this.autopushEndpoint != null ? this.autopushEndpoint.hashCode() : 0;
        n = 31 * n + (this.debug ? 1 : 0);
        n = 31 * n + this.uaid.hashCode();
        n = 31 * n + (this.secret != null ? this.secret.hashCode() : 0);
        n = 31 * n + (this.subscriptions != null ? this.subscriptions.hashCode() : 0);
        return n;
    }

    public PushRegistration withDebug(boolean bl) {
        return new PushRegistration(this.autopushEndpoint, bl, this.uaid, this.secret, this.subscriptions);
    }

    public PushRegistration withUserAgentID(String string2, String string3, long l) {
        return new PushRegistration(this.autopushEndpoint, this.debug, new Fetched(string2, l), string3, this.subscriptions);
    }

    public PushSubscription getSubscription(@NonNull String string2) {
        return this.subscriptions.get(string2);
    }

    public PushSubscription putSubscription(@NonNull String string2, @NonNull PushSubscription pushSubscription) {
        return this.subscriptions.put(string2, pushSubscription);
    }

    public PushSubscription removeSubscription(@NonNull String string2) {
        return this.subscriptions.remove(string2);
    }
}

