/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.restrictions;

import android.net.Uri;
import java.util.Arrays;
import java.util.List;
import org.mozilla.gecko.restrictions.Restrictable;
import org.mozilla.gecko.restrictions.RestrictionConfiguration;

public class GuestProfileConfiguration
implements RestrictionConfiguration {
    static List<Restrictable> DISABLED_FEATURES = Arrays.asList(Restrictable.DOWNLOAD, Restrictable.INSTALL_EXTENSION, Restrictable.INSTALL_APPS, Restrictable.BROWSE, Restrictable.SHARE, Restrictable.BOOKMARK, Restrictable.ADD_CONTACT, Restrictable.SET_IMAGE, Restrictable.MODIFY_ACCOUNTS, Restrictable.REMOTE_DEBUGGING, Restrictable.IMPORT_SETTINGS, Restrictable.BLOCK_LIST, Restrictable.DATA_CHOICES, Restrictable.DEFAULT_THEME);
    private static final List<String> BANNED_SCHEMES = Arrays.asList("file", "chrome", "resource", "jar", "wyciwyg");
    private static final List<String> BANNED_URLS = Arrays.asList("about:config", "about:addons");

    @Override
    public boolean isAllowed(Restrictable restrictable) {
        return !DISABLED_FEATURES.contains((Object)restrictable);
    }

    @Override
    public boolean canLoadUrl(String string2) {
        if (string2 == null) {
            return true;
        }
        Uri uri = Uri.parse((String)string2);
        String string3 = uri.getScheme();
        if (BANNED_SCHEMES.contains(string3)) {
            return false;
        }
        string2 = string2.toLowerCase();
        for (String string4 : BANNED_URLS) {
            if (!string2.startsWith(string4)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRestricted() {
        return true;
    }

    @Override
    public void update() {
    }
}

