/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.restrictions;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Bundle;
import android.os.StrictMode;
import android.os.UserManager;
import org.mozilla.gecko.restrictions.Restrictable;
import org.mozilla.gecko.util.ThreadUtils;

public class RestrictionCache {
    private static Bundle cachedAppRestrictions;
    private static Bundle cachedUserRestrictions;
    private static boolean isCacheInvalid;

    private RestrictionCache() {
    }

    public static synchronized boolean getUserRestriction(Context context, String string2) {
        RestrictionCache.updateCacheIfNeeded(context);
        return cachedUserRestrictions.getBoolean(string2);
    }

    public static synchronized boolean hasApplicationRestriction(Context context, String string2) {
        RestrictionCache.updateCacheIfNeeded(context);
        return cachedAppRestrictions.containsKey(string2);
    }

    public static synchronized boolean getApplicationRestriction(Context context, String string2, boolean bl) {
        RestrictionCache.updateCacheIfNeeded(context);
        return cachedAppRestrictions.getBoolean(string2, bl);
    }

    public static synchronized boolean hasApplicationRestrictions(Context context) {
        RestrictionCache.updateCacheIfNeeded(context);
        return !cachedAppRestrictions.isEmpty();
    }

    public static synchronized void invalidate() {
        isCacheInvalid = true;
    }

    private static void updateCacheIfNeeded(Context context) {
        if (isCacheInvalid || !ThreadUtils.isOnUiThread()) {
            RestrictionCache.readRestrictions(context);
            isCacheInvalid = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=18)
    private static void readRestrictions(Context context) {
        UserManager userManager = (UserManager)context.getSystemService("user");
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            Bundle bundle = userManager.getApplicationRestrictions(context.getPackageName());
            RestrictionCache.migrateRestrictionsIfNeeded(bundle);
            cachedAppRestrictions = bundle;
            cachedUserRestrictions = userManager.getUserRestrictions();
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    static void migrateRestrictionsIfNeeded(Bundle bundle) {
        if (!bundle.containsKey(Restrictable.INSTALL_EXTENSION.name) && bundle.containsKey("no_install_extensions")) {
            bundle.putBoolean(Restrictable.INSTALL_EXTENSION.name, !bundle.getBoolean("no_install_extensions"));
        }
        if (!bundle.containsKey(Restrictable.PRIVATE_BROWSING.name) && bundle.containsKey("no_private_browsing")) {
            bundle.putBoolean(Restrictable.PRIVATE_BROWSING.name, !bundle.getBoolean("no_private_browsing"));
        }
        if (!bundle.containsKey(Restrictable.CLEAR_HISTORY.name) && bundle.containsKey("no_clear_history")) {
            bundle.putBoolean(Restrictable.CLEAR_HISTORY.name, !bundle.getBoolean("no_clear_history"));
        }
        if (!bundle.containsKey(Restrictable.ADVANCED_SETTINGS.name) && bundle.containsKey("no_advanced_settings")) {
            bundle.putBoolean(Restrictable.ADVANCED_SETTINGS.name, !bundle.getBoolean("no_advanced_settings"));
        }
    }

    static {
        isCacheInvalid = true;
    }
}

