/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.keepsafe.switchboard.Preferences;
import com.keepsafe.switchboard.SwitchBoard;
import java.util.LinkedList;
import java.util.List;
import org.mozilla.gecko.GeckoSharedPrefs;

public class Experiments {
    private static final String LOGTAG = "GeckoExperiments";
    public static final String WHATSNEW_NOTIFICATION = "whatsnew-notification";
    public static final String CONTENT_NOTIFICATIONS_12HRS = "content-notifications-12hrs";
    public static final String CONTENT_NOTIFICATIONS_8AM = "content-notifications-8am";
    public static final String CONTENT_NOTIFICATIONS_5PM = "content-notifications-5pm";
    public static final String ONBOARDING3_A = "onboarding3-a";
    public static final String ONBOARDING3_B = "onboarding3-b";
    public static final String ONBOARDING3_C = "onboarding3-c";
    public static final String DOWNLOAD_CONTENT_CATALOG_SYNC = "download-content-catalog-sync";
    public static final String PROMOTE_ADD_TO_HOMESCREEN = "promote-add-to-homescreen";
    public static final String PREF_ONBOARDING_VERSION = "onboarding_version";
    public static final String TRIPLE_READERVIEW_BOOKMARK_PROMPT = "triple-readerview-bookmark-prompt";
    public static final String URLBAR_SHOW_ORIGIN_ONLY = "urlbar-show-origin-only";
    public static final String URLBAR_SHOW_EV_CERT_OWNER = "urlbar-show-ev-cert-owner";

    public static boolean isInExperimentLocal(Context context, String string) {
        if (SwitchBoard.isInBucket((Context)context, (int)0, (int)20)) {
            return ONBOARDING3_A.equals(string);
        }
        if (SwitchBoard.isInBucket((Context)context, (int)20, (int)60)) {
            return ONBOARDING3_B.equals(string);
        }
        if (SwitchBoard.isInBucket((Context)context, (int)60, (int)100)) {
            return ONBOARDING3_C.equals(string);
        }
        return false;
    }

    public static List<String> getActiveExperiments(Context context) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(SwitchBoard.getActiveExperiments((Context)context));
        String string = GeckoSharedPrefs.forProfile(context).getString(PREF_ONBOARDING_VERSION, null);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            linkedList.add(string);
        }
        return linkedList;
    }

    public static void setOverride(Context context, String string, boolean bl) {
        Log.d((String)LOGTAG, (String)("setOverride: " + string + " = " + bl));
        Preferences.setOverrideValue((Context)context, (String)string, (boolean)bl);
    }

    public static void clearOverride(Context context, String string) {
        Log.d((String)LOGTAG, (String)("clearOverride: " + string));
        Preferences.clearOverrideValue((Context)context, (String)string);
    }
}

