/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.Locale;
import org.json.JSONObject;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.widget.ContentSecurityDoorHanger;
import org.mozilla.gecko.widget.DefaultDoorHanger;
import org.mozilla.gecko.widget.DoorhangerConfig;
import org.mozilla.gecko.widget.LoginDoorHanger;

public abstract class DoorHanger
extends LinearLayout {
    private static final String LOGTAG = "GeckoDoorHanger";
    private final View mDivider;
    private final Button mNegativeButton;
    private final Button mPositiveButton;
    protected final OnButtonClickListener mOnButtonClickListener;
    private final int mTabId;
    private final String mIdentifier;
    protected final Type mType;
    protected final ImageView mIcon;
    protected final TextView mLink;
    protected final TextView mDoorhangerTitle;
    protected final Context mContext;
    protected final Resources mResources;
    protected int mDividerColor;
    protected boolean mPersistWhileVisible;
    protected int mPersistenceCount;
    protected long mTimeout;

    public static DoorHanger Get(Context context, DoorhangerConfig doorhangerConfig) {
        Type type = doorhangerConfig.getType();
        switch (type) {
            case LOGIN: {
                return new LoginDoorHanger(context, doorhangerConfig);
            }
            case TRACKING: {
                return new ContentSecurityDoorHanger(context, doorhangerConfig, type);
            }
        }
        return new DefaultDoorHanger(context, doorhangerConfig, type);
    }

    protected DoorHanger(Context context, DoorhangerConfig doorhangerConfig, Type type) {
        super(context);
        this.mContext = context;
        this.mResources = context.getResources();
        this.mTabId = doorhangerConfig.getTabId();
        this.mIdentifier = doorhangerConfig.getId();
        this.mType = type;
        LayoutInflater.from((Context)context).inflate(R.layout.doorhanger, (ViewGroup)this);
        this.setOrientation(1);
        this.mDivider = this.findViewById(R.id.divider_doorhanger);
        this.mIcon = (ImageView)this.findViewById(R.id.doorhanger_icon);
        this.mLink = (TextView)this.findViewById(R.id.doorhanger_link);
        this.mDoorhangerTitle = (TextView)this.findViewById(R.id.doorhanger_title);
        this.mNegativeButton = (Button)this.findViewById(R.id.doorhanger_button_negative);
        this.mPositiveButton = (Button)this.findViewById(R.id.doorhanger_button_positive);
        this.mOnButtonClickListener = doorhangerConfig.getButtonClickListener();
        this.mDividerColor = ContextCompat.getColor((Context)context, (int)R.color.toolbar_divider_grey);
        ViewStub viewStub = (ViewStub)this.findViewById(R.id.content);
        viewStub.setLayoutResource(this.getContentResource());
        viewStub.inflate();
        String string2 = this.mType.toString().toLowerCase(Locale.US);
        Telemetry.sendUIEvent(TelemetryContract.Event.SHOW, TelemetryContract.Method.DOORHANGER, string2);
    }

    protected abstract int getContentResource();

    protected abstract void loadConfig(DoorhangerConfig var1);

    protected void setOptions(JSONObject jSONObject) {
        int n = jSONObject.optInt("persistence");
        if (n > 0) {
            this.mPersistenceCount = n;
        }
        this.mPersistWhileVisible = jSONObject.optBoolean("persistWhileVisible");
        long l = jSONObject.optLong("timeout");
        if (l > 0L) {
            this.mTimeout = l;
        }
    }

    protected void addButtonsToLayout(DoorhangerConfig doorhangerConfig) {
        DoorhangerConfig.ButtonConfig buttonConfig = doorhangerConfig.getNegativeButtonConfig();
        DoorhangerConfig.ButtonConfig buttonConfig2 = doorhangerConfig.getPositiveButtonConfig();
        if (buttonConfig != null) {
            this.mNegativeButton.setText((CharSequence)buttonConfig.label);
            this.mNegativeButton.setOnClickListener(this.makeOnButtonClickListener(buttonConfig.callback, "negative"));
            this.mNegativeButton.setVisibility(0);
        }
        if (buttonConfig2 != null) {
            this.mPositiveButton.setText((CharSequence)buttonConfig2.label);
            this.mPositiveButton.setOnClickListener(this.makeOnButtonClickListener(buttonConfig2.callback, "positive"));
            this.mPositiveButton.setVisibility(0);
        }
    }

    public int getTabId() {
        return this.mTabId;
    }

    public String getIdentifier() {
        return this.mIdentifier;
    }

    public void showDivider() {
        this.mDivider.setVisibility(0);
    }

    public void hideDivider() {
        this.mDivider.setVisibility(8);
    }

    public void setIcon(int n) {
        this.mIcon.setImageResource(n);
        this.mIcon.setVisibility(0);
    }

    protected void addLink(String string2, final String string3) {
        this.mLink.setText((CharSequence)string2);
        this.mLink.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String string2 = DoorHanger.this.mType.toString().toLowerCase(Locale.US);
                Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.DOORHANGER, string2);
                Tabs.getInstance().loadUrlInTab(string3);
            }
        });
        this.mLink.setVisibility(0);
    }

    protected abstract View.OnClickListener makeOnButtonClickListener(int var1, String var2);

    public boolean shouldRemove(boolean bl) {
        if (this.mPersistWhileVisible && bl) {
            if (this.mPersistenceCount != 0) {
                --this.mPersistenceCount;
            }
            return false;
        }
        if (this.mPersistenceCount != 0) {
            --this.mPersistenceCount;
            return false;
        }
        return System.currentTimeMillis() > this.mTimeout;
    }

    public void showTitle(Bitmap bitmap, String string2) {
        this.mDoorhangerTitle.setText((CharSequence)string2);
        this.mDoorhangerTitle.setCompoundDrawablesWithIntrinsicBounds((Drawable)new BitmapDrawable(this.getResources(), bitmap), null, null, null);
        if (bitmap != null) {
            this.mDoorhangerTitle.setCompoundDrawablePadding((int)this.mContext.getResources().getDimension(R.dimen.doorhanger_drawable_padding));
        }
        this.mDoorhangerTitle.setVisibility(0);
    }

    public void hideTitle() {
        this.mDoorhangerTitle.setVisibility(8);
    }

    public static interface OnButtonClickListener {
        public void onButtonClick(JSONObject var1, DoorHanger var2);
    }

    public static enum Type {
        DEFAULT,
        LOGIN,
        TRACKING,
        GEOLOCATION,
        DESKTOPNOTIFICATION2,
        WEBRTC,
        VIBRATION;

    }
}

