/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.apache.commons.codec.binary;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.mozilla.apache.commons.codec.binary.BaseNCodec;

public class BaseNCodecInputStream
extends FilterInputStream {
    private final boolean doEncode;
    private final BaseNCodec baseNCodec;
    private final byte[] singleByte = new byte[1];

    protected BaseNCodecInputStream(InputStream inputStream, BaseNCodec baseNCodec, boolean bl) {
        super(inputStream);
        this.doEncode = bl;
        this.baseNCodec = baseNCodec;
    }

    @Override
    public int read() throws IOException {
        int n = this.read(this.singleByte, 0, 1);
        while (n == 0) {
            n = this.read(this.singleByte, 0, 1);
        }
        if (n > 0) {
            return this.singleByte[0] < 0 ? 256 + this.singleByte[0] : this.singleByte[0];
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n > byArray.length || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        while (n3 == 0) {
            if (!this.baseNCodec.hasData()) {
                byte[] byArray2 = new byte[this.doEncode ? 4096 : 8192];
                int n4 = this.in.read(byArray2);
                if (this.doEncode) {
                    this.baseNCodec.encode(byArray2, 0, n4);
                } else {
                    this.baseNCodec.decode(byArray2, 0, n4);
                }
            }
            n3 = this.baseNCodec.readResults(byArray, n, n2);
        }
        return n3;
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

