/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.widget.ImageView;
import com.squareup.picasso.Action;
import com.squareup.picasso.BitmapHunter;
import com.squareup.picasso.Callback;
import com.squareup.picasso.DeferredRequestCreator;
import com.squareup.picasso.FetchAction;
import com.squareup.picasso.GetAction;
import com.squareup.picasso.ImageViewAction;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.PicassoDrawable;
import com.squareup.picasso.Request;
import com.squareup.picasso.Target;
import com.squareup.picasso.TargetAction;
import com.squareup.picasso.Transformation;
import com.squareup.picasso.Utils;
import java.io.IOException;

public class RequestCreator {
    private final Picasso picasso;
    private final Request.Builder data;
    private boolean skipMemoryCache;
    private boolean noFade;
    private boolean deferred;
    private int placeholderResId;
    private Drawable placeholderDrawable;
    private int errorResId;
    private Drawable errorDrawable;

    RequestCreator(Picasso picasso, Uri uri, int n) {
        if (picasso.shutdown) {
            throw new IllegalStateException("Picasso instance already shut down. Cannot submit new requests.");
        }
        this.picasso = picasso;
        this.data = new Request.Builder(uri, n);
    }

    public RequestCreator placeholder(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("Placeholder image resource invalid.");
        }
        if (this.placeholderDrawable != null) {
            throw new IllegalStateException("Placeholder image already set.");
        }
        this.placeholderResId = n;
        return this;
    }

    public RequestCreator placeholder(Drawable drawable) {
        if (this.placeholderResId != 0) {
            throw new IllegalStateException("Placeholder image already set.");
        }
        this.placeholderDrawable = drawable;
        return this;
    }

    public RequestCreator error(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("Error image resource invalid.");
        }
        if (this.errorDrawable != null) {
            throw new IllegalStateException("Error image already set.");
        }
        this.errorResId = n;
        return this;
    }

    public RequestCreator error(Drawable drawable) {
        if (drawable == null) {
            throw new IllegalArgumentException("Error image may not be null.");
        }
        if (this.errorResId != 0) {
            throw new IllegalStateException("Error image already set.");
        }
        this.errorDrawable = drawable;
        return this;
    }

    public RequestCreator fit() {
        this.deferred = true;
        return this;
    }

    RequestCreator unfit() {
        this.deferred = false;
        return this;
    }

    public RequestCreator resizeDimen(int n, int n2) {
        Resources resources = this.picasso.context.getResources();
        int n3 = resources.getDimensionPixelSize(n);
        int n4 = resources.getDimensionPixelSize(n2);
        return this.resize(n3, n4);
    }

    public RequestCreator resize(int n, int n2) {
        this.data.resize(n, n2);
        return this;
    }

    public RequestCreator centerCrop() {
        this.data.centerCrop();
        return this;
    }

    public RequestCreator centerInside() {
        this.data.centerInside();
        return this;
    }

    public RequestCreator rotate(float f) {
        this.data.rotate(f);
        return this;
    }

    public RequestCreator rotate(float f, float f2, float f3) {
        this.data.rotate(f, f2, f3);
        return this;
    }

    public RequestCreator transform(Transformation transformation) {
        this.data.transform(transformation);
        return this;
    }

    public RequestCreator skipMemoryCache() {
        this.skipMemoryCache = true;
        return this;
    }

    public RequestCreator noFade() {
        this.noFade = true;
        return this;
    }

    public Bitmap get() throws IOException {
        Utils.checkNotMain();
        if (this.deferred) {
            throw new IllegalStateException("Fit cannot be used with get.");
        }
        if (!this.data.hasImage()) {
            return null;
        }
        Request request = this.picasso.transformRequest(this.data.build());
        String string = Utils.createKey(request);
        GetAction getAction = new GetAction(this.picasso, request, this.skipMemoryCache, string);
        return BitmapHunter.forRequest(this.picasso.context, this.picasso, this.picasso.dispatcher, this.picasso.cache, this.picasso.stats, getAction, this.picasso.dispatcher.downloader).hunt();
    }

    public void fetch() {
        if (this.deferred) {
            throw new IllegalStateException("Fit cannot be used with fetch.");
        }
        if (this.data.hasImage()) {
            Request request = this.picasso.transformRequest(this.data.build());
            String string = Utils.createKey(request);
            FetchAction fetchAction = new FetchAction(this.picasso, request, this.skipMemoryCache, string);
            this.picasso.enqueueAndSubmit(fetchAction);
        }
    }

    public void into(Target target) {
        Object object;
        Drawable drawable;
        if (target == null) {
            throw new IllegalArgumentException("Target must not be null.");
        }
        if (this.deferred) {
            throw new IllegalStateException("Fit cannot be used with a Target.");
        }
        Drawable drawable2 = drawable = this.placeholderResId != 0 ? this.picasso.context.getResources().getDrawable(this.placeholderResId) : this.placeholderDrawable;
        if (!this.data.hasImage()) {
            this.picasso.cancelRequest(target);
            target.onPrepareLoad(drawable);
            return;
        }
        Request request = this.picasso.transformRequest(this.data.build());
        String string = Utils.createKey(request);
        if (!this.skipMemoryCache && (object = this.picasso.quickMemoryCacheCheck(string)) != null) {
            this.picasso.cancelRequest(target);
            target.onBitmapLoaded((Bitmap)object, Picasso.LoadedFrom.MEMORY);
            return;
        }
        target.onPrepareLoad(drawable);
        object = new TargetAction(this.picasso, target, request, this.skipMemoryCache, string);
        this.picasso.enqueueAndSubmit((Action)object);
    }

    public void into(ImageView imageView) {
        this.into(imageView, null);
    }

    public void into(ImageView imageView, Callback callback) {
        Object object;
        if (imageView == null) {
            throw new IllegalArgumentException("Target must not be null.");
        }
        if (!this.data.hasImage()) {
            this.picasso.cancelRequest(imageView);
            PicassoDrawable.setPlaceholder(imageView, this.placeholderResId, this.placeholderDrawable);
            return;
        }
        if (this.deferred) {
            if (this.data.hasSize()) {
                throw new IllegalStateException("Fit cannot be used with resize.");
            }
            int n = imageView.getMeasuredWidth();
            int n2 = imageView.getMeasuredHeight();
            if (n == 0 || n2 == 0) {
                PicassoDrawable.setPlaceholder(imageView, this.placeholderResId, this.placeholderDrawable);
                this.picasso.defer(imageView, new DeferredRequestCreator(this, imageView, callback));
                return;
            }
            this.data.resize(n, n2);
        }
        Request request = this.picasso.transformRequest(this.data.build());
        String string = Utils.createKey(request);
        if (!this.skipMemoryCache && (object = this.picasso.quickMemoryCacheCheck(string)) != null) {
            this.picasso.cancelRequest(imageView);
            PicassoDrawable.setBitmap(imageView, this.picasso.context, object, Picasso.LoadedFrom.MEMORY, this.noFade, this.picasso.debugging);
            if (callback != null) {
                callback.onSuccess();
            }
            return;
        }
        PicassoDrawable.setPlaceholder(imageView, this.placeholderResId, this.placeholderDrawable);
        object = new ImageViewAction(this.picasso, imageView, request, this.skipMemoryCache, this.noFade, this.errorResId, this.errorDrawable, string, callback);
        this.picasso.enqueueAndSubmit((Action)object);
    }
}

