/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.RectF;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.location.Location;
import android.location.LocationListener;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.Process;
import android.os.StrictMode;
import android.os.SystemClock;
import android.provider.MediaStore;
import android.support.annotation.WorkerThread;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Base64;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.OrientationEventListener;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.AbsoluteLayout;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.SimpleAdapter;
import android.widget.TextView;
import android.widget.Toast;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.ActionBarTextSelection;
import org.mozilla.gecko.ActivityHandlerHelper;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.AppNotificationClient;
import org.mozilla.gecko.BrowserLocaleManager;
import org.mozilla.gecko.ContactService;
import org.mozilla.gecko.ContextGetter;
import org.mozilla.gecko.DevToolsAuthHelper;
import org.mozilla.gecko.DoorHangerPopup;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.FormAssistPopup;
import org.mozilla.gecko.GeckoAccessibility;
import org.mozilla.gecko.GeckoActivity;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoApplication;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoJavaSampler;
import org.mozilla.gecko.GeckoNetworkManager;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoProfileDirectories;
import org.mozilla.gecko.GeckoScreenOrientation;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.GlobalHistory;
import org.mozilla.gecko.GuestSession;
import org.mozilla.gecko.IntentHelper;
import org.mozilla.gecko.LocaleManager;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.MemoryMonitor;
import org.mozilla.gecko.MotionEventInterceptor;
import org.mozilla.gecko.NotificationClient;
import org.mozilla.gecko.NotificationHelper;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Restarter;
import org.mozilla.gecko.SessionParser;
import org.mozilla.gecko.SmsManager;
import org.mozilla.gecko.SnackbarHelper;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.TextSelectionHandle;
import org.mozilla.gecko.TouchEventInterceptor;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.db.UrlAnnotations;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.favicons.OnFaviconLoadedListener;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.gfx.FullScreenState;
import org.mozilla.gecko.gfx.Layer;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.gfx.PluginLayer;
import org.mozilla.gecko.health.HealthRecorder;
import org.mozilla.gecko.health.SessionInformation;
import org.mozilla.gecko.health.StubbedHealthRecorder;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.menu.GeckoMenu;
import org.mozilla.gecko.menu.GeckoMenuInflater;
import org.mozilla.gecko.menu.MenuPanel;
import org.mozilla.gecko.mozglue.GeckoLoader;
import org.mozilla.gecko.mozglue.SafeIntent;
import org.mozilla.gecko.permissions.Permissions;
import org.mozilla.gecko.preferences.GeckoPreferences;
import org.mozilla.gecko.prompts.PromptService;
import org.mozilla.gecko.restrictions.Restrictions;
import org.mozilla.gecko.tabqueue.TabQueueHelper;
import org.mozilla.gecko.text.FloatingToolbarTextSelection;
import org.mozilla.gecko.text.TextSelection;
import org.mozilla.gecko.updater.UpdateServiceHelper;
import org.mozilla.gecko.util.ActivityResultHandler;
import org.mozilla.gecko.util.ActivityUtils;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.FileUtils;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.GeckoRequest;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.util.IntentUtils;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSObject;
import org.mozilla.gecko.util.PrefUtils;
import org.mozilla.gecko.util.ThreadUtils;

public abstract class GeckoApp
extends GeckoActivity
implements ContextGetter,
GeckoAppShell.GeckoInterface,
GeckoEventListener,
GeckoMenu.Callback,
GeckoMenu.MenuPresenter,
LocationListener,
NativeEventListener,
SensorEventListener,
Tabs.OnTabsChangedListener,
ViewTreeObserver.OnGlobalLayoutListener {
    private static final String LOGTAG = "GeckoApp";
    private static final long ONE_DAY_MS = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS);
    public static final String ACTION_ALERT_CALLBACK = "org.mozilla.gecko.ACTION_ALERT_CALLBACK";
    public static final String ACTION_HOMESCREEN_SHORTCUT = "org.mozilla.gecko.BOOKMARK";
    public static final String ACTION_DEBUG = "org.mozilla.gecko.DEBUG";
    public static final String ACTION_LAUNCH_SETTINGS = "org.mozilla.gecko.SETTINGS";
    public static final String ACTION_LOAD = "org.mozilla.gecko.LOAD";
    public static final String ACTION_INIT_PW = "org.mozilla.gecko.INIT_PW";
    public static final String EXTRA_STATE_BUNDLE = "stateBundle";
    public static final String PREFS_ALLOW_STATE_BUNDLE = "allowStateBundle";
    public static final String PREFS_OOM_EXCEPTION = "OOMException";
    public static final String PREFS_VERSION_CODE = "versionCode";
    public static final String PREFS_WAS_STOPPED = "wasStopped";
    public static final String PREFS_CRASHED_COUNT = "crashedCount";
    public static final String PREFS_CLEANUP_TEMP_FILES = "cleanupTempFiles";
    public static final String SAVED_STATE_IN_BACKGROUND = "inBackground";
    public static final String SAVED_STATE_PRIVATE_SESSION = "privateSession";
    private static final int CLEANUP_DEFERRAL_SECONDS = 15;
    private static boolean sAlreadyLoaded;
    protected RelativeLayout mRootLayout;
    protected RelativeLayout mMainLayout;
    protected RelativeLayout mGeckoLayout;
    private View mCameraView;
    private OrientationEventListener mCameraOrientationEventListener;
    public List<GeckoAppShell.AppStateListener> mAppStateListeners = new LinkedList<GeckoAppShell.AppStateListener>();
    protected MenuPanel mMenuPanel;
    protected Menu mMenu;
    protected boolean mIsRestoringActivity;
    protected boolean mIsAbortingAppLaunch;
    private ContactService mContactService;
    private PromptService mPromptService;
    protected TextSelection mTextSelection;
    protected DoorHangerPopup mDoorHangerPopup;
    protected FormAssistPopup mFormAssistPopup;
    protected LayerView mLayerView;
    private AbsoluteLayout mPluginContainer;
    private FullScreenHolder mFullScreenPluginContainer;
    private View mFullScreenPluginView;
    private final HashMap<String, PowerManager.WakeLock> mWakeLocks = new HashMap();
    protected boolean mLastSessionCrashed;
    protected boolean mShouldRestore;
    private boolean mSessionRestoreParsingFinished = false;
    protected boolean mInitialized;
    protected boolean mWindowFocusInitialized;
    private Telemetry.Timer mJavaUiStartupTimer;
    private Telemetry.Timer mGeckoReadyStartupTimer;
    private String mPrivateBrowsingSession;
    private volatile HealthRecorder mHealthRecorder;
    private volatile Locale mLastLocale;
    private Intent mRestartIntent;
    private boolean mWasFirstTabShownAfterActivityUnhidden;
    private static final String CPU = "cpu";
    private static final String SCREEN = "screen";
    private static final String SESSION_END_LOCALE_CHANGED = "L";

    public abstract int getLayout();

    protected void processTabQueue() {
    }

    protected void openQueuedTabs() {
    }

    void toggleChrome(boolean bl) {
    }

    void focusChrome() {
    }

    @Override
    public Context getContext() {
        return this;
    }

    @Override
    public SharedPreferences getSharedPreferences() {
        return GeckoSharedPrefs.forApp((Context)this);
    }

    @Override
    public Activity getActivity() {
        return this;
    }

    @Override
    public LocationListener getLocationListener() {
        return this;
    }

    @Override
    public SensorEventListener getSensorEventListener() {
        return this;
    }

    @Override
    public View getCameraView() {
        return this.mCameraView;
    }

    @Override
    public void addAppStateListener(GeckoAppShell.AppStateListener appStateListener) {
        this.mAppStateListeners.add(appStateListener);
    }

    @Override
    public void removeAppStateListener(GeckoAppShell.AppStateListener appStateListener) {
        this.mAppStateListeners.remove(appStateListener);
    }

    @Override
    public FormAssistPopup getFormAssistPopup() {
        return this.mFormAssistPopup;
    }

    @Override
    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, String string2) {
        switch (tabEvents) {
            case UNSELECTED: {
                this.hidePlugins(tab);
                break;
            }
            case LOCATION_CHANGE: {
                if (!Tabs.getInstance().isSelectedTab(tab)) break;
            }
            case SELECTED: {
                this.invalidateOptionsMenu();
                if (this.mFormAssistPopup == null) break;
                this.mFormAssistPopup.hide();
                break;
            }
            case LOADED: {
                LayerView layerView = this.mLayerView;
                if (layerView == null || !Tabs.getInstance().isSelectedTab(tab)) break;
                layerView.setBackgroundColor(tab.getBackgroundColor());
                break;
            }
            case DESKTOP_MODE_CHANGE: {
                if (!Tabs.getInstance().isSelectedTab(tab)) break;
                this.invalidateOptionsMenu();
            }
        }
    }

    public void refreshChrome() {
    }

    @Override
    public void invalidateOptionsMenu() {
        if (this.mMenu == null) {
            return;
        }
        this.onPrepareOptionsMenu(this.mMenu);
        if (AppConstants.Versions.feature11Plus) {
            super.invalidateOptionsMenu();
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.mMenu = menu2;
        MenuInflater menuInflater = this.getMenuInflater();
        menuInflater.inflate(R.menu.gecko_app_menu, this.mMenu);
        return true;
    }

    public MenuInflater getMenuInflater() {
        return new GeckoMenuInflater((Context)this);
    }

    public MenuPanel getMenuPanel() {
        if (this.mMenuPanel == null) {
            this.onCreatePanelMenu(0, null);
            this.invalidateOptionsMenu();
        }
        return this.mMenuPanel;
    }

    @Override
    public boolean onMenuItemClick(MenuItem menuItem) {
        return this.onOptionsItemSelected(menuItem);
    }

    @Override
    public boolean onMenuItemLongClick(MenuItem menuItem) {
        return false;
    }

    @Override
    public void openMenu() {
        this.openOptionsMenu();
    }

    @Override
    public void showMenu(final View view) {
        this.closeMenu();
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GeckoApp.this.mMenuPanel.removeAllViews();
                GeckoApp.this.mMenuPanel.addView(view);
                GeckoApp.this.openOptionsMenu();
            }
        });
    }

    @Override
    public void closeMenu() {
        this.closeOptionsMenu();
    }

    public View onCreatePanelView(int n) {
        if (n == 0) {
            if (this.mMenuPanel == null) {
                this.mMenuPanel = new MenuPanel((Context)this, null);
            } else {
                this.onPreparePanel(n, (View)this.mMenuPanel, this.mMenu);
            }
            return this.mMenuPanel;
        }
        return super.onCreatePanelView(n);
    }

    public boolean onCreatePanelMenu(int n, Menu menu2) {
        if (n == 0) {
            if (this.mMenuPanel == null) {
                this.mMenuPanel = (MenuPanel)this.onCreatePanelView(n);
            }
            GeckoMenu geckoMenu = new GeckoMenu((Context)this, null);
            geckoMenu.setCallback(this);
            geckoMenu.setMenuPresenter(this);
            menu2 = geckoMenu;
            this.mMenuPanel.addView((View)geckoMenu);
            return this.onCreateOptionsMenu(menu2);
        }
        return super.onCreatePanelMenu(n, menu2);
    }

    public boolean onPreparePanel(int n, View view, Menu menu2) {
        if (n == 0) {
            return this.onPrepareOptionsMenu(menu2);
        }
        return super.onPreparePanel(n, view, menu2);
    }

    public boolean onMenuOpened(int n, Menu menu2) {
        if (this.mLayerView != null && this.mLayerView.isFullScreen()) {
            GeckoAppShell.notifyObservers("FullScreen:Exit", null);
        }
        if (n == 0) {
            if (this.mMenu == null) {
                MenuPanel menuPanel = this.getMenuPanel();
                this.onPreparePanel(n, (View)menuPanel, this.mMenu);
            }
            if (this.mMenuPanel != null) {
                this.mMenuPanel.scrollTo(0, 0);
            }
            return true;
        }
        return super.onMenuOpened(n, menu2);
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == R.id.quit) {
            GuestSession.hideNotification((Context)this);
            SharedPreferences sharedPreferences = GeckoSharedPrefs.forProfile((Context)this);
            Set set = PrefUtils.getStringSet((SharedPreferences)sharedPreferences, (String)"android.not_a_preference.history.clear_on_exit", new HashSet());
            JSONObject jSONObject = new JSONObject();
            for (String string2 : set) {
                try {
                    jSONObject.put(string2, true);
                }
                catch (JSONException jSONException) {
                    Log.e((String)LOGTAG, (String)("Error adding clear object " + string2), (Throwable)jSONException);
                }
            }
            JSONObject jSONObject2 = new JSONObject();
            try {
                jSONObject2.put("sanitize", (Object)jSONObject);
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)"Error adding sanitize object", (Throwable)jSONException);
            }
            if (jSONObject.has("private.data.history")) {
                String string2;
                string2 = this.getSessionRestorePreference(this.getSharedPreferences());
                try {
                    jSONObject2.put("dontSaveSession", "quit".equals(string2));
                }
                catch (JSONException jSONException) {
                    Log.e((String)LOGTAG, (String)"Error adding session restore data", (Throwable)jSONException);
                }
            }
            GeckoAppShell.notifyObservers("Browser:Quit", jSONObject2.toString());
            this.doShutdown();
            return true;
        }
        return super.onOptionsItemSelected(menuItem);
    }

    public void onOptionsMenuClosed(Menu menu2) {
        this.mMenuPanel.removeAllViews();
        this.mMenuPanel.addView((View)((GeckoMenu)this.mMenu));
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (n == 82) {
            this.openOptionsMenu();
            return true;
        }
        return super.onKeyDown(n, keyEvent);
    }

    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean(SAVED_STATE_IN_BACKGROUND, this.isApplicationInBackground());
        bundle.putString(SAVED_STATE_PRIVATE_SESSION, this.mPrivateBrowsingSession);
    }

    public void addTab() {
    }

    public void addPrivateTab() {
    }

    public void showNormalTabs() {
    }

    public void showPrivateTabs() {
    }

    public void hideTabs() {
    }

    public boolean autoHideTabs() {
        return false;
    }

    @Override
    public boolean areTabsShown() {
        return false;
    }

    public void handleMessage(String string2, NativeJSObject nativeJSObject, final EventCallback eventCallback) {
        if ("Accessibility:Ready".equals(string2)) {
            GeckoAccessibility.updateAccessibilitySettings((Context)this);
        } else if ("Bookmark:Insert".equals(string2)) {
            final String string3 = nativeJSObject.getString("url");
            final String string4 = nativeJSObject.getString("title");
            GeckoApp geckoApp = this;
            final BrowserDB browserDB = this.getProfile().getDB();
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    boolean bl = browserDB.addBookmark(GeckoApp.this.getContentResolver(), string4, string3);
                    final int n = bl ? R.string.bookmark_added : R.string.bookmark_already_added;
                    ThreadUtils.postToUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            SnackbarHelper.showSnackbar((Activity)GeckoApp.this, GeckoApp.this.getString(n), 0);
                        }
                    });
                }
            });
        } else if ("Contact:Add".equals(string2)) {
            String string5 = nativeJSObject.optString("email", null);
            String string6 = nativeJSObject.optString("phone", null);
            if (string5 != null) {
                Uri uri = Uri.parse((String)string5);
                Intent intent = new Intent("com.android.contacts.action.SHOW_OR_CREATE_CONTACT", uri);
                this.startActivity(intent);
            } else if (string6 != null) {
                Uri uri = Uri.parse((String)string6);
                Intent intent = new Intent("com.android.contacts.action.SHOW_OR_CREATE_CONTACT", uri);
                this.startActivity(intent);
            } else {
                Log.e((String)LOGTAG, (String)"Received Contact:Add message with no email nor phone number");
            }
        } else if ("DevToolsAuth:Scan".equals(string2)) {
            DevToolsAuthHelper.scan((Context)this, eventCallback);
        } else if ("DOMFullScreen:Start".equals(string2)) {
            LayerView layerView = this.mLayerView;
            if (layerView != null) {
                layerView.setFullScreenState(nativeJSObject.getBoolean("rootElement") ? FullScreenState.ROOT_ELEMENT : FullScreenState.NON_ROOT_ELEMENT);
            }
        } else if ("DOMFullScreen:Stop".equals(string2)) {
            LayerView layerView = this.mLayerView;
            if (layerView != null) {
                layerView.setFullScreenState(FullScreenState.NONE);
            }
        } else if ("Image:SetAs".equals(string2)) {
            String string7 = nativeJSObject.getString("url");
            this.setImageAs(string7);
        } else if ("Locale:Set".equals(string2)) {
            this.setLocale(nativeJSObject.getString("locale"));
        } else if ("Permissions:Data".equals(string2)) {
            NativeJSObject[] nativeJSObjectArray = nativeJSObject.getObjectArray("permissions");
            this.showSiteSettingsDialog(nativeJSObjectArray);
        } else if ("PrivateBrowsing:Data".equals(string2)) {
            this.mPrivateBrowsingSession = nativeJSObject.optString("session", null);
        } else if ("Session:StatePurged".equals(string2)) {
            this.onStatePurged();
        } else if ("Share:Text".equals(string2)) {
            String string8 = nativeJSObject.getString("text");
            Tab tab = Tabs.getInstance().getSelectedTab();
            String string9 = "";
            if (tab != null) {
                string9 = tab.getDisplayTitle();
            }
            IntentHelper.openUriExternal(string8, "text/plain", "", "", "android.intent.action.SEND", string9, false);
            Telemetry.sendUIEvent(TelemetryContract.Event.SHARE, TelemetryContract.Method.LIST, "text");
        } else if ("Snackbar:Show".equals(string2)) {
            SnackbarHelper.showSnackbar((Activity)this, nativeJSObject, eventCallback);
        } else if ("SystemUI:Visibility".equals(string2)) {
            this.setSystemUiVisible(nativeJSObject.getBoolean("visible"));
        } else if ("ToggleChrome:Focus".equals(string2)) {
            this.focusChrome();
        } else if ("ToggleChrome:Hide".equals(string2)) {
            this.toggleChrome(false);
        } else if ("ToggleChrome:Show".equals(string2)) {
            this.toggleChrome(true);
        } else if ("Update:Check".equals(string2)) {
            UpdateServiceHelper.checkForUpdate((Context)this);
        } else if ("Update:Download".equals(string2)) {
            UpdateServiceHelper.downloadUpdate((Context)this);
        } else if ("Update:Install".equals(string2)) {
            UpdateServiceHelper.applyUpdate((Context)this);
        } else if ("RuntimePermissions:Prompt".equals(string2)) {
            String[] stringArray = nativeJSObject.getStringArray("permissions");
            if (eventCallback == null || stringArray == null) {
                return;
            }
            Permissions.from((Context)this).withPermissions(stringArray).andFallback(new Runnable(){

                @Override
                public void run() {
                    eventCallback.sendSuccess((Object)false);
                }
            }).run(new Runnable(){

                @Override
                public void run() {
                    eventCallback.sendSuccess((Object)true);
                }
            });
        }
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        try {
            if (string2.equals("Gecko:Ready")) {
                this.mGeckoReadyStartupTimer.stop();
                this.geckoConnected();
                HealthRecorder healthRecorder = this.mHealthRecorder;
                if (healthRecorder != null) {
                    healthRecorder.recordGeckoStartupTime(this.mGeckoReadyStartupTimer.getElapsed());
                }
                GeckoApplication.get().onDelayedStartup();
            } else {
                if (string2.equals("Gecko:Exited")) {
                    this.doShutdown();
                    return;
                }
                if (string2.equals("Accessibility:Event")) {
                    GeckoAccessibility.sendAccessibilityEvent(jSONObject);
                }
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("Exception handling message \"" + string2 + "\":"), (Throwable)exception);
        }
    }

    void onStatePurged() {
    }

    private void showSiteSettingsDialog(NativeJSObject[] nativeJSObjectArray) {
        final AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle(R.string.site_settings_title);
        ArrayList arrayList = new ArrayList();
        for (NativeJSObject nativeJSObject : nativeJSObjectArray) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("setting", nativeJSObject.getString("setting"));
            hashMap.put("value", nativeJSObject.getString("value"));
            arrayList.add(hashMap);
        }
        builder.setSingleChoiceItems((ListAdapter)new SimpleAdapter((Context)this, arrayList, R.layout.site_setting_item, new String[]{"setting", "value"}, new int[]{R.id.setting, R.id.value}), -1, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
            }
        });
        builder.setPositiveButton(R.string.site_settings_clear, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                ListView listView = ((AlertDialog)dialogInterface).getListView();
                SparseBooleanArray sparseBooleanArray = listView.getCheckedItemPositions();
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < sparseBooleanArray.size(); ++i) {
                    if (!sparseBooleanArray.get(i)) continue;
                    jSONArray.put(i);
                }
                GeckoAppShell.notifyObservers("Permissions:Clear", jSONArray.toString());
            }
        });
        builder.setNegativeButton(R.string.site_settings_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                dialogInterface.cancel();
            }
        });
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AlertDialog alertDialog = builder.create();
                alertDialog.show();
                final ListView listView = alertDialog.getListView();
                if (listView != null) {
                    listView.setChoiceMode(2);
                }
                final Button button = alertDialog.getButton(-1);
                button.setEnabled(false);
                alertDialog.getListView().setOnItemClickListener(new AdapterView.OnItemClickListener(){

                    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                        if (AppConstants.Versions.feature11Plus) {
                            if (listView.getCheckedItemCount() == 0) {
                                button.setEnabled(false);
                            } else {
                                button.setEnabled(true);
                            }
                        } else {
                            SparseBooleanArray sparseBooleanArray = listView.getCheckedItemPositions();
                            for (int i = 0; i < sparseBooleanArray.size(); ++i) {
                                if (!sparseBooleanArray.valueAt(i)) continue;
                                button.setEnabled(true);
                                return;
                            }
                            button.setEnabled(false);
                        }
                    }
                });
            }
        });
    }

    private void addFullScreenPluginView(View view) {
        if (this.mFullScreenPluginView != null) {
            Log.w((String)LOGTAG, (String)"Already have a fullscreen plugin view");
            return;
        }
        this.setFullScreen(true);
        view.setWillNotDraw(false);
        if (view instanceof SurfaceView) {
            ((SurfaceView)view).setZOrderOnTop(true);
        }
        this.mFullScreenPluginContainer = new FullScreenHolder((Context)this);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1, 17);
        this.mFullScreenPluginContainer.addView(view, (ViewGroup.LayoutParams)layoutParams);
        FrameLayout frameLayout = (FrameLayout)this.getWindow().getDecorView();
        frameLayout.addView((View)this.mFullScreenPluginContainer, (ViewGroup.LayoutParams)layoutParams);
        this.mFullScreenPluginView = view;
    }

    @Override
    public void addPluginView(final View view, final RectF rectF, final boolean bl) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Tabs tabs = Tabs.getInstance();
                Tab tab = tabs.getSelectedTab();
                if (bl) {
                    GeckoApp.this.addFullScreenPluginView(view);
                    return;
                }
                PluginLayer pluginLayer = (PluginLayer)tab.getPluginLayer(view);
                if (pluginLayer == null) {
                    pluginLayer = new PluginLayer(view, rectF, GeckoApp.this.mLayerView.getRenderer().getMaxTextureSize());
                    tab.addPluginLayer(view, pluginLayer);
                } else {
                    pluginLayer.reset(rectF);
                    pluginLayer.setVisible(true);
                }
                GeckoApp.this.mLayerView.addLayer(pluginLayer);
            }
        });
    }

    private void removeFullScreenPluginView(View view) {
        if (this.mFullScreenPluginView == null) {
            Log.w((String)LOGTAG, (String)"Don't have a fullscreen plugin view");
            return;
        }
        if (this.mFullScreenPluginView != view) {
            Log.w((String)LOGTAG, (String)"Passed view is not the current full screen view");
            return;
        }
        this.mFullScreenPluginContainer.removeView(this.mFullScreenPluginView);
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GeckoApp.this.mLayerView.showSurface();
            }
        });
        FrameLayout frameLayout = (FrameLayout)this.getWindow().getDecorView();
        frameLayout.removeView((View)this.mFullScreenPluginContainer);
        this.mFullScreenPluginView = null;
        GeckoScreenOrientation.getInstance().unlock();
        this.setFullScreen(false);
    }

    @Override
    public void removePluginView(final View view, final boolean bl) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Tabs tabs = Tabs.getInstance();
                Tab tab = tabs.getSelectedTab();
                if (bl) {
                    GeckoApp.this.removeFullScreenPluginView(view);
                    return;
                }
                PluginLayer pluginLayer = (PluginLayer)tab.removePluginLayer(view);
                if (pluginLayer != null) {
                    pluginLayer.destroy();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setImageAs(String string2) {
        boolean bl = string2.startsWith("data:");
        Bitmap bitmap = null;
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            Object object;
            URL uRL;
            Object object2;
            int n;
            if (bl) {
                n = string2.indexOf(",");
                object2 = Base64.decode((String)string2.substring(n + 1), (int)0);
                bitmap = BitmapUtils.decodeByteArray(object2);
            } else {
                object2 = new byte[4192];
                byteArrayOutputStream = new ByteArrayOutputStream();
                uRL = new URL(string2);
                inputStream = uRL.openStream();
                while ((n = inputStream.read((byte[])object2)) != -1) {
                    byteArrayOutputStream.write((byte[])object2, 0, n);
                }
                object = byteArrayOutputStream.toByteArray();
                bitmap = BitmapUtils.decodeByteArray(object);
            }
            if (bitmap != null) {
                File file = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
                if (!file.mkdirs() && !file.isDirectory()) {
                    SnackbarHelper.showSnackbar((Activity)this, this.getString(R.string.set_image_path_fail), 0);
                    return;
                }
                object2 = MediaStore.Images.Media.insertImage((ContentResolver)this.getContentResolver(), (Bitmap)bitmap, null, null);
                if (object2 == null) {
                    SnackbarHelper.showSnackbar((Activity)this, this.getString(R.string.set_image_path_fail), 0);
                    return;
                }
                uRL = new Intent("android.intent.action.ATTACH_DATA");
                uRL.addCategory("android.intent.category.DEFAULT");
                uRL.setData(Uri.parse((String)object2));
                object = Intent.createChooser((Intent)uRL, (CharSequence)this.getString(R.string.set_image_chooser_title));
                ActivityResultHandler activityResultHandler = new ActivityResultHandler((Intent)uRL){
                    final /* synthetic */ Intent val$intent;
                    {
                        this.val$intent = intent;
                    }

                    public void onActivityResult(int n, Intent intent) {
                        GeckoApp.this.getContentResolver().delete(this.val$intent.getData(), null, null);
                    }
                };
                ActivityHandlerHelper.startIntentForActivity((Activity)this, (Intent)object, activityResultHandler);
            } else {
                SnackbarHelper.showSnackbar((Activity)this, this.getString(R.string.set_image_fail), 0);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Log.e((String)LOGTAG, (String)"Out of Memory when converting to byte array", (Throwable)outOfMemoryError);
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"I/O Exception while setting wallpaper", (Throwable)iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Log.w((String)LOGTAG, (String)"I/O Exception while closing stream", (Throwable)iOException);
                }
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    Log.w((String)LOGTAG, (String)"I/O Exception while closing stream", (Throwable)iOException);
                }
            }
        }
    }

    private int getBitmapSampleSize(BitmapFactory.Options options, int n, int n2) {
        int n3 = options.outWidth;
        int n4 = options.outHeight;
        int n5 = 1;
        if (n4 > n2 || n3 > n) {
            n5 = n3 > n4 ? Math.round((float)n4 / (float)n2) : Math.round((float)n3 / (float)n);
        }
        return n5;
    }

    private void hidePluginLayer(Layer layer) {
        LayerView layerView = this.mLayerView;
        layerView.removeLayer(layer);
        layerView.requestRender();
    }

    private void showPluginLayer(Layer layer) {
        LayerView layerView = this.mLayerView;
        layerView.addLayer(layer);
        layerView.requestRender();
    }

    public void requestRender() {
        this.mLayerView.requestRender();
    }

    public void hidePlugins(Tab tab) {
        for (Layer layer : tab.getPluginLayers()) {
            if (layer instanceof PluginLayer) {
                ((PluginLayer)layer).setVisible(false);
            }
            this.hidePluginLayer(layer);
        }
        this.requestRender();
    }

    public void showPlugins() {
        Tabs tabs = Tabs.getInstance();
        Tab tab = tabs.getSelectedTab();
        this.showPlugins(tab);
    }

    public void showPlugins(Tab tab) {
        for (Layer layer : tab.getPluginLayers()) {
            this.showPluginLayer(layer);
            if (!(layer instanceof PluginLayer)) continue;
            ((PluginLayer)layer).setVisible(true);
        }
        this.requestRender();
    }

    @Override
    public void setFullScreen(final boolean bl) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ActivityUtils.setFullScreen((Activity)GeckoApp.this, (boolean)bl);
            }
        });
    }

    protected static void earlyStartJavaSampler(SafeIntent safeIntent) {
        String string2 = safeIntent.getStringExtra("env0");
        int n = 1;
        while (string2 != null) {
            if (string2.startsWith("MOZ_PROFILER_STARTUP=")) {
                if (string2.endsWith("=")) break;
                GeckoJavaSampler.start(10, 1000);
                Log.d((String)LOGTAG, (String)"Profiling Java on startup");
                break;
            }
            string2 = safeIntent.getStringExtra("env" + n);
            ++n;
        }
    }

    @Override
    public void onCreate(Bundle object) {
        String string2;
        String string3;
        GeckoAppShell.ensureCrashHandling();
        if ("default".equals("nightly")) {
            this.enableStrictMode();
        }
        if (!HardwareUtils.isSupportedSystem()) {
            this.mIsAbortingAppLaunch = true;
            super.onCreate((Bundle)object);
            this.showSDKVersionError();
            this.finish();
            return;
        }
        this.mJavaUiStartupTimer = new Telemetry.UptimeTimer("FENNEC_STARTUP_TIME_JAVAUI");
        this.mGeckoReadyStartupTimer = new Telemetry.UptimeTimer("FENNEC_STARTUP_TIME_GECKOREADY");
        SafeIntent safeIntent = new SafeIntent(this.getIntent());
        GeckoApp.earlyStartJavaSampler(safeIntent);
        GeckoLoader.setLastIntent((SafeIntent)safeIntent);
        try {
            Class.forName("android.os.AsyncTask");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        MemoryMonitor.getInstance().init(this.getApplicationContext());
        GeckoAppShell.setContextGetter(this);
        GeckoAppShell.setApplicationContext(this.getApplicationContext());
        GeckoAppShell.setGeckoInterface(this);
        Tabs.getInstance().attachToContext((Context)this);
        try {
            Favicons.initializeWithContext((Context)this);
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Exception starting favicon cache. Corrupt resources?", (Throwable)exception);
        }
        if (BrowserLocaleManager.getInstance().systemLocaleDidChange()) {
            Log.i((String)LOGTAG, (String)"System locale changed. Restarting.");
            this.doRestart();
            return;
        }
        if (sAlreadyLoaded) {
            this.mIsRestoringActivity = true;
            Telemetry.addToHistogram("FENNEC_RESTORING_ACTIVITY", 1);
        } else {
            string3 = safeIntent.getAction();
            string2 = safeIntent.getStringExtra("args");
            sAlreadyLoaded = true;
            GeckoThread.init(null, string2, string3, ACTION_DEBUG.equals(string3));
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    GeckoApp.this.getProfile();
                }
            });
            String string4 = this.getURIFromIntent(safeIntent);
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                GeckoThread.speculativeConnect(string4);
            }
        }
        EventDispatcher.getInstance().registerGeckoThreadListener(this, new String[]{"Gecko:Ready", "Gecko:Exited", "Accessibility:Event"});
        EventDispatcher.getInstance().registerGeckoThreadListener(this, new String[]{"Accessibility:Ready", "Bookmark:Insert", "Contact:Add", "DevToolsAuth:Scan", "DOMFullScreen:Start", "DOMFullScreen:Stop", "Image:SetAs", "Locale:Set", "Permissions:Data", "PrivateBrowsing:Data", "RuntimePermissions:Prompt", "Session:StatePurged", "Share:Text", "Snackbar:Show", "SystemUI:Visibility", "ToggleChrome:Focus", "ToggleChrome:Hide", "ToggleChrome:Show", "Update:Check", "Update:Download", "Update:Install"});
        GeckoThread.launch();
        string3 = IntentUtils.getBundleExtraSafe((Intent)this.getIntent(), (String)EXTRA_STATE_BUNDLE);
        if (string3 != null) {
            string2 = this.getSharedPreferences();
            if (string2.getBoolean(PREFS_ALLOW_STATE_BUNDLE, false)) {
                string2.edit().remove(PREFS_ALLOW_STATE_BUNDLE).apply();
                object = string3;
            }
        } else if (object != null) {
            this.setIntent(new Intent("android.intent.action.MAIN"));
        }
        super.onCreate((Bundle)object);
        GeckoScreenOrientation.getInstance().update(this.getResources().getConfiguration().orientation);
        this.setContentView(this.getLayout());
        this.mRootLayout = (RelativeLayout)this.findViewById(R.id.root_layout);
        this.mGeckoLayout = (RelativeLayout)this.findViewById(R.id.gecko_layout);
        this.mMainLayout = (RelativeLayout)this.findViewById(R.id.main_layout);
        this.mLayerView = (LayerView)this.findViewById(R.id.layer_view);
        this.mMainLayout.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        this.mTextSelection = AppConstants.Versions.preMarshmallow ? new ActionBarTextSelection((TextSelectionHandle)this.findViewById(R.id.anchor_handle), (TextSelectionHandle)this.findViewById(R.id.caret_handle), (TextSelectionHandle)this.findViewById(R.id.focus_handle)) : new FloatingToolbarTextSelection((Activity)this, this.mLayerView);
        this.mTextSelection.create();
        this.mLastSessionCrashed = this.updateCrashedState();
        this.mShouldRestore = this.getSessionRestoreState((Bundle)object);
        if (this.mShouldRestore && object != null) {
            boolean bl = object.getBoolean(SAVED_STATE_IN_BACKGROUND, false);
            if (!bl && !this.mIsRestoringActivity) {
                Telemetry.addToHistogram("FENNEC_WAS_KILLED", 1);
            }
            this.mPrivateBrowsingSession = object.getString(SAVED_STATE_PRIVATE_SESSION);
        }
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GeckoApp geckoApp;
                String string2 = null;
                if (!GeckoApp.this.mIsRestoringActivity && GeckoApp.this.mShouldRestore) {
                    try {
                        geckoApp = new SafeIntent(GeckoApp.this.getIntent());
                        string2 = GeckoApp.this.restoreSessionTabs(GeckoApp.this.invokedWithExternalURL(GeckoApp.this.getIntentURI((SafeIntent)geckoApp)));
                    }
                    catch (SessionRestoreException sessionRestoreException) {
                        Log.e((String)GeckoApp.LOGTAG, (String)"An error occurred during restore", (Throwable)sessionRestoreException);
                        GeckoApp.this.mShouldRestore = false;
                    }
                }
                geckoApp = GeckoApp.this;
                synchronized (geckoApp) {
                    GeckoApp.this.mSessionRestoreParsingFinished = true;
                    GeckoApp.this.notifyAll();
                }
                if (!GeckoApp.this.mIsRestoringActivity) {
                    GeckoAppShell.notifyObservers("Session:Restore", string2);
                }
                GeckoApp.this.getProfile().updateSessionFile(GeckoApp.this.mShouldRestore);
            }
        });
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SharedPreferences sharedPreferences = GeckoApp.this.getSharedPreferences();
                LocaleManager localeManager = BrowserLocaleManager.getInstance();
                localeManager.initialize(GeckoApp.this.getApplicationContext());
                SessionInformation sessionInformation = SessionInformation.fromSharedPrefs(sharedPreferences);
                if (sessionInformation.wasKilled()) {
                    Telemetry.addToHistogram("FENNEC_WAS_KILLED", 1);
                }
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.putBoolean(GeckoApp.PREFS_OOM_EXCEPTION, false);
                editor.putBoolean(GeckoApp.PREFS_WAS_STOPPED, false);
                editor.apply();
                String string2 = GeckoApp.this.getProfile().getDir().getAbsolutePath();
                EventDispatcher eventDispatcher = EventDispatcher.getInstance();
                Locale locale = Locale.getDefault();
                String string3 = locale.toString();
                String string4 = localeManager.getAndApplyPersistedLocale((Context)GeckoApp.this);
                Log.d((String)GeckoApp.LOGTAG, (String)("OS locale is " + string3 + ", app locale is " + string4));
                if (string4 == null) {
                    string4 = string3;
                }
                GeckoApp.this.mHealthRecorder = GeckoApp.this.createHealthRecorder((Context)GeckoApp.this, string2, eventDispatcher, string3, string4, sessionInformation);
                final String string5 = string4;
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GeckoApp.this.onLocaleReady(string5);
                    }
                });
                BrowserLocaleManager.storeAndNotifyOSLocale(GeckoSharedPrefs.forProfile((Context)GeckoApp.this), locale);
            }
        });
        GeckoAppShell.setNotificationClient(this.makeNotificationClient());
        IntentHelper.init((FragmentActivity)this);
    }

    public void onStart() {
        super.onStart();
        if (this.mIsAbortingAppLaunch) {
            return;
        }
        this.mWasFirstTabShownAfterActivityUnhidden = false;
    }

    protected void onStop() {
        super.onStop();
        if (this.mIsAbortingAppLaunch) {
            return;
        }
    }

    @Override
    public void onLocaleReady(String string2) {
        TextView textView;
        if (!ThreadUtils.isOnUiThread()) {
            throw new RuntimeException("onLocaleReady must always be called from the UI thread.");
        }
        Locale locale = Locales.parseLocaleCode((String)string2);
        if (locale.equals(this.mLastLocale)) {
            Log.d((String)LOGTAG, (String)"New locale same as old; onLocaleReady has nothing to do.");
        }
        if ((textView = (TextView)this.findViewById(R.id.url_bar_title)) != null) {
            String string3 = this.getResources().getString(R.string.url_bar_default_text);
            textView.setHint((CharSequence)string3);
        } else {
            Log.d((String)LOGTAG, (String)"No URL bar in GeckoApp. Not loading localized hint string.");
        }
        this.mLastLocale = locale;
        super.onConfigurationChanged(this.getResources().getConfiguration());
    }

    protected void initializeChrome() {
        this.mDoorHangerPopup = new DoorHangerPopup((Context)this);
        this.mPluginContainer = (AbsoluteLayout)this.findViewById(R.id.plugin_container);
        this.mFormAssistPopup = (FormAssistPopup)this.findViewById(R.id.form_assist_popup);
    }

    protected void loadStartupTab(int n) {
        if (!this.mShouldRestore) {
            if (this.mLastSessionCrashed) {
                Tabs.getInstance().loadUrl(AboutPages.getURLForBuiltinPanelType(HomeConfig.PanelType.DEPRECATED_RECENT_TABS), n);
            } else {
                String string2 = this.getHomepage();
                Tabs.getInstance().loadUrl(!TextUtils.isEmpty((CharSequence)string2) ? string2 : "about:home", n);
            }
        }
    }

    protected void loadStartupTab(String string2, SafeIntent safeIntent, int n) {
        if (string2 == null) {
            this.loadStartupTab(n);
            return;
        }
        Tabs.getInstance().loadUrlWithIntentExtras(string2, safeIntent, n);
    }

    public String getHomepage() {
        return null;
    }

    private String getIntentURI(SafeIntent safeIntent) {
        String string2 = this.getURIFromIntent(safeIntent);
        String string3 = !TextUtils.isEmpty((CharSequence)string2) ? string2 : null;
        return string3;
    }

    private boolean invokedWithExternalURL(String string2) {
        return string2 != null && !AboutPages.isAboutHome(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        this.mInitialized = true;
        final boolean bl = !this.mWasFirstTabShownAfterActivityUnhidden;
        this.mWasFirstTabShownAfterActivityUnhidden = true;
        final SafeIntent safeIntent = new SafeIntent(this.getIntent());
        final String string2 = safeIntent.getAction();
        final String string3 = this.getIntentURI(safeIntent);
        boolean bl2 = this.invokedWithExternalURL(string3);
        this.checkMigrateProfile();
        Tabs.registerOnTabsChangedListener(this);
        this.initializeChrome();
        GeckoApp geckoApp = this;
        synchronized (geckoApp) {
            while (!this.mSessionRestoreParsingFinished) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (bl2) {
            Tabs.getInstance().notifyListeners(null, Tabs.TabEvents.RESTORED);
            this.processActionViewIntent(new Runnable(){

                @Override
                public void run() {
                    int n = 131;
                    if (GeckoApp.ACTION_HOMESCREEN_SHORTCUT.equals(string2)) {
                        n |= 8;
                    }
                    if (bl) {
                        n |= 0x100;
                    }
                    GeckoApp.this.loadStartupTab(string3, safeIntent, n);
                }
            });
        } else {
            if (!this.mIsRestoringActivity) {
                this.loadStartupTab(1);
            }
            Tabs.getInstance().notifyListeners(null, Tabs.TabEvents.RESTORED);
            this.processTabQueue();
        }
        this.recordStartupActionTelemetry(string3, string2);
        if (ACTION_LAUNCH_SETTINGS.equals(string2)) {
            geckoApp = new Intent((Context)this, GeckoPreferences.class);
            geckoApp.putExtras(safeIntent.getUnsafe());
            this.startActivity((Intent)geckoApp);
        }
        this.mAppStateListeners = new LinkedList<GeckoAppShell.AppStateListener>();
        if (SmsManager.isEnabled()) {
            SmsManager.getInstance().start();
        }
        this.mContactService = new ContactService(EventDispatcher.getInstance(), (Activity)this);
        this.mPromptService = new PromptService((Context)this);
        this.mJavaUiStartupTimer.stop();
        final long l = this.mJavaUiStartupTimer.getElapsed();
        ThreadUtils.getBackgroundHandler().postDelayed(new Runnable(){

            @Override
            public void run() {
                HealthRecorder healthRecorder = GeckoApp.this.mHealthRecorder;
                if (healthRecorder != null) {
                    healthRecorder.recordJavaStartupTime(l);
                }
            }
        }, 50L);
        ThreadUtils.getBackgroundHandler().postDelayed(new Runnable(){

            @Override
            public void run() {
                UpdateServiceHelper.registerForUpdates((Context)GeckoApp.this);
            }
        }, 30000L);
        if (this.mIsRestoringActivity) {
            Tab tab = Tabs.getInstance().getSelectedTab();
            if (tab != null) {
                Tabs.getInstance().notifyListeners(tab, Tabs.TabEvents.SELECTED);
            }
            if (GeckoThread.isRunning()) {
                this.geckoConnected();
                GeckoAppShell.notifyObservers("Viewport:Flush", null);
            }
        }
        if (ACTION_ALERT_CALLBACK.equals(string2)) {
            this.processAlertCallback(safeIntent);
        }
    }

    @TargetApi(value=16)
    public void onGlobalLayout() {
        if (AppConstants.Versions.preJB) {
            this.mMainLayout.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        } else {
            this.mMainLayout.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        if (!this.mInitialized) {
            this.initialize();
        }
    }

    protected void processActionViewIntent(final Runnable runnable) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (TabQueueHelper.TAB_QUEUE_ENABLED && TabQueueHelper.shouldOpenTabQueueUrls((Context)GeckoApp.this)) {
                    EventDispatcher.getInstance().registerGeckoThreadListener(new NativeEventListener(){

                        public void handleMessage(String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
                            if ("Tabs:TabsOpened".equals(string2)) {
                                EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "Tabs:TabsOpened");
                                runnable.run();
                            }
                        }
                    }, "Tabs:TabsOpened");
                    TabQueueHelper.openQueuedUrls((Context)GeckoApp.this, GeckoApp.this.getProfile(), "tab_queue_url_list.json", true);
                } else {
                    runnable.run();
                }
            }
        });
    }

    @WorkerThread
    private String restoreSessionTabs(final boolean bl) throws SessionRestoreException {
        try {
            JSONArray jSONArray;
            String string2 = this.getProfile().readSessionFile(false);
            if (string2 == null) {
                throw new SessionRestoreException("Could not read from session file");
            }
            if (this.mShouldRestore) {
                jSONArray = new JSONArray();
                final JSONObject jSONObject = new JSONObject();
                SessionParser sessionParser = new SessionParser(){

                    @Override
                    public void onTabRead(final SessionParser.SessionTab sessionTab) {
                        JSONObject jSONObject2 = sessionTab.getTabObject();
                        int n = 1;
                        n |= bl || !sessionTab.isSelected() ? 16 : 0;
                        n |= jSONObject2.optBoolean("desktopMode") ? 32 : 0;
                        final Tab tab = Tabs.getInstance().loadUrl(sessionTab.getUrl(), n |= jSONObject2.optBoolean("isPrivate") ? 4 : 0);
                        ThreadUtils.postToUiThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                tab.updateTitle(sessionTab.getTitle());
                            }
                        });
                        try {
                            jSONObject2.put("tabId", tab.getId());
                        }
                        catch (JSONException jSONException) {
                            Log.e((String)GeckoApp.LOGTAG, (String)"JSON error", (Throwable)jSONException);
                        }
                        jSONArray.put((Object)jSONObject2);
                    }

                    @Override
                    public void onClosedTabsRead(JSONArray jSONArray2) throws JSONException {
                        jSONObject.put("closedTabs", (Object)jSONArray2);
                    }
                };
                if (this.mPrivateBrowsingSession == null) {
                    sessionParser.parse(string2);
                } else {
                    sessionParser.parse(string2, this.mPrivateBrowsingSession);
                }
                if (jSONArray.length() > 0) {
                    jSONObject.put("tabs", (Object)jSONArray);
                    string2 = new JSONObject().put("windows", (Object)new JSONArray().put((Object)jSONObject)).toString();
                } else {
                    throw new SessionRestoreException("No tabs could be read from session file");
                }
            }
            jSONArray = new JSONObject();
            jSONArray.put("sessionString", (Object)string2);
            return jSONArray.toString();
        }
        catch (JSONException jSONException) {
            throw new SessionRestoreException((Exception)((Object)jSONException));
        }
    }

    @Override
    public GeckoProfile getProfile() {
        return GeckoThread.getActiveProfile();
    }

    protected boolean updateCrashedState() {
        try {
            File file = new File(GeckoProfileDirectories.getMozillaDirectory((Context)this), "CRASHED");
            if (file.exists() && file.delete()) {
                this.getSharedPreferences().edit().putBoolean(PREFS_WAS_STOPPED, true).apply();
                return true;
            }
        }
        catch (GeckoProfileDirectories.NoMozillaDirectoryException noMozillaDirectoryException) {
            Log.e((String)LOGTAG, (String)"Cannot read crash flag: ", (Throwable)noMozillaDirectoryException);
        }
        return false;
    }

    protected boolean getSessionRestoreState(Bundle bundle) {
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        boolean bl = false;
        int n = this.getVersionCode();
        if (this.mLastSessionCrashed) {
            bl = this.incrementCrashCount(sharedPreferences) <= this.getSessionStoreMaxCrashResumes(sharedPreferences) && this.getSessionRestoreAfterCrashPreference(sharedPreferences);
        } else if (sharedPreferences.getInt(PREFS_VERSION_CODE, 0) != n) {
            sharedPreferences.edit().putInt(PREFS_VERSION_CODE, n).apply();
            bl = true;
        } else if (bundle != null || this.getSessionRestorePreference(sharedPreferences).equals("always") || this.getRestartFromIntent()) {
            bl = true;
        }
        return bl;
    }

    private int incrementCrashCount(SharedPreferences sharedPreferences) {
        int n = this.getSuccessiveCrashesCount(sharedPreferences) + 1;
        sharedPreferences.edit().putInt(PREFS_CRASHED_COUNT, n).apply();
        return n;
    }

    private int getSuccessiveCrashesCount(SharedPreferences sharedPreferences) {
        return sharedPreferences.getInt(PREFS_CRASHED_COUNT, 0);
    }

    private int getSessionStoreMaxCrashResumes(SharedPreferences sharedPreferences) {
        return sharedPreferences.getInt("browser.sessionstore.max_resumed_crashes", 1);
    }

    private boolean getSessionRestoreAfterCrashPreference(SharedPreferences sharedPreferences) {
        return sharedPreferences.getBoolean("browser.sessionstore.resume_from_crash", true);
    }

    private String getSessionRestorePreference(SharedPreferences sharedPreferences) {
        return sharedPreferences.getString("android.not_a_preference.restoreSession3", "always");
    }

    private boolean getRestartFromIntent() {
        return IntentUtils.getBooleanExtraSafe((Intent)this.getIntent(), (String)"didRestart", (boolean)false);
    }

    private void enableStrictMode() {
        Log.d((String)LOGTAG, (String)"Enabling Android StrictMode");
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder().detectAll().penaltyLog().build());
        StrictMode.setVmPolicy((StrictMode.VmPolicy)new StrictMode.VmPolicy.Builder().detectAll().penaltyLog().build());
    }

    @Override
    public void enableCameraView() {
        this.mCameraOrientationEventListener = new OrientationEventListener((Context)this){

            public void onOrientationChanged(int n) {
                if (GeckoApp.this.mAppStateListeners != null) {
                    for (GeckoAppShell.AppStateListener appStateListener : GeckoApp.this.mAppStateListeners) {
                        appStateListener.onOrientationChanged();
                    }
                }
            }
        };
        this.mCameraOrientationEventListener.enable();
        if (this.mCameraView instanceof SurfaceView) {
            if (AppConstants.Versions.feature11Plus) {
                this.mCameraView.setAlpha(0.0f);
            }
            ViewGroup viewGroup = (ViewGroup)this.findViewById(R.id.camera_layout);
            viewGroup.addView(this.mCameraView, (ViewGroup.LayoutParams)new AbsoluteLayout.LayoutParams(8, 16, 0, 0));
        }
    }

    @Override
    public void disableCameraView() {
        if (this.mCameraOrientationEventListener != null) {
            this.mCameraOrientationEventListener.disable();
            this.mCameraOrientationEventListener = null;
        }
        if (this.mCameraView != null) {
            ViewGroup viewGroup = (ViewGroup)this.findViewById(R.id.camera_layout);
            viewGroup.removeView(this.mCameraView);
        }
    }

    @Override
    public String getDefaultUAString() {
        return HardwareUtils.isTablet() ? AppConstants.USER_AGENT_FENNEC_TABLET : AppConstants.USER_AGENT_FENNEC_MOBILE;
    }

    @Override
    public void createShortcut(final String string2, String string3) {
        Favicons.getPreferredIconForHomeScreenShortcut((Context)this, string3, new OnFaviconLoadedListener(){

            @Override
            public void onFaviconLoaded(String string22, String string3, Bitmap bitmap) {
                GeckoApp.this.doCreateShortcut(string2, string22, bitmap);
            }
        });
    }

    private void doCreateShortcut(String string2, String string3, Bitmap bitmap) {
        Intent intent = new Intent();
        intent.setAction(ACTION_HOMESCREEN_SHORTCUT);
        intent.setData(Uri.parse((String)string3));
        intent.setClassName("org.mozilla.fennec", "org.mozilla.gecko.BrowserApp");
        Intent intent2 = new Intent();
        intent2.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)intent);
        intent2.putExtra("android.intent.extra.shortcut.ICON", (Parcelable)BitmapUtils.getLauncherIcon(this.getApplicationContext(), bitmap, GeckoAppShell.getPreferredIconSize()));
        if (string2 != null) {
            intent2.putExtra("android.intent.extra.shortcut.NAME", string2);
        } else {
            intent2.putExtra("android.intent.extra.shortcut.NAME", string3);
        }
        intent2.putExtra("duplicate", false);
        intent2.setAction("com.android.launcher.action.INSTALL_SHORTCUT");
        this.getApplicationContext().sendBroadcast(intent2);
        UrlAnnotations urlAnnotations = GeckoProfile.get(this.getApplicationContext()).getDB().getUrlAnnotations();
        urlAnnotations.insertHomeScreenShortcut(this.getContentResolver(), string3, true);
    }

    private void processAlertCallback(SafeIntent safeIntent) {
        String string2 = "";
        String string3 = "";
        Uri uri = safeIntent.getData();
        if (uri != null) {
            string2 = uri.getQueryParameter("name");
            if (string2 == null) {
                string2 = "";
            }
            if ((string3 = uri.getQueryParameter("cookie")) == null) {
                string3 = "";
            }
        }
        this.handleNotification(ACTION_ALERT_CALLBACK, string2, string3);
    }

    protected void onNewIntent(Intent intent) {
        final SafeIntent safeIntent = new SafeIntent(intent);
        final boolean bl = !this.mWasFirstTabShownAfterActivityUnhidden;
        this.mWasFirstTabShownAfterActivityUnhidden = true;
        if (!this.mInitialized) {
            this.setIntent(intent);
            return;
        }
        String string2 = safeIntent.getAction();
        String string3 = this.getURIFromIntent(safeIntent);
        String string4 = !TextUtils.isEmpty((CharSequence)string3) ? string3 : null;
        if (ACTION_LOAD.equals(string2)) {
            Tabs.getInstance().loadUrl(safeIntent.getDataString());
        } else if ("android.intent.action.VIEW".equals(string2)) {
            this.processActionViewIntent(new Runnable(){

                @Override
                public void run() {
                    String string2 = safeIntent.getDataString();
                    int n = 131;
                    if (bl) {
                        n |= 0x100;
                    }
                    Tabs.getInstance().loadUrlWithIntentExtras(string2, safeIntent, n);
                }
            });
        } else if (ACTION_HOMESCREEN_SHORTCUT.equals(string2)) {
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBookmarkLoadEvent(string3));
        } else if ("android.intent.action.SEARCH".equals(string2)) {
            GeckoAppShell.sendEventToGecko(GeckoEvent.createURILoadEvent(string3));
        } else if (ACTION_ALERT_CALLBACK.equals(string2)) {
            this.processAlertCallback(safeIntent);
        } else if ("org.mozilla.fennec.helperBroadcastAction".equals(string2)) {
            NotificationHelper.getInstance(this.getApplicationContext()).handleNotificationIntent(safeIntent);
        } else if (ACTION_LAUNCH_SETTINGS.equals(string2)) {
            Intent intent2 = new Intent((Context)this, GeckoPreferences.class);
            intent2.putExtras(safeIntent.getUnsafe());
            this.startActivity(intent2);
        }
        this.recordStartupActionTelemetry(string4, string2);
    }

    protected String getURIFromIntent(SafeIntent safeIntent) {
        String string2 = safeIntent.getAction();
        if (ACTION_ALERT_CALLBACK.equals(string2) || "org.mozilla.fennec.helperBroadcastAction".equals(string2)) {
            return null;
        }
        return safeIntent.getDataString();
    }

    protected int getOrientation() {
        return GeckoScreenOrientation.getInstance().getAndroidOrientation();
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.mIsAbortingAppLaunch) {
            return;
        }
        int n = this.getResources().getConfiguration().orientation;
        if (GeckoScreenOrientation.getInstance().update(n)) {
            this.refreshChrome();
        }
        if (!AppConstants.Versions.feature14Plus) {
            GeckoAccessibility.updateAccessibilitySettings((Context)this);
        }
        if (this.mAppStateListeners != null) {
            for (GeckoAppShell.AppStateListener appStateListener : this.mAppStateListeners) {
                appStateListener.onResume();
            }
        }
        final long l = System.currentTimeMillis();
        final long l2 = SystemClock.elapsedRealtime();
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SessionInformation sessionInformation = new SessionInformation(l, l2);
                SharedPreferences sharedPreferences = GeckoApp.this.getSharedPreferences();
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.putBoolean(GeckoApp.PREFS_WAS_STOPPED, false);
                if (!GeckoApp.this.mLastSessionCrashed) {
                    editor.putInt(GeckoApp.PREFS_CRASHED_COUNT, 0);
                }
                sessionInformation.recordBegin(editor);
                editor.apply();
                HealthRecorder healthRecorder = GeckoApp.this.mHealthRecorder;
                if (healthRecorder != null) {
                    healthRecorder.setCurrentSession(sessionInformation);
                    healthRecorder.processDelayed();
                } else {
                    Log.w((String)GeckoApp.LOGTAG, (String)"Can't record session: rec is null.");
                }
            }
        });
        Restrictions.update((Context)this);
    }

    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (!this.mWindowFocusInitialized && bl) {
            this.mWindowFocusInitialized = true;
            this.mLayerView.setFocusable(false);
            this.mLayerView.setFocusable(true);
            this.mLayerView.setFocusableInTouchMode(true);
            this.getWindow().setBackgroundDrawable(null);
        }
    }

    @Override
    public void onPause() {
        if (this.mIsAbortingAppLaunch) {
            super.onPause();
            return;
        }
        final HealthRecorder healthRecorder = this.mHealthRecorder;
        GeckoApp geckoApp = this;
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SharedPreferences sharedPreferences = GeckoApp.this.getSharedPreferences();
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.putBoolean(GeckoApp.PREFS_WAS_STOPPED, true);
                if (healthRecorder != null) {
                    healthRecorder.recordSessionEnd("P", editor);
                }
                GeckoApp.this.mLastSessionCrashed = false;
                if (sharedPreferences.getBoolean(GeckoApp.PREFS_CLEANUP_TEMP_FILES, true)) {
                    File file = GeckoLoader.getGREDir((Context)GeckoApp.this);
                    FileUtils.delTree((File)file, (FilenameFilter)new FileUtils.NameAndAgeFilter(null, (double)ONE_DAY_MS), (boolean)false);
                    editor.putBoolean(GeckoApp.PREFS_CLEANUP_TEMP_FILES, false);
                }
                editor.apply();
            }
        });
        if (this.mAppStateListeners != null) {
            for (GeckoAppShell.AppStateListener appStateListener : this.mAppStateListeners) {
                appStateListener.onPause();
            }
        }
        super.onPause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRestart() {
        if (this.mIsAbortingAppLaunch) {
            super.onRestart();
            return;
        }
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            SharedPreferences.Editor editor = this.getSharedPreferences().edit();
            editor.putBoolean(PREFS_WAS_STOPPED, false);
            editor.apply();
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
        super.onRestart();
    }

    @Override
    public void onDestroy() {
        if (this.mIsAbortingAppLaunch) {
            super.onDestroy();
            return;
        }
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, new String[]{"Gecko:Ready", "Gecko:Exited", "Accessibility:Event"});
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, new String[]{"Accessibility:Ready", "Bookmark:Insert", "Contact:Add", "DOMFullScreen:Start", "DOMFullScreen:Stop", "Image:SetAs", "Locale:Set", "Permissions:Data", "PrivateBrowsing:Data", "RuntimePermissions:Prompt", "Session:StatePurged", "Share:Text", "Snackbar:Show", "SystemUI:Visibility", "ToggleChrome:Focus", "ToggleChrome:Hide", "ToggleChrome:Show", "Update:Check", "Update:Download", "Update:Install"});
        GeckoApp.deleteTempFiles();
        if (this.mDoorHangerPopup != null) {
            this.mDoorHangerPopup.destroy();
        }
        if (this.mFormAssistPopup != null) {
            this.mFormAssistPopup.destroy();
        }
        if (this.mContactService != null) {
            this.mContactService.destroy();
        }
        if (this.mPromptService != null) {
            this.mPromptService.destroy();
        }
        if (this.mTextSelection != null) {
            this.mTextSelection.destroy();
        }
        NotificationHelper.destroy();
        IntentHelper.destroy();
        GeckoNetworkManager.destroy();
        if (SmsManager.isEnabled()) {
            SmsManager.getInstance().stop();
            if (this.isFinishing()) {
                SmsManager.getInstance().shutdown();
            }
        }
        final HealthRecorder healthRecorder = this.mHealthRecorder;
        this.mHealthRecorder = null;
        if (healthRecorder != null && healthRecorder.isEnabled()) {
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    healthRecorder.close((Context)GeckoApp.this);
                }
            });
        }
        Favicons.close();
        super.onDestroy();
        Tabs.unregisterOnTabsChangedListener(this);
        if (!this.isFinishing()) {
            return;
        }
        if (GeckoThread.isStateAtLeast(GeckoThread.State.PROFILE_READY)) {
            GeckoThread.waitOnGecko();
        }
        if (this.mRestartIntent != null) {
            Intent intent = new Intent();
            intent.setClass(this.getApplicationContext(), Restarter.class).putExtra("pid", Process.myPid()).putExtra("android.intent.extra.INTENT", (Parcelable)this.mRestartIntent);
            this.startService(intent);
        } else {
            Process.killProcess((int)Process.myPid());
        }
    }

    public void showSDKVersionError() {
        String string2 = this.getString(R.string.unsupported_sdk_version, new Object[]{Build.CPU_ABI, Build.VERSION.SDK_INT});
        Toast.makeText((Context)this, (CharSequence)string2, (int)1).show();
    }

    public static File getTempDirectory() {
        File file = GeckoApplication.get().getExternalFilesDir("temp");
        return file;
    }

    public static void deleteTempFiles() {
        File file = GeckoApp.getTempDirectory();
        if (file == null) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            file2.delete();
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
        Log.d((String)LOGTAG, (String)("onConfigurationChanged: " + configuration.locale));
        LocaleManager localeManager = BrowserLocaleManager.getInstance();
        Locale locale = localeManager.onSystemConfigurationChanged((Context)this, this.getResources(), configuration, this.mLastLocale);
        if (locale != null) {
            this.onLocaleChanged(Locales.getLanguageTag((Locale)locale));
        }
        if (GeckoScreenOrientation.getInstance().update(configuration.orientation)) {
            if (this.mFormAssistPopup != null) {
                this.mFormAssistPopup.hide();
            }
            this.refreshChrome();
        }
        super.onConfigurationChanged(configuration);
    }

    public String getContentProcessName() {
        return "libplugin-container.so";
    }

    public void addEnvToIntent(Intent intent) {
        Map<String, String> map = System.getenv();
        Set<Map.Entry<String, String>> set = map.entrySet();
        Iterator<Map.Entry<String, String>> iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            intent.putExtra("env" + n, entry.getKey() + "=" + entry.getValue());
            ++n;
        }
    }

    @Override
    public void doRestart() {
        this.doRestart(null, null);
    }

    public void doRestart(String string2) {
        this.doRestart(string2, null);
    }

    public void doRestart(Intent intent) {
        this.doRestart(null, intent);
    }

    public void doRestart(String string2, Intent intent) {
        if (intent == null) {
            intent = new Intent("android.intent.action.MAIN");
        }
        if (string2 != null) {
            intent.putExtra("args", string2);
        }
        this.mRestartIntent = intent;
        Log.d((String)LOGTAG, (String)("doRestart(\"" + intent + "\")"));
        this.doShutdown();
    }

    private void doShutdown() {
        this.runOnUiThread(new Runnable(){

            @Override
            @TargetApi(value=17)
            public void run() {
                if (!(GeckoApp.this.isFinishing() || !AppConstants.Versions.preJBMR1 && GeckoApp.this.isDestroyed())) {
                    GeckoApp.this.finish();
                }
            }
        });
    }

    public void handleNotification(String string2, String string3, String string4) {
        if (GeckoThread.isRunning()) {
            GeckoAppShell.handleNotification(string2, string3, string4);
        }
    }

    private void checkMigrateProfile() {
        File file = this.getProfile().getDir();
        if (file != null) {
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    Handler handler = new Handler();
                    handler.postDelayed((Runnable)new DeferredCleanupTask(), 15000L);
                }
            });
        }
    }

    public void onBackPressed() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() > 0) {
            super.onBackPressed();
            return;
        }
        if (this.autoHideTabs()) {
            return;
        }
        if (this.mDoorHangerPopup != null && this.mDoorHangerPopup.isShowing()) {
            this.mDoorHangerPopup.dismiss();
            return;
        }
        if (this.mFullScreenPluginView != null) {
            GeckoAppShell.onFullScreenPluginHidden(this.mFullScreenPluginView);
            this.removeFullScreenPluginView(this.mFullScreenPluginView);
            return;
        }
        if (this.mLayerView != null && this.mLayerView.isFullScreen()) {
            GeckoAppShell.notifyObservers("FullScreen:Exit", null);
            return;
        }
        final Tabs tabs = Tabs.getInstance();
        final Tab tab = tabs.getSelectedTab();
        if (tab == null) {
            this.moveTaskToBack(true);
            return;
        }
        GeckoAppShell.sendRequestToGecko(new GeckoRequest("Browser:OnBackPressed", null){

            public void onResponse(NativeJSObject nativeJSObject) {
                if (!nativeJSObject.getBoolean("handled")) {
                    this.onDefault();
                }
            }

            public void onError(NativeJSObject nativeJSObject) {
                this.onDefault();
            }

            private void onDefault() {
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (tab.doBack()) {
                            return;
                        }
                        if (tab.isExternal()) {
                            GeckoApp.this.moveTaskToBack(true);
                            tabs.closeTab(tab);
                            return;
                        }
                        int n = tab.getParentId();
                        Tab tab = tabs.getTab(n);
                        if (tab != null) {
                            tabs.closeTab(tab, tab);
                            return;
                        }
                        GeckoApp.this.moveTaskToBack(true);
                    }
                });
            }
        });
    }

    protected void onActivityResult(int n, int n2, Intent intent) {
        if (!ActivityHandlerHelper.handleActivityResult(n, n2, intent)) {
            super.onActivityResult(n, n2, intent);
        }
    }

    public void onRequestPermissionsResult(int n, String[] stringArray, int[] nArray) {
        Permissions.onRequestPermissionsResult((Activity)this, stringArray, nArray);
    }

    @Override
    public AbsoluteLayout getPluginContainer() {
        return this.mPluginContainer;
    }

    public void onAccuracyChanged(Sensor sensor, int n) {
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        GeckoAppShell.sendEventToGecko(GeckoEvent.createSensorEvent(sensorEvent));
    }

    public void onLocationChanged(Location location) {
        GeckoAppShell.sendEventToGecko(GeckoEvent.createLocationEvent(location));
    }

    public void onProviderDisabled(String string2) {
    }

    public void onProviderEnabled(String string2) {
    }

    public void onStatusChanged(String string2, int n, Bundle bundle) {
    }

    @Override
    @SuppressLint(value={"Wakelock"})
    public void notifyWakeLockChanged(String string2, String string3) {
        PowerManager.WakeLock wakeLock = this.mWakeLocks.get(string2);
        if (string3.equals("locked-foreground") && wakeLock == null) {
            PowerManager powerManager = (PowerManager)this.getSystemService("power");
            if (CPU.equals(string2)) {
                wakeLock = powerManager.newWakeLock(1, string2);
            } else if (SCREEN.equals(string2)) {
                wakeLock = powerManager.newWakeLock(10, string2);
            }
            if (wakeLock != null) {
                wakeLock.acquire();
                this.mWakeLocks.put(string2, wakeLock);
            }
        } else if (!string3.equals("locked-foreground") && wakeLock != null) {
            wakeLock.release();
            this.mWakeLocks.remove(string2);
        }
    }

    @Override
    public void notifyCheckUpdateResult(String string2) {
        GeckoAppShell.notifyObservers("Update:CheckResult", string2);
    }

    private void geckoConnected() {
        this.mLayerView.setOverScrollMode(2);
    }

    @Override
    public void setAccessibilityEnabled(boolean bl) {
    }

    @Override
    public boolean openUriExternal(String string2, String string3, String string4, String string5, String string6, String string7) {
        return IntentHelper.openUriExternal(string2, string3, string4, string5, string6, string7, true);
    }

    protected NotificationClient makeNotificationClient() {
        return new AppNotificationClient(this.getApplicationContext());
    }

    private int getVersionCode() {
        int n = 0;
        try {
            n = this.getPackageManager().getPackageInfo((String)this.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.wtf((String)LOGTAG, (String)(this.getPackageName() + " not found"), (Throwable)nameNotFoundException);
        }
        return n;
    }

    protected void onLocaleChanged(final String string2) {
        HealthRecorder healthRecorder = this.mHealthRecorder;
        if (healthRecorder != null) {
            healthRecorder.onAppLocaleChanged(string2);
            healthRecorder.onEnvironmentChanged(true, SESSION_END_LOCALE_CHANGED);
        }
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GeckoApp.this.onLocaleReady(string2);
            }
        });
    }

    protected void setLocale(String string2) {
        if (string2 == null) {
            return;
        }
        String string3 = BrowserLocaleManager.getInstance().setSelectedLocale((Context)this, string2);
        if (string3 == null) {
            return;
        }
        this.onLocaleChanged(string3);
    }

    private void setSystemUiVisible(final boolean bl) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    GeckoApp.this.mMainLayout.setSystemUiVisibility(0);
                } else {
                    GeckoApp.this.mMainLayout.setSystemUiVisibility(1);
                }
            }
        });
    }

    protected HealthRecorder createHealthRecorder(Context context, String string2, EventDispatcher eventDispatcher, String string3, String string4, SessionInformation sessionInformation) {
        return new StubbedHealthRecorder();
    }

    protected void recordStartupActionTelemetry(String string2, String string3) {
    }

    @Override
    public void checkUriVisited(String string2) {
        GlobalHistory.getInstance().checkUriVisited(string2);
    }

    @Override
    public void markUriVisited(final String string2) {
        final Context context = this.getApplicationContext();
        final BrowserDB browserDB = GeckoProfile.get(context).getDB();
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GlobalHistory.getInstance().add(context, browserDB, string2);
            }
        });
    }

    @Override
    public void setUriTitle(final String string2, final String string3) {
        final Context context = this.getApplicationContext();
        final BrowserDB browserDB = GeckoProfile.get(context).getDB();
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GlobalHistory.getInstance().update(context.getContentResolver(), browserDB, string2, string3);
            }
        });
    }

    @Override
    public String[] getHandlersForMimeType(String string2, String string3) {
        Intent intent = IntentHelper.getIntentForActionString(string3);
        if (string2 != null && string2.length() > 0) {
            intent.setType(string2);
        }
        return IntentHelper.getHandlersForIntent(intent);
    }

    @Override
    public String[] getHandlersForURL(String string2, String string3) {
        Uri uri = string2.indexOf(58) >= 0 ? Uri.parse((String)string2) : new Uri.Builder().scheme(string2).build();
        Intent intent = IntentHelper.getOpenURIIntent(this.getApplicationContext(), uri.toString(), "", TextUtils.isEmpty((CharSequence)string3) ? "android.intent.action.VIEW" : string3, "");
        return IntentHelper.getHandlersForIntent(intent);
    }

    private class FullScreenHolder
    extends FrameLayout {
        public FullScreenHolder(Context context) {
            super(context);
        }

        public void addView(View view, int n) {
            super.addView(view, n);
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    GeckoApp.this.mLayerView.hideSurface();
                }
            });
        }

        public boolean onKeyDown(int n, KeyEvent keyEvent) {
            if (keyEvent.isSystem()) {
                return super.onKeyDown(n, keyEvent);
            }
            GeckoApp.this.mFullScreenPluginView.onKeyDown(n, keyEvent);
            return true;
        }

        public boolean onKeyUp(int n, KeyEvent keyEvent) {
            if (keyEvent.isSystem()) {
                return super.onKeyUp(n, keyEvent);
            }
            GeckoApp.this.mFullScreenPluginView.onKeyUp(n, keyEvent);
            return true;
        }

        public boolean onTouchEvent(MotionEvent motionEvent) {
            return true;
        }

        public boolean onTrackballEvent(MotionEvent motionEvent) {
            GeckoApp.this.mFullScreenPluginView.onTrackballEvent(motionEvent);
            return true;
        }
    }

    public static class MainLayout
    extends RelativeLayout {
        private TouchEventInterceptor mTouchEventInterceptor;
        private MotionEventInterceptor mMotionEventInterceptor;

        public MainLayout(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
            super.onLayout(bl, n, n2, n3, n4);
        }

        public void setTouchEventInterceptor(TouchEventInterceptor touchEventInterceptor) {
            this.mTouchEventInterceptor = touchEventInterceptor;
        }

        public void setMotionEventInterceptor(MotionEventInterceptor motionEventInterceptor) {
            this.mMotionEventInterceptor = motionEventInterceptor;
        }

        public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
            if (this.mTouchEventInterceptor != null && this.mTouchEventInterceptor.onInterceptTouchEvent((View)this, motionEvent)) {
                return true;
            }
            return super.onInterceptTouchEvent(motionEvent);
        }

        public boolean onTouchEvent(MotionEvent motionEvent) {
            if (this.mTouchEventInterceptor != null && this.mTouchEventInterceptor.onTouch((View)this, motionEvent)) {
                return true;
            }
            return super.onTouchEvent(motionEvent);
        }

        public boolean onGenericMotionEvent(MotionEvent motionEvent) {
            if (this.mMotionEventInterceptor != null && this.mMotionEventInterceptor.onInterceptMotionEvent((View)this, motionEvent)) {
                return true;
            }
            return super.onGenericMotionEvent(motionEvent);
        }

        public void setDrawingCacheEnabled(boolean bl) {
            super.setChildrenDrawnWithCacheEnabled(bl);
        }
    }

    private class DeferredCleanupTask
    implements Runnable {
        private static final String CLEANUP_VERSION = "cleanup-version";
        private static final int CURRENT_CLEANUP_VERSION = 1;

        private DeferredCleanupTask() {
        }

        @Override
        public void run() {
            File file;
            long l = GeckoApp.this.getSharedPreferences().getInt(CLEANUP_VERSION, 0);
            if (l < 1L && (file = new File("res/fonts")).exists() && file.isDirectory()) {
                for (File file2 : file.listFiles()) {
                    if (!file2.isFile() || !file2.getName().endsWith(".ttf")) continue;
                    file2.delete();
                }
                if (!file.delete()) {
                    Log.w((String)GeckoApp.LOGTAG, (String)"unable to delete res/fonts directory (not empty?)");
                }
            }
            if (l != 1L) {
                file = GeckoApp.this.getSharedPreferences().edit();
                file.putInt(CLEANUP_VERSION, 1);
                file.apply();
            }
        }
    }

    class SessionRestoreException
    extends Exception {
        public SessionRestoreException(Exception exception) {
            super(exception);
        }

        public SessionRestoreException(String string2) {
            super(string2);
        }
    }
}

