/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.content.res.Configuration;
import android.media.AudioManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.method.TextKeyListener;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.FormAssistPopup;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEditableClient;
import org.mozilla.gecko.GeckoEditableListener;
import org.mozilla.gecko.InputConnectionListener;
import org.mozilla.gecko.InputMethods;
import org.mozilla.gecko.util.Clipboard;
import org.mozilla.gecko.util.GamepadUtils;
import org.mozilla.gecko.util.ThreadUtils;

class GeckoInputConnection
extends BaseInputConnection
implements InputConnectionListener,
GeckoEditableListener {
    private static final boolean DEBUG = false;
    protected static final String LOGTAG = "GeckoInputConnection";
    private static final String CUSTOM_HANDLER_TEST_METHOD = "testInputConnection";
    private static final String CUSTOM_HANDLER_TEST_CLASS = "org.mozilla.gecko.tests.components.GeckoViewComponent$TextInput";
    private static final int INLINE_IME_MIN_DISPLAY_SIZE = 480;
    private static Handler sBackgroundHandler;
    private int mIMEState;
    private String mIMETypeHint = "";
    private String mIMEModeHint = "";
    private String mIMEActionHint = "";
    private String mCurrentInputMethod = "";
    private final View mView;
    private final GeckoEditableClient mEditableClient;
    protected int mBatchEditCount;
    private ExtractedTextRequest mUpdateRequest;
    private final ExtractedText mUpdateExtract = new ExtractedText();
    private boolean mBatchSelectionChanged;
    private boolean mBatchTextChanged;
    private final InputConnection mKeyInputConnection;

    public static GeckoEditableListener create(View view, GeckoEditableClient geckoEditableClient) {
        return new GeckoInputConnection(view, geckoEditableClient);
    }

    protected GeckoInputConnection(View view, GeckoEditableClient geckoEditableClient) {
        super(view, true);
        this.mView = view;
        this.mEditableClient = geckoEditableClient;
        this.mIMEState = 0;
        this.mKeyInputConnection = new BaseInputConnection(view, false);
    }

    public synchronized boolean beginBatchEdit() {
        ++this.mBatchEditCount;
        this.mEditableClient.setBatchMode(true);
        return true;
    }

    public synchronized boolean endBatchEdit() {
        if (this.mBatchEditCount > 0) {
            --this.mBatchEditCount;
            if (this.mBatchEditCount == 0) {
                if (this.mBatchTextChanged) {
                    this.notifyTextChange();
                    this.mBatchTextChanged = false;
                }
                if (this.mBatchSelectionChanged) {
                    Editable editable = this.getEditable();
                    this.notifySelectionChange(Selection.getSelectionStart((CharSequence)editable), Selection.getSelectionEnd((CharSequence)editable));
                    this.mBatchSelectionChanged = false;
                }
                this.mEditableClient.setBatchMode(false);
            }
        } else {
            Log.w((String)LOGTAG, (String)"endBatchEdit() called, but mBatchEditCount == 0?!");
        }
        return true;
    }

    public Editable getEditable() {
        return this.mEditableClient.getEditable();
    }

    public boolean performContextMenuAction(int n) {
        Editable editable = this.getEditable();
        if (editable == null) {
            return false;
        }
        int n2 = Selection.getSelectionStart((CharSequence)editable);
        int n3 = Selection.getSelectionEnd((CharSequence)editable);
        switch (n) {
            case 16908319: {
                this.setSelection(0, editable.length());
                break;
            }
            case 0x1020020: {
                if (n2 == n3) {
                    Clipboard.setText((CharSequence)editable);
                    editable.clear();
                    break;
                }
                Clipboard.setText((CharSequence)editable.toString().substring(Math.min(n2, n3), Math.max(n2, n3)));
                editable.delete(n2, n3);
                break;
            }
            case 0x1020022: {
                this.commitText(Clipboard.getText(), 1);
                break;
            }
            case 0x1020021: {
                String string2 = n2 == n3 ? "" : editable.toString().substring(Math.min(n2, n3), Math.max(n2, n3));
                Clipboard.setText((CharSequence)string2);
            }
        }
        return true;
    }

    public boolean performPrivateCommand(String string2, Bundle bundle) {
        switch (string2) {
            case "process-gecko-events": {
                Editable editable = this.getEditable();
                if (editable == null) {
                    return false;
                }
                editable.removeSpan(null);
                editable.length();
                return true;
            }
        }
        return false;
    }

    public ExtractedText getExtractedText(ExtractedTextRequest extractedTextRequest, int n) {
        Editable editable;
        if (extractedTextRequest == null) {
            return null;
        }
        if ((n & 1) != 0) {
            this.mUpdateRequest = extractedTextRequest;
        }
        if ((editable = this.getEditable()) == null) {
            return null;
        }
        int n2 = Selection.getSelectionStart((CharSequence)editable);
        int n3 = Selection.getSelectionEnd((CharSequence)editable);
        ExtractedText extractedText = new ExtractedText();
        extractedText.flags = 0;
        extractedText.partialStartOffset = -1;
        extractedText.partialEndOffset = -1;
        extractedText.selectionStart = n2;
        extractedText.selectionEnd = n3;
        extractedText.startOffset = 0;
        extractedText.text = (extractedTextRequest.flags & 1) != 0 ? new SpannableString((CharSequence)editable) : editable.toString();
        return extractedText;
    }

    private View getView() {
        return this.mView;
    }

    private InputMethodManager getInputMethodManager() {
        View view = this.getView();
        if (view == null) {
            return null;
        }
        Context context = view.getContext();
        return InputMethods.getInputMethodManager(context);
    }

    private void showSoftInput() {
        final View view = this.getView();
        final InputMethodManager inputMethodManager = this.getInputMethodManager();
        if (view == null || inputMethodManager == null) {
            return;
        }
        view.post(new Runnable(){

            @Override
            public void run() {
                if (view.hasFocus() && !inputMethodManager.isActive(view)) {
                    view.clearFocus();
                    view.requestFocus();
                }
                inputMethodManager.showSoftInput(view, 0);
            }
        });
    }

    private void hideSoftInput() {
        InputMethodManager inputMethodManager = this.getInputMethodManager();
        if (inputMethodManager != null) {
            View view = this.getView();
            inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    private void restartInput() {
        InputMethodManager inputMethodManager = this.getInputMethodManager();
        if (inputMethodManager == null) {
            return;
        }
        View view = this.getView();
        if (InputMethods.needsSoftResetWorkaround(this.mCurrentInputMethod)) {
            this.notifySelectionChange(-1, -1);
        }
        try {
            inputMethodManager.restartInput(view);
        }
        catch (RuntimeException runtimeException) {
            Log.e((String)LOGTAG, (String)"Error restarting input", (Throwable)runtimeException);
        }
    }

    private void resetInputConnection() {
        if (this.mBatchEditCount != 0) {
            Log.w((String)LOGTAG, (String)("resetting with mBatchEditCount = " + this.mBatchEditCount));
            this.mBatchEditCount = 0;
        }
        this.mBatchSelectionChanged = false;
        this.mBatchTextChanged = false;
    }

    @Override
    public void onTextChange(CharSequence charSequence, int n, int n2, int n3) {
        if (this.mUpdateRequest == null) {
            Editable editable = this.getEditable();
            if (editable != null) {
                this.onSelectionChange(Selection.getSelectionStart((CharSequence)editable), Selection.getSelectionEnd((CharSequence)editable));
            }
            return;
        }
        if (this.mBatchEditCount > 0) {
            this.mBatchTextChanged = true;
            return;
        }
        this.notifyTextChange();
    }

    private void notifyTextChange() {
        InputMethodManager inputMethodManager = this.getInputMethodManager();
        View view = this.getView();
        Editable editable = this.getEditable();
        if (inputMethodManager == null || view == null || editable == null) {
            return;
        }
        this.mUpdateExtract.flags = 0;
        this.mUpdateExtract.partialStartOffset = -1;
        this.mUpdateExtract.partialEndOffset = -1;
        this.mUpdateExtract.selectionStart = Selection.getSelectionStart((CharSequence)editable);
        this.mUpdateExtract.selectionEnd = Selection.getSelectionEnd((CharSequence)editable);
        this.mUpdateExtract.startOffset = 0;
        this.mUpdateExtract.text = (this.mUpdateRequest.flags & 1) != 0 ? new SpannableString((CharSequence)editable) : editable.toString();
        inputMethodManager.updateExtractedText(view, this.mUpdateRequest.token, this.mUpdateExtract);
    }

    @Override
    public void onSelectionChange(int n, int n2) {
        if (this.mBatchEditCount > 0) {
            this.mBatchSelectionChanged = true;
            return;
        }
        Editable editable = this.getEditable();
        if (editable != null) {
            this.notifySelectionChange(Selection.getSelectionStart((CharSequence)editable), Selection.getSelectionEnd((CharSequence)editable));
        }
    }

    private void notifySelectionChange(int n, int n2) {
        InputMethodManager inputMethodManager = this.getInputMethodManager();
        View view = this.getView();
        Editable editable = this.getEditable();
        if (inputMethodManager == null || view == null || editable == null) {
            return;
        }
        inputMethodManager.updateSelection(view, n, n2, GeckoInputConnection.getComposingSpanStart((Spannable)editable), GeckoInputConnection.getComposingSpanEnd((Spannable)editable));
    }

    @Override
    public void onDefaultKeyEvent(final KeyEvent keyEvent) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GeckoInputConnection.this.performDefaultKeyAction(keyEvent);
            }
        });
    }

    private static synchronized Handler getBackgroundHandler() {
        if (sBackgroundHandler != null) {
            return sBackgroundHandler;
        }
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Looper.prepare();
                Class<GeckoInputConnection> clazz = GeckoInputConnection.class;
                synchronized (GeckoInputConnection.class) {
                    sBackgroundHandler = new Handler();
                    GeckoInputConnection.class.notify();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    Looper.loop();
                    throw new IllegalThreadStateException("unreachable code");
                }
            }
        }, LOGTAG);
        thread.setDaemon(true);
        thread.start();
        while (sBackgroundHandler == null) {
            try {
                GeckoInputConnection.class.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return sBackgroundHandler;
    }

    private boolean canReturnCustomHandler() {
        if (this.mIMEState == 0) {
            return false;
        }
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            if ("startInputInner".equals(stackTraceElement.getMethodName()) && "android.view.inputmethod.InputMethodManager".equals(stackTraceElement.getClassName())) {
                return true;
            }
            if (!CUSTOM_HANDLER_TEST_METHOD.equals(stackTraceElement.getMethodName()) || !CUSTOM_HANDLER_TEST_CLASS.equals(stackTraceElement.getClassName())) continue;
            return true;
        }
        return false;
    }

    private boolean isPhysicalKeyboardPresent() {
        View view = this.getView();
        if (view == null) {
            return false;
        }
        Configuration configuration = view.getContext().getResources().getConfiguration();
        return configuration.keyboard != 1;
    }

    public Handler getHandler() {
        if (this.isPhysicalKeyboardPresent()) {
            return ThreadUtils.getUiHandler();
        }
        return GeckoInputConnection.getBackgroundHandler();
    }

    @Override
    public Handler getHandler(Handler handler) {
        if (!this.canReturnCustomHandler()) {
            return handler;
        }
        return this.mEditableClient.setInputConnectionHandler(this.getHandler());
    }

    @Override
    public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
        FormAssistPopup formAssistPopup;
        editorInfo.inputType = 1;
        editorInfo.imeOptions = 1;
        editorInfo.actionLabel = null;
        if (this.mIMEState == 0) {
            this.hideSoftInput();
            return null;
        }
        if (this.mIMEState == 2 || "password".equalsIgnoreCase(this.mIMETypeHint)) {
            editorInfo.inputType |= 0x80;
        } else if (this.mIMEState == 3) {
            editorInfo.inputType = 0;
        } else if (this.mIMETypeHint.equalsIgnoreCase("url")) {
            editorInfo.inputType |= 0x10;
        } else if (this.mIMETypeHint.equalsIgnoreCase("email")) {
            editorInfo.inputType |= 0x20;
        } else if (this.mIMETypeHint.equalsIgnoreCase("tel")) {
            editorInfo.inputType = 3;
        } else if (this.mIMETypeHint.equalsIgnoreCase("number") || this.mIMETypeHint.equalsIgnoreCase("range")) {
            editorInfo.inputType = 12290;
        } else if (this.mIMETypeHint.equalsIgnoreCase("week") || this.mIMETypeHint.equalsIgnoreCase("month")) {
            editorInfo.inputType = 20;
        } else if (this.mIMEModeHint.equalsIgnoreCase("numeric")) {
            editorInfo.inputType = 12290;
        } else if (this.mIMEModeHint.equalsIgnoreCase("digit")) {
            editorInfo.inputType = 2;
        } else {
            editorInfo.inputType |= 0x48000;
            if (this.mIMETypeHint.equalsIgnoreCase("textarea") || this.mIMETypeHint.length() == 0) {
                editorInfo.inputType |= 0x20000;
            }
            if (this.mIMEModeHint.equalsIgnoreCase("uppercase")) {
                editorInfo.inputType |= 0x1000;
            } else if (this.mIMEModeHint.equalsIgnoreCase("titlecase")) {
                editorInfo.inputType |= 0x2000;
            } else if (this.mIMETypeHint.equalsIgnoreCase("text") && !this.mIMEModeHint.equalsIgnoreCase("autocapitalized")) {
                editorInfo.inputType |= 0;
            } else if (!this.mIMEModeHint.equalsIgnoreCase("lowercase")) {
                editorInfo.inputType |= 0x4000;
            }
        }
        if (this.mIMEActionHint.equalsIgnoreCase("go")) {
            editorInfo.imeOptions = 2;
        } else if (this.mIMEActionHint.equalsIgnoreCase("done")) {
            editorInfo.imeOptions = 6;
        } else if (this.mIMEActionHint.equalsIgnoreCase("next")) {
            editorInfo.imeOptions = 5;
        } else if (this.mIMEActionHint.equalsIgnoreCase("search") || this.mIMETypeHint.equalsIgnoreCase("search")) {
            editorInfo.imeOptions = 3;
        } else if (this.mIMEActionHint.equalsIgnoreCase("send")) {
            editorInfo.imeOptions = 4;
        } else if (this.mIMEActionHint.length() > 0) {
            editorInfo.actionLabel = this.mIMEActionHint;
        }
        Context context = this.getView().getContext();
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        if (Math.min(displayMetrics.widthPixels, displayMetrics.heightPixels) > 480) {
            editorInfo.imeOptions |= 0x12000000;
        }
        String string2 = this.mCurrentInputMethod;
        this.mCurrentInputMethod = InputMethods.getCurrentInputMethod(context);
        if (!this.mCurrentInputMethod.equals(string2) && GeckoAppShell.getGeckoInterface() != null && (formAssistPopup = GeckoAppShell.getGeckoInterface().getFormAssistPopup()) != null) {
            formAssistPopup.onInputMethodChanged(this.mCurrentInputMethod);
        }
        if (this.mIMEState == 3) {
            editorInfo.initialSelStart = 0;
            editorInfo.initialSelEnd = 0;
            return this.mKeyInputConnection;
        }
        formAssistPopup = this.getEditable();
        editorInfo.initialSelStart = Selection.getSelectionStart((CharSequence)((Object)formAssistPopup));
        editorInfo.initialSelEnd = Selection.getSelectionEnd((CharSequence)((Object)formAssistPopup));
        this.showSoftInput();
        return this;
    }

    private boolean replaceComposingSpanWithSelection() {
        Editable editable = this.getEditable();
        if (editable == null) {
            return false;
        }
        int n = GeckoInputConnection.getComposingSpanStart((Spannable)editable);
        int n2 = GeckoInputConnection.getComposingSpanEnd((Spannable)editable);
        if (n != -1 && n2 != -1) {
            GeckoInputConnection.removeComposingSpans((Spannable)editable);
            Selection.setSelection((Spannable)editable, (int)n, (int)n2);
        }
        return true;
    }

    public boolean commitText(CharSequence charSequence, int n) {
        if (InputMethods.shouldCommitCharAsKey(this.mCurrentInputMethod) && charSequence.length() == 1 && n > 0) {
            return this.replaceComposingSpanWithSelection() && this.mKeyInputConnection.commitText(charSequence, n);
        }
        return super.commitText(charSequence, n);
    }

    public boolean setSelection(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return true;
        }
        return super.setSelection(n, n2);
    }

    void sendKeyEvent(int n, KeyEvent keyEvent) {
        boolean bl;
        Editable editable = this.getEditable();
        if (editable == null) {
            return;
        }
        TextKeyListener textKeyListener = TextKeyListener.getInstance();
        keyEvent = this.translateKey(keyEvent.getKeyCode(), keyEvent);
        View view = ThreadUtils.isOnUiThread() ? this.getView() : null;
        int n2 = keyEvent.getKeyCode();
        if (this.shouldSkipKeyListener(n2, keyEvent)) {
            bl = false;
        } else if (n == 0) {
            this.mEditableClient.setSuppressKeyUp(true);
            bl = textKeyListener.onKeyDown(view, editable, n2, keyEvent);
        } else {
            bl = n == 1 ? textKeyListener.onKeyUp(view, editable, n2, keyEvent) : textKeyListener.onKeyOther(view, editable, keyEvent);
        }
        if (!bl) {
            this.mEditableClient.sendKeyEvent(keyEvent, n, TextKeyListener.getMetaState((CharSequence)editable));
        }
        if (n == 0) {
            if (!bl) {
                TextKeyListener.adjustMetaAfterKeypress((Spannable)editable);
            }
            this.mEditableClient.setSuppressKeyUp(false);
        }
    }

    public boolean sendKeyEvent(KeyEvent keyEvent) {
        this.sendKeyEvent(keyEvent.getAction(), keyEvent);
        return false;
    }

    @Override
    public boolean onKeyPreIme(int n, KeyEvent keyEvent) {
        return false;
    }

    private boolean shouldProcessKey(int n, KeyEvent keyEvent) {
        switch (n) {
            case 4: 
            case 24: 
            case 25: 
            case 79: 
            case 82: 
            case 84: {
                return false;
            }
        }
        return true;
    }

    private boolean shouldSkipKeyListener(int n, KeyEvent keyEvent) {
        if (this.mIMEState == 0 || this.mIMEState == 3) {
            return true;
        }
        if (n == 66 || n == 61) {
            return true;
        }
        return n == 67 || n == 112;
    }

    private KeyEvent translateKey(int n, KeyEvent keyEvent) {
        switch (n) {
            case 66: {
                if ((keyEvent.getFlags() & 0x10) == 0 || !this.mIMEActionHint.equalsIgnoreCase("next")) break;
                return new KeyEvent(keyEvent.getAction(), 61);
            }
        }
        if (GamepadUtils.isSonyXperiaGamepadKeyEvent((KeyEvent)keyEvent)) {
            return GamepadUtils.translateSonyXperiaGamepadKeys((int)n, (KeyEvent)keyEvent);
        }
        return keyEvent;
    }

    void performDefaultKeyAction(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 222: {
                if (!AppConstants.Versions.feature19Plus) break;
                Context context = this.getView().getContext();
                AudioManager audioManager = (AudioManager)context.getSystemService("audio");
                audioManager.dispatchMediaKeyEvent(keyEvent);
            }
        }
    }

    private boolean processKey(final int n, int n2, final KeyEvent keyEvent) {
        if (n2 > KeyEvent.getMaxKeyCode() || !this.shouldProcessKey(n2, keyEvent)) {
            return false;
        }
        this.mEditableClient.postToInputConnection(new Runnable(){

            @Override
            public void run() {
                GeckoInputConnection.this.sendKeyEvent(n, keyEvent);
            }
        });
        return true;
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return this.processKey(0, n, keyEvent);
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return this.processKey(1, n, keyEvent);
    }

    private KeyEvent getCharKeyEvent(final char c) {
        long l = SystemClock.uptimeMillis();
        return new KeyEvent(l, l, 2, 0, 0){

            public int getUnicodeChar() {
                return c;
            }

            public int getUnicodeChar(int n) {
                return c;
            }
        };
    }

    @Override
    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
        if (n == 0) {
            String string2 = keyEvent.getCharacters();
            for (int i = 0; i < string2.length(); ++i) {
                KeyEvent keyEvent2 = this.getCharKeyEvent(string2.charAt(i));
                if (this.processKey(0, 0, keyEvent2) && this.processKey(1, 0, keyEvent2)) continue;
                return false;
            }
            return true;
        }
        while (n2-- != 0) {
            if (this.processKey(0, n, keyEvent) && this.processKey(1, n, keyEvent)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean onKeyLongPress(int n, KeyEvent keyEvent) {
        View view = this.getView();
        switch (n) {
            case 82: {
                InputMethodManager inputMethodManager = this.getInputMethodManager();
                inputMethodManager.toggleSoftInputFromWindow(view.getWindowToken(), 2, 0);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isIMEEnabled() {
        return this.mIMEState != 0;
    }

    @Override
    public void notifyIME(int n) {
        switch (n) {
            case 1: 
            case 2: {
                this.resetInputConnection();
                break;
            }
            case -2: {
                this.showSoftInput();
                break;
            }
        }
    }

    @Override
    public void notifyIMEContext(int n, String string2, String string3, String string4) {
        if (string2 != null && (string2.equalsIgnoreCase("date") || string2.equalsIgnoreCase("time") || AppConstants.Versions.feature11Plus && (string2.equalsIgnoreCase("datetime") || string2.equalsIgnoreCase("month") || string2.equalsIgnoreCase("week") || string2.equalsIgnoreCase("datetime-local")))) {
            n = 0;
        }
        this.mIMEState = n;
        this.mIMETypeHint = string2 == null ? "" : string2;
        this.mIMEModeHint = string3 == null ? "" : string3;
        this.mIMEActionHint = string4 == null ? "" : string4;
        this.mUpdateRequest = null;
        this.mCurrentInputMethod = "";
        View view = this.getView();
        if (view == null || !view.hasFocus()) {
            return;
        }
        this.restartInput();
    }
}

