/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.customtabs.CustomTabsActivity;
import org.mozilla.gecko.tabqueue.TabQueueHelper;
import org.mozilla.gecko.tabqueue.TabQueueService;

public class LauncherActivity
extends Activity {
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        GeckoAppShell.ensureCrashHandling();
        if (this.isViewIntentWithURL()) {
            this.dispatchViewIntent();
        } else {
            this.dispatchNormalIntent();
        }
        this.finish();
    }

    private void dispatchViewIntent() {
        if (TabQueueHelper.TAB_QUEUE_ENABLED && TabQueueHelper.isTabQueueEnabled((Context)this) && !this.getIntent().getBooleanExtra("skip_tab_queue", false)) {
            this.dispatchTabQueueIntent();
        } else {
            this.dispatchNormalIntent();
        }
    }

    private void dispatchTabQueueIntent() {
        Intent intent = new Intent(this.getIntent());
        intent.setClass(this.getApplicationContext(), TabQueueService.class);
        this.startService(intent);
    }

    private void dispatchNormalIntent() {
        Intent intent = new Intent(this.getIntent());
        intent.setClassName(this.getApplicationContext(), "org.mozilla.gecko.BrowserApp");
        this.startActivity(intent);
    }

    private void dispatchCustomTabsIntent() {
        Intent intent = new Intent(this.getIntent());
        intent.setClassName(this.getApplicationContext(), CustomTabsActivity.class.getName());
        this.startActivity(intent);
    }

    private boolean isViewIntentWithURL() {
        Intent intent = this.getIntent();
        return "android.intent.action.VIEW".equals(intent.getAction()) && intent.getDataString() != null;
    }

    private boolean isCustomTabsIntent() {
        return this.isViewIntentWithURL() && this.getIntent().hasExtra("android.support.customtabs.extra.SESSION");
    }
}

