/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.OnAccountsUpdateListener;
import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.util.Log;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.PrivateTab;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.ZoomConstraints;
import org.mozilla.gecko.annotation.JNITarget;
import org.mozilla.gecko.annotation.RobocopTarget;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.mozglue.SafeIntent;
import org.mozilla.gecko.reader.ReaderModeUtils;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;

public class Tabs
implements GeckoEventListener {
    private static final String LOGTAG = "GeckoTabs";
    private final CopyOnWriteArrayList<Tab> mOrder = new CopyOnWriteArrayList();
    private volatile Tab mSelectedTab;
    private final HashMap<Integer, Tab> mTabs = new HashMap();
    private AccountManager mAccountManager;
    private OnAccountsUpdateListener mAccountListener;
    public static final int LOADURL_NONE = 0;
    public static final int LOADURL_NEW_TAB = 1;
    public static final int LOADURL_USER_ENTERED = 2;
    public static final int LOADURL_PRIVATE = 4;
    public static final int LOADURL_PINNED = 8;
    public static final int LOADURL_DELAY_LOAD = 16;
    public static final int LOADURL_DESKTOP = 32;
    public static final int LOADURL_BACKGROUND = 64;
    public static final int LOADURL_EXTERNAL = 128;
    public static final int LOADURL_FIRST_AFTER_ACTIVITY_UNHIDDEN = 256;
    private static final long PERSIST_TABS_AFTER_MILLISECONDS = 2000L;
    public static final int INVALID_TAB_ID = -1;
    private static final AtomicInteger sTabId = new AtomicInteger(0);
    private volatile boolean mInitialTabsAdded;
    private Context mAppContext;
    private ContentObserver mBookmarksContentObserver;
    private PersistTabsRunnable mPersistTabsRunnable;
    private static final List<OnTabsChangedListener> TABS_CHANGED_LISTENERS = new CopyOnWriteArrayList<OnTabsChangedListener>();

    private Tabs() {
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "Tab:Added", "Tab:Close", "Tab:Select", "Tab:LoadedFromCache", "Content:LocationChange", "Content:SecurityChange", "Content:StateChange", "Content:LoadError", "Content:PageShow", "DOMContentLoaded", "DOMTitleChanged", "Link:Favicon", "Link:Feed", "Link:OpenSearch", "DesktopMode:Changed", "Tab:ViewportMetadata", "Tab:StreamStart", "Tab:StreamStop", "Tab:AudioPlayingChange");
    }

    public synchronized void attachToContext(Context context) {
        Context context2 = context.getApplicationContext();
        if (this.mAppContext == context2) {
            return;
        }
        if (this.mAppContext != null) {
            Log.w((String)LOGTAG, (String)"The application context has changed!");
        }
        this.mAppContext = context2;
        this.mAccountManager = AccountManager.get((Context)context2);
        this.mAccountListener = new OnAccountsUpdateListener(){

            public void onAccountsUpdated(Account[] accountArray) {
                Tabs.this.queuePersistAllTabs();
            }
        };
        this.mAccountManager.addOnAccountsUpdatedListener(this.mAccountListener, ThreadUtils.getBackgroundHandler(), false);
        if (this.mBookmarksContentObserver != null) {
            GeckoProfile geckoProfile = GeckoProfile.get(context);
            geckoProfile.getDB().registerBookmarkObserver(this.getContentResolver(), this.mBookmarksContentObserver);
        }
    }

    public synchronized int getDisplayCount() {
        boolean bl = this.mSelectedTab != null && this.mSelectedTab.isPrivate();
        int n = 0;
        for (Tab tab : this.mOrder) {
            if (tab.isPrivate() != bl) continue;
            ++n;
        }
        return n;
    }

    public int isOpen(String string2) {
        for (Tab tab : this.mOrder) {
            if (!tab.getURL().equals(string2)) continue;
            return tab.getId();
        }
        return -1;
    }

    private void lazyRegisterBookmarkObserver() {
        if (this.mBookmarksContentObserver == null) {
            this.mBookmarksContentObserver = new ContentObserver(null){

                public void onChange(boolean bl) {
                    for (Tab tab : Tabs.this.mOrder) {
                        tab.updateBookmark();
                    }
                }
            };
            GeckoProfile geckoProfile = GeckoProfile.get(this.mAppContext);
            geckoProfile.getDB().registerBookmarkObserver(this.getContentResolver(), this.mBookmarksContentObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tab addTab(int n, String string2, boolean bl, int n2, String string3, boolean bl2, int n3) {
        Tab tab = bl2 ? new PrivateTab(this.mAppContext, n, string2, bl, n2, string3) : new Tab(this.mAppContext, n, string2, bl, n2, string3);
        Tabs tabs = this;
        synchronized (tabs) {
            this.lazyRegisterBookmarkObserver();
            this.mTabs.put(n, tab);
            if (n3 > -1) {
                this.mOrder.add(n3, tab);
            } else {
                this.mOrder.add(tab);
            }
        }
        if (this.mInitialTabsAdded) {
            this.notifyListeners(tab, TabEvents.ADDED);
        }
        return tab;
    }

    public synchronized void removeTab(int n) {
        if (this.mTabs.containsKey(n)) {
            Tab tab = this.getTab(n);
            this.mOrder.remove(tab);
            this.mTabs.remove(n);
        }
    }

    public synchronized Tab selectTab(int n) {
        if (!this.mTabs.containsKey(n)) {
            return null;
        }
        Tab tab = this.getSelectedTab();
        Tab tab2 = this.mTabs.get(n);
        if (tab2 == null || tab == tab2) {
            return null;
        }
        this.mSelectedTab = tab2;
        this.notifyListeners(tab2, TabEvents.SELECTED);
        if (tab != null) {
            this.notifyListeners(tab, TabEvents.UNSELECTED);
        }
        GeckoAppShell.notifyObservers("Tab:Selected", String.valueOf(tab2.getId()));
        return tab2;
    }

    private int getIndexOf(Tab tab) {
        return this.mOrder.lastIndexOf(tab);
    }

    private Tab getNextTabFrom(Tab tab, boolean bl) {
        int n = this.mOrder.size();
        int n2 = this.getIndexOf(tab);
        for (int i = n2 + 1; i < n; ++i) {
            Tab tab2 = this.mOrder.get(i);
            if (tab2.isPrivate() != bl) continue;
            return tab2;
        }
        return null;
    }

    private Tab getPreviousTabFrom(Tab tab, boolean bl) {
        int n = this.getIndexOf(tab);
        for (int i = n - 1; i >= 0; --i) {
            Tab tab2 = this.mOrder.get(i);
            if (tab2.isPrivate() != bl) continue;
            return tab2;
        }
        return null;
    }

    @Nullable
    public Tab getSelectedTab() {
        return this.mSelectedTab;
    }

    public boolean isSelectedTab(Tab tab) {
        return tab != null && tab == this.mSelectedTab;
    }

    public boolean isSelectedTabId(int n) {
        Tab tab = this.mSelectedTab;
        return tab != null && tab.getId() == n;
    }

    @RobocopTarget
    public synchronized Tab getTab(int n) {
        if (n == -1) {
            return null;
        }
        if (this.mTabs.size() == 0) {
            return null;
        }
        if (!this.mTabs.containsKey(n)) {
            return null;
        }
        return this.mTabs.get(n);
    }

    public synchronized Tab getTabForApplicationId(String string2) {
        if (string2 == null) {
            return null;
        }
        for (Tab tab : this.mOrder) {
            if (!string2.equals(tab.getApplicationId())) continue;
            return tab;
        }
        return null;
    }

    @RobocopTarget
    public synchronized void closeTab(Tab tab) {
        this.closeTab(tab, this.getNextTab(tab));
    }

    public synchronized void closeTab(Tab tab, Tab tab2) {
        this.closeTab(tab, tab2, false);
    }

    public synchronized void closeTab(Tab tab, boolean bl) {
        this.closeTab(tab, this.getNextTab(tab), bl);
    }

    public synchronized void closeTab(Tab tab, Tab tab2, boolean bl) {
        if (tab == null) {
            return;
        }
        int n = tab.getId();
        this.removeTab(n);
        if (tab2 == null) {
            tab2 = this.loadUrl("about:home", 1);
        }
        this.selectTab(tab2.getId());
        tab.onDestroy();
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("tabId", (Object)String.valueOf(n));
            jSONObject.put("showUndoToast", bl);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)("Error building Tab:Closed arguments: " + (Object)((Object)jSONException)));
        }
        GeckoAppShell.notifyObservers("Tab:Closed", jSONObject.toString());
    }

    public Tab getNextTab(Tab tab) {
        Tab tab2;
        Tab tab3 = this.getSelectedTab();
        if (tab3 != tab) {
            return tab3;
        }
        boolean bl = tab.isPrivate();
        Tab tab4 = this.getNextTabFrom(tab, bl);
        if (tab4 == null) {
            tab4 = this.getPreviousTabFrom(tab, bl);
        }
        if (tab4 == null && bl) {
            tab2 = this.mOrder.get(this.mOrder.size() - 1);
            tab4 = !tab2.isPrivate() ? tab2 : this.getPreviousTabFrom(tab2, false);
        }
        if ((tab2 = this.getTab(tab.getParentId())) != null) {
            if (tab4 != null && tab4.getParentId() == tab.getParentId()) {
                return tab4;
            }
            return tab2;
        }
        return tab4;
    }

    public Iterable<Tab> getTabsInOrder() {
        return this.mOrder;
    }

    private synchronized Context getAppContext() {
        if (this.mAppContext == null) {
            throw new IllegalStateException("Tabs not initialized with a GeckoApp instance.");
        }
        return this.mAppContext;
    }

    public ContentResolver getContentResolver() {
        return this.getAppContext().getContentResolver();
    }

    @RobocopTarget
    public static Tabs getInstance() {
        return TabsInstanceHolder.INSTANCE;
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        Log.d((String)LOGTAG, (String)("handleMessage: " + string2));
        try {
            int n = jSONObject.getInt("tabID");
            Tab tab = this.getTab(n);
            if (string2.equals("Tab:Added")) {
                String string3;
                String string4 = string3 = jSONObject.isNull("uri") ? null : jSONObject.getString("uri");
                if (jSONObject.getBoolean("stub")) {
                    if (tab == null) {
                        return;
                    }
                } else {
                    tab = this.addTab(n, string3, jSONObject.getBoolean("external"), jSONObject.getInt("parentId"), jSONObject.getString("title"), jSONObject.getBoolean("isPrivate"), jSONObject.getInt("tabIndex"));
                    if (jSONObject.getBoolean("selected")) {
                        this.selectTab(n);
                    }
                }
                if (jSONObject.getBoolean("delayLoad")) {
                    tab.setState(0);
                }
                if (jSONObject.getBoolean("desktopMode")) {
                    tab.setDesktopMode(true);
                }
                return;
            }
            if (tab == null) {
                return;
            }
            if (string2.equals("Tab:Close")) {
                this.closeTab(tab);
            } else if (string2.equals("Tab:Select")) {
                this.selectTab(tab.getId());
            } else if (string2.equals("Content:LocationChange")) {
                tab.handleLocationChange(jSONObject);
            } else if (string2.equals("Content:SecurityChange")) {
                tab.updateIdentityData(jSONObject.getJSONObject("identity"));
                this.notifyListeners(tab, TabEvents.SECURITY_CHANGE);
            } else if (string2.equals("Content:StateChange")) {
                int n2 = jSONObject.getInt("state");
                if ((n2 & 0x40000) != 0) {
                    if ((n2 & 1) != 0) {
                        boolean bl = jSONObject.getBoolean("restoring");
                        tab.handleDocumentStart(bl, jSONObject.getString("uri"));
                        this.notifyListeners(tab, TabEvents.START);
                    } else if ((n2 & 0x10) != 0) {
                        tab.handleDocumentStop(jSONObject.getBoolean("success"));
                        this.notifyListeners(tab, TabEvents.STOP);
                    }
                }
            } else if (string2.equals("Content:LoadError")) {
                tab.handleContentLoaded();
                this.notifyListeners(tab, TabEvents.LOAD_ERROR);
            } else if (string2.equals("Content:PageShow")) {
                tab.setLoadedFromCache(jSONObject.getBoolean("fromCache"));
                tab.updateUserRequested(jSONObject.getString("userRequested"));
                this.notifyListeners(tab, TabEvents.PAGE_SHOW);
            } else if (string2.equals("DOMContentLoaded")) {
                tab.handleContentLoaded();
                String string5 = jSONObject.getString("bgColor");
                if (string5 != null) {
                    tab.setBackgroundColor(string5);
                } else {
                    tab.setBackgroundColor(-1);
                }
                tab.setErrorType(jSONObject.optString("errorType"));
                tab.setMetadata(jSONObject.optJSONObject("metadata"));
                this.notifyListeners(tab, TabEvents.LOADED);
            } else if (string2.equals("DOMTitleChanged")) {
                tab.updateTitle(jSONObject.getString("title"));
            } else if (string2.equals("Link:Favicon")) {
                if (!Favicons.canDecodeType(jSONObject.getString("mime"))) {
                    return;
                }
                tab.addFavicon(jSONObject.getString("href"), jSONObject.getInt("size"), jSONObject.getString("mime"));
                if (tab.getState() != 1) {
                    tab.loadFavicon();
                }
            } else if (string2.equals("Link:Feed")) {
                tab.setHasFeeds(true);
                this.notifyListeners(tab, TabEvents.LINK_FEED);
            } else if (string2.equals("Link:OpenSearch")) {
                boolean bl = jSONObject.getBoolean("visible");
                tab.setHasOpenSearch(bl);
            } else if (string2.equals("DesktopMode:Changed")) {
                tab.setDesktopMode(jSONObject.getBoolean("desktopMode"));
                this.notifyListeners(tab, TabEvents.DESKTOP_MODE_CHANGE);
            } else if (string2.equals("Tab:ViewportMetadata")) {
                tab.setZoomConstraints(new ZoomConstraints(jSONObject));
                tab.setIsRTL(jSONObject.getBoolean("isRTL"));
                this.notifyListeners(tab, TabEvents.VIEWPORT_CHANGE);
            } else if (string2.equals("Tab:StreamStart")) {
                tab.setRecording(true);
                this.notifyListeners(tab, TabEvents.RECORDING_CHANGE);
            } else if (string2.equals("Tab:StreamStop")) {
                tab.setRecording(false);
                this.notifyListeners(tab, TabEvents.RECORDING_CHANGE);
            } else if (string2.equals("Tab:AudioPlayingChange")) {
                tab.setIsAudioPlaying(jSONObject.getBoolean("isAudioPlaying"));
                this.notifyListeners(tab, TabEvents.AUDIO_PLAYING_CHANGE);
            }
        }
        catch (Exception exception) {
            Log.w((String)LOGTAG, (String)("handleMessage threw for " + string2), (Throwable)exception);
        }
    }

    public void refreshThumbnails() {
        final BrowserDB browserDB = GeckoProfile.get(this.mAppContext).getDB();
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (Tab tab : Tabs.this.mOrder) {
                    if (tab.getThumbnail() != null) continue;
                    tab.loadThumbnailFromDB(browserDB);
                }
            }
        });
    }

    public static void registerOnTabsChangedListener(OnTabsChangedListener onTabsChangedListener) {
        TABS_CHANGED_LISTENERS.add(onTabsChangedListener);
    }

    public static void unregisterOnTabsChangedListener(OnTabsChangedListener onTabsChangedListener) {
        TABS_CHANGED_LISTENERS.remove(onTabsChangedListener);
    }

    public void notifyListeners(Tab tab, TabEvents tabEvents) {
        this.notifyListeners(tab, tabEvents, "");
    }

    public void notifyListeners(final Tab tab, final TabEvents tabEvents, final String string2) {
        if (tab == null && tabEvents != TabEvents.RESTORED) {
            throw new IllegalArgumentException("onTabChanged:" + (Object)((Object)tabEvents) + " must specify a tab.");
        }
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Tabs.this.onTabChanged(tab, tabEvents, string2);
                if (TABS_CHANGED_LISTENERS.isEmpty()) {
                    return;
                }
                Iterator iterator = TABS_CHANGED_LISTENERS.iterator();
                while (iterator.hasNext()) {
                    ((OnTabsChangedListener)iterator.next()).onTabChanged(tab, tabEvents, string2);
                }
            }
        });
    }

    private void onTabChanged(Tab tab, TabEvents tabEvents, Object object) {
        switch (tabEvents) {
            case FAVICON: 
            case LOCATION_CHANGE: {
                this.queuePersistAllTabs();
                break;
            }
            case RESTORED: {
                this.mInitialTabsAdded = true;
                break;
            }
            case SELECTED: {
                this.queuePersistAllTabs();
            }
            case UNSELECTED: {
                tab.onChange();
                break;
            }
        }
    }

    private void queuePersistAllTabs() {
        Handler handler = ThreadUtils.getBackgroundHandler();
        if (this.mPersistTabsRunnable != null) {
            handler.removeCallbacks((Runnable)this.mPersistTabsRunnable);
            this.mPersistTabsRunnable = null;
        }
        this.mPersistTabsRunnable = new PersistTabsRunnable(this.mAppContext, this.getTabsInOrder());
        handler.postDelayed((Runnable)this.mPersistTabsRunnable, 2000L);
    }

    public Tab getFirstTabForUrl(String string2) {
        return this.getFirstTabForUrlHelper(string2, null);
    }

    public Tab getFirstTabForUrl(String string2, boolean bl) {
        return this.getFirstTabForUrlHelper(string2, bl);
    }

    private Tab getFirstTabForUrlHelper(String string2, Boolean bl) {
        if (string2 == null) {
            return null;
        }
        for (Tab tab : this.mOrder) {
            if (bl != null && bl.booleanValue() != tab.isPrivate() || !string2.equals(tab.getURL())) continue;
            return tab;
        }
        return null;
    }

    public Tab getFirstReaderTabForUrl(String string2, boolean bl) {
        if (string2 == null) {
            return null;
        }
        if (AboutPages.isAboutReader(string2)) {
            string2 = ReaderModeUtils.getUrlFromAboutReader(string2);
        }
        for (Tab tab : this.mOrder) {
            String string3;
            if (bl != tab.isPrivate() || !AboutPages.isAboutReader(string3 = tab.getURL()) || !string2.equals(string3 = ReaderModeUtils.getUrlFromAboutReader(string3))) continue;
            return tab;
        }
        return null;
    }

    @RobocopTarget
    public Tab loadUrl(String string2) {
        return this.loadUrl(string2, 0);
    }

    public Tab loadUrl(String string2, int n) {
        return this.loadUrl(string2, null, -1, null, n);
    }

    public Tab loadUrlWithIntentExtras(String string2, SafeIntent safeIntent, int n) {
        if (safeIntent.getBooleanExtra("whatsnew_notification", false)) {
            Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.NOTIFICATION, "whatsnew_notification");
        }
        return this.loadUrl(string2, null, -1, safeIntent, n);
    }

    public Tab loadUrl(String string2, String string3, int n, int n2) {
        return this.loadUrl(string2, string3, n, null, n2);
    }

    public Tab loadUrl(String string2, String string3, int n, SafeIntent safeIntent, int n2) {
        JSONObject jSONObject = new JSONObject();
        Tab tab = null;
        boolean bl = (n2 & 0x10) != 0;
        boolean bl2 = bl || (n2 & 0x40) != 0;
        try {
            Tab tab2;
            int n3;
            boolean bl3;
            String string4;
            boolean bl4 = (n2 & 4) != 0;
            boolean bl5 = (n2 & 2) != 0;
            boolean bl6 = (n2 & 0x20) != 0;
            boolean bl7 = (n2 & 0x80) != 0;
            boolean bl8 = (n2 & 0x100) != 0;
            jSONObject.put("url", (Object)string2);
            jSONObject.put("engine", (Object)string3);
            jSONObject.put("parentId", n);
            jSONObject.put("userEntered", bl5);
            jSONObject.put("isPrivate", bl4);
            jSONObject.put("pinned", (n2 & 8) != 0);
            jSONObject.put("desktopMode", bl6);
            String string5 = string4 = safeIntent == null ? null : safeIntent.getStringExtra("com.android.browser.application_id");
            if (string4 == null) {
                bl3 = (n2 & 1) != 0;
            } else {
                n3 = (AppConstants.Versions.feature12Plus ? safeIntent.getBooleanExtra("create_new_tab", false) : 0) ? 1 : 0;
                tab2 = this.getTabForApplicationId(string4);
                if (tab2 == null || n3 != 0) {
                    bl3 = true;
                } else {
                    bl3 = false;
                    bl = false;
                    bl2 = false;
                    tab = tab2;
                    int n4 = tab.getId();
                    jSONObject.put("tabID", n4);
                    this.selectTab(tab.getId());
                }
            }
            jSONObject.put("newTab", bl3);
            jSONObject.put("delayLoad", bl);
            jSONObject.put("selected", !bl2);
            if (bl3) {
                n3 = Tabs.getNextTabId();
                jSONObject.put("tabID", n3);
                tab2 = string2 != null && Uri.parse((String)string2).getScheme() != null ? string2 : null;
                tab = this.addTab(n3, (String)((Object)tab2), bl7, n, string2, bl4, -1);
                tab.setDesktopMode(bl6);
                tab.setApplicationId(string4);
                if (bl8) {
                    tab.setShouldShowToolbarWithoutAnimationOnFirstSelection(true);
                }
            }
        }
        catch (Exception exception) {
            Log.w((String)LOGTAG, (String)"Error building JSON arguments for loadUrl.", (Throwable)exception);
        }
        GeckoAppShell.notifyObservers("Tab:Load", jSONObject.toString());
        if (tab == null) {
            return null;
        }
        if (!bl && !bl2) {
            this.selectTab(tab.getId());
        }
        if (AboutPages.isBuiltinIconPage(string2)) {
            tab.loadFavicon();
        }
        return tab;
    }

    public Tab addTab() {
        return this.loadUrl("about:home", 1);
    }

    public Tab addPrivateTab() {
        return this.loadUrl("about:privatebrowsing", 5);
    }

    public void loadUrlInTab(String string2) {
        Iterable<Tab> iterable = this.getTabsInOrder();
        for (Tab tab : iterable) {
            if (!string2.equals(tab.getURL())) continue;
            this.selectTab(tab.getId());
            return;
        }
        int n = -1;
        int n2 = 1;
        Tab tab = this.getSelectedTab();
        if (tab != null) {
            n = tab.getId();
            if (tab.isPrivate()) {
                n2 |= 4;
            }
        }
        this.loadUrl(string2, null, n, n2);
    }

    @JNITarget
    public static int getNextTabId() {
        return sTabId.getAndIncrement();
    }

    public static enum TabEvents {
        CLOSED,
        START,
        LOADED,
        LOAD_ERROR,
        STOP,
        FAVICON,
        THUMBNAIL,
        TITLE,
        SELECTED,
        UNSELECTED,
        ADDED,
        RESTORED,
        LOCATION_CHANGE,
        MENU_UPDATED,
        PAGE_SHOW,
        LINK_FEED,
        SECURITY_CHANGE,
        DESKTOP_MODE_CHANGE,
        VIEWPORT_CHANGE,
        RECORDING_CHANGE,
        BOOKMARK_ADDED,
        BOOKMARK_REMOVED,
        AUDIO_PLAYING_CHANGE;

    }

    public static interface OnTabsChangedListener {
        public void onTabChanged(Tab var1, TabEvents var2, String var3);
    }

    private static class TabsInstanceHolder {
        private static final Tabs INSTANCE = new Tabs();

        private TabsInstanceHolder() {
        }
    }

    private static class PersistTabsRunnable
    implements Runnable {
        private final BrowserDB db;
        private final Context context;
        private final Iterable<Tab> tabs;

        public PersistTabsRunnable(Context context, Iterable<Tab> iterable) {
            this.context = context;
            this.db = GeckoProfile.get(context).getDB();
            this.tabs = iterable;
        }

        @Override
        public void run() {
            try {
                this.db.getTabsAccessor().persistLocalTabs(this.context.getContentResolver(), this.tabs);
            }
            catch (SQLiteException sQLiteException) {
                Log.w((String)Tabs.LOGTAG, (String)"Error persisting local tabs", (Throwable)sQLiteException);
            }
        }
    }
}

