/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.cleanup;

import android.app.IntentService;
import android.content.Intent;
import android.util.Log;
import java.io.File;
import java.util.ArrayList;

public class FileCleanupService
extends IntentService {
    private static final String LOGTAG = "Gecko" + FileCleanupService.class.getSimpleName();
    private static final String WORKER_THREAD_NAME = LOGTAG + "Worker";
    public static final String ACTION_DELETE_FILES = "org.mozilla.gecko.intent.action.DELETE_FILES";
    public static final String EXTRA_FILE_PATHS_TO_DELETE = "org.mozilla.gecko.file_paths_to_delete";

    public FileCleanupService() {
        super(WORKER_THREAD_NAME);
        this.setIntentRedelivery(false);
    }

    protected void onHandleIntent(Intent intent) {
        if (!FileCleanupService.isIntentValid(intent)) {
            return;
        }
        ArrayList arrayList = intent.getStringArrayListExtra(EXTRA_FILE_PATHS_TO_DELETE);
        for (String string2 : arrayList) {
            File file = new File(string2);
            file.delete();
        }
    }

    private static boolean isIntentValid(Intent intent) {
        if (intent == null) {
            Log.w((String)LOGTAG, (String)"Received null intent");
            return false;
        }
        if (!intent.getAction().equals(ACTION_DELETE_FILES)) {
            Log.w((String)LOGTAG, (String)("Received unknown intent action: " + intent.getAction()));
            return false;
        }
        if (!intent.hasExtra(EXTRA_FILE_PATHS_TO_DELETE)) {
            Log.w((String)LOGTAG, (String)"Received intent with no files extra");
            return false;
        }
        return true;
    }
}

