/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.dlc;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import org.mozilla.gecko.dlc.BaseAction;
import org.mozilla.gecko.dlc.DownloadContentService;
import org.mozilla.gecko.dlc.catalog.DownloadContent;
import org.mozilla.gecko.dlc.catalog.DownloadContentCatalog;
import org.mozilla.gecko.util.ContextUtils;

public class StudyAction
extends BaseAction {
    private static final String LOGTAG = "DLCStudyAction";

    @Override
    public void perform(Context context, DownloadContentCatalog downloadContentCatalog) {
        Log.d((String)LOGTAG, (String)"Studying catalog..");
        for (DownloadContent downloadContent : downloadContentCatalog.getContentToStudy()) {
            if (!this.isMatching(context, downloadContent) || !downloadContent.isAssetArchive() || !downloadContent.isFont()) continue;
            downloadContentCatalog.scheduleDownload(downloadContent);
            Log.d((String)LOGTAG, (String)("Scheduled download: " + downloadContent));
        }
        if (downloadContentCatalog.hasScheduledDownloads()) {
            this.startDownloads(context);
        }
        Log.v((String)LOGTAG, (String)"Done");
    }

    protected boolean isMatching(Context context, DownloadContent downloadContent) {
        String string2;
        String string3;
        String string4;
        String string5 = downloadContent.getAndroidApiPattern();
        if (!TextUtils.isEmpty((CharSequence)string5) && (string4 = String.valueOf(Build.VERSION.SDK_INT)).matches(string5)) {
            Log.d((String)LOGTAG, (String)String.format("Android API (%s) does not match pattern: %s", string4, string5));
            return false;
        }
        string4 = downloadContent.getAppIdPattern();
        if (!TextUtils.isEmpty((CharSequence)string4) && !(string3 = context.getPackageName()).matches(string4)) {
            Log.d((String)LOGTAG, (String)String.format("App ID (%s) does not match pattern: %s", string3, string4));
            return false;
        }
        string3 = downloadContent.getAppVersionPattern();
        if (!TextUtils.isEmpty((CharSequence)string3) && !(string2 = ContextUtils.getCurrentPackageInfo((Context)context).versionName).matches(string3)) {
            Log.d((String)LOGTAG, (String)String.format("App version (%s) does not match pattern: %s", string2, string3));
            return false;
        }
        return true;
    }

    protected void startDownloads(Context context) {
        DownloadContentService.startDownloads(context);
    }
}

