/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.firstrun;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import java.util.LinkedList;
import java.util.List;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.firstrun.DataPanel;
import org.mozilla.gecko.firstrun.FirstrunPanel;
import org.mozilla.gecko.firstrun.RestrictedWelcomePanel;
import org.mozilla.gecko.firstrun.SyncPanel;
import org.mozilla.gecko.firstrun.TabQueuePanel;
import org.mozilla.gecko.util.Experiments;

public class FirstrunPagerConfig {
    public static final String LOGTAG = "FirstrunPagerConfig";
    public static final String KEY_IMAGE = "imageRes";
    public static final String KEY_TEXT = "textRes";
    public static final String KEY_SUBTEXT = "subtextRes";

    public static List<FirstrunPanelConfig> getDefault(Context context) {
        LinkedList<FirstrunPanelConfig> linkedList = new LinkedList<FirstrunPanelConfig>();
        if (Experiments.isInExperimentLocal(context, "onboarding3-b")) {
            linkedList.add(SimplePanelConfigs.urlbarPanelConfig);
            linkedList.add(SimplePanelConfigs.bookmarksPanelConfig);
            linkedList.add(SimplePanelConfigs.dataPanelConfig);
            linkedList.add(SimplePanelConfigs.syncPanelConfig);
            linkedList.add(SimplePanelConfigs.signInPanelConfig);
            Telemetry.startUISession(TelemetryContract.Session.EXPERIMENT, "onboarding3-b");
            GeckoSharedPrefs.forProfile(context).edit().putString("onboarding_version", "onboarding3-b").apply();
        } else if (Experiments.isInExperimentLocal(context, "onboarding3-c")) {
            linkedList.add(SimplePanelConfigs.tabqueuePanelConfig);
            linkedList.add(SimplePanelConfigs.readerviewPanelConfig);
            linkedList.add(SimplePanelConfigs.accountPanelConfig);
            Telemetry.startUISession(TelemetryContract.Session.EXPERIMENT, "onboarding3-c");
            GeckoSharedPrefs.forProfile(context).edit().putString("onboarding_version", "onboarding3-c").apply();
        } else {
            Log.e((String)LOGTAG, (String)"Not in an experiment!");
            linkedList.add(SimplePanelConfigs.signInPanelConfig);
        }
        return linkedList;
    }

    public static List<FirstrunPanelConfig> getRestricted() {
        LinkedList<FirstrunPanelConfig> linkedList = new LinkedList<FirstrunPanelConfig>();
        linkedList.add(new FirstrunPanelConfig(RestrictedWelcomePanel.class.getName(), RestrictedWelcomePanel.TITLE_RES));
        return linkedList;
    }

    private static class SimplePanelConfigs {
        public static final FirstrunPanelConfig urlbarPanelConfig = new FirstrunPanelConfig(FirstrunPanel.class.getName(), R.string.firstrun_panel_title_welcome, R.drawable.firstrun_urlbar, R.string.firstrun_urlbar_message, R.string.firstrun_urlbar_subtext);
        public static final FirstrunPanelConfig bookmarksPanelConfig = new FirstrunPanelConfig(FirstrunPanel.class.getName(), R.string.firstrun_bookmarks_title, R.drawable.firstrun_bookmarks, R.string.firstrun_bookmarks_message, R.string.firstrun_bookmarks_subtext);
        public static final FirstrunPanelConfig dataPanelConfig = new FirstrunPanelConfig(DataPanel.class.getName(), R.string.firstrun_data_title, R.drawable.firstrun_data_off, R.string.firstrun_data_message, R.string.firstrun_data_subtext);
        public static final FirstrunPanelConfig syncPanelConfig = new FirstrunPanelConfig(FirstrunPanel.class.getName(), R.string.firstrun_sync_title, R.drawable.firstrun_sync, R.string.firstrun_sync_message, R.string.firstrun_sync_subtext);
        public static final FirstrunPanelConfig signInPanelConfig = new FirstrunPanelConfig(SyncPanel.class.getName(), R.string.pref_sync, R.drawable.firstrun_signin, R.string.firstrun_signin_message, R.string.firstrun_welcome_button_browser);
        public static final FirstrunPanelConfig tabqueuePanelConfig = new FirstrunPanelConfig(TabQueuePanel.class.getName(), R.string.firstrun_tabqueue_title, R.drawable.firstrun_tabqueue_off, R.string.firstrun_tabqueue_message_off, R.string.firstrun_tabqueue_subtext_off);
        public static final FirstrunPanelConfig readerviewPanelConfig = new FirstrunPanelConfig(FirstrunPanel.class.getName(), R.string.firstrun_readerview_title, R.drawable.firstrun_readerview, R.string.firstrun_readerview_message, R.string.firstrun_readerview_subtext);
        public static final FirstrunPanelConfig accountPanelConfig = new FirstrunPanelConfig(SyncPanel.class.getName(), R.string.firstrun_account_title, R.drawable.firstrun_account, R.string.firstrun_account_message, R.string.firstrun_button_notnow);

        private SimplePanelConfigs() {
        }
    }

    public static class FirstrunPanelConfig {
        private String classname;
        private int titleRes;
        private Bundle args;

        public FirstrunPanelConfig(String string2, int n) {
            this(string2, n, -1, -1, -1, true);
        }

        public FirstrunPanelConfig(String string2, int n, int n2, int n3, int n4) {
            this(string2, n, n2, n3, n4, false);
        }

        private FirstrunPanelConfig(String string2, int n, int n2, int n3, int n4, boolean bl) {
            this.classname = string2;
            this.titleRes = n;
            if (!bl) {
                this.args = new Bundle();
                this.args.putInt(FirstrunPagerConfig.KEY_IMAGE, n2);
                this.args.putInt(FirstrunPagerConfig.KEY_TEXT, n3);
                this.args.putInt(FirstrunPagerConfig.KEY_SUBTEXT, n4);
            }
        }

        public String getClassname() {
            return this.classname;
        }

        public int getTitleRes() {
            return this.titleRes;
        }

        public Bundle getArgs() {
            return this.args;
        }
    }
}

