/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.support.annotation.UiThread;
import android.support.v4.util.Pair;
import android.support.v7.widget.RecyclerView;
import android.text.format.DateUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.R;
import org.mozilla.gecko.db.RemoteClient;
import org.mozilla.gecko.db.RemoteTab;
import org.mozilla.gecko.home.CombinedHistoryItem;
import org.mozilla.gecko.home.CombinedHistoryPanel;
import org.mozilla.gecko.home.CombinedHistoryRecyclerView;
import org.mozilla.gecko.home.HomeContextMenuInfo;
import org.mozilla.gecko.home.RemoteTabsExpandableListState;

public class ClientsAdapter
extends RecyclerView.Adapter<CombinedHistoryItem>
implements CombinedHistoryRecyclerView.AdapterContextMenuBuilder {
    public static final String LOGTAG = "GeckoClientsAdapter";
    public static final Date EARLIEST_VALID_SYNCED_DATE;
    List<Pair<String, Integer>> adapterList = new LinkedList<Pair<String, Integer>>();
    protected final List<RemoteClient> hiddenClients = new ArrayList<RemoteClient>();
    private Map<String, RemoteClient> visibleClients = new HashMap<String, RemoteClient>();
    protected static RemoteTabsExpandableListState sState;
    private final Context context;

    public ClientsAdapter(Context context) {
        this.context = context;
        if (sState == null) {
            sState = new RemoteTabsExpandableListState(GeckoSharedPrefs.forProfile(context));
        }
    }

    public CombinedHistoryItem onCreateViewHolder(ViewGroup viewGroup, int n) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)viewGroup.getContext());
        CombinedHistoryItem.ItemType itemType = CombinedHistoryItem.ItemType.viewTypeToItemType(n);
        switch (itemType) {
            case NAVIGATION_BACK: {
                View view = layoutInflater.inflate(R.layout.home_combined_back_item, viewGroup, false);
                return new CombinedHistoryItem.HistoryItem(view);
            }
            case CLIENT: {
                View view = layoutInflater.inflate(R.layout.home_remote_tabs_group, viewGroup, false);
                return new CombinedHistoryItem.ClientItem(view);
            }
            case CHILD: {
                View view = layoutInflater.inflate(R.layout.home_item_row, viewGroup, false);
                return new CombinedHistoryItem.HistoryItem(view);
            }
            case HIDDEN_DEVICES: {
                View view = layoutInflater.inflate(R.layout.home_remote_tabs_hidden_devices, viewGroup, false);
                return new CombinedHistoryItem.BasicItem(view);
            }
        }
        return null;
    }

    public void onBindViewHolder(CombinedHistoryItem combinedHistoryItem, int n) {
        CombinedHistoryItem.ItemType itemType = this.getItemTypeForPosition(n);
        switch (itemType) {
            case CLIENT: {
                CombinedHistoryItem.ClientItem clientItem = (CombinedHistoryItem.ClientItem)combinedHistoryItem;
                String string2 = (String)this.adapterList.get((int)n).first;
                RemoteClient remoteClient = this.visibleClients.get(string2);
                clientItem.bind(this.context, remoteClient, sState.isClientCollapsed(string2));
                break;
            }
            case CHILD: {
                Pair<String, Integer> pair = this.adapterList.get(n);
                RemoteTab remoteTab = this.visibleClients.get((Object)pair.first).tabs.get((Integer)pair.second);
                ((CombinedHistoryItem.HistoryItem)combinedHistoryItem).bind(remoteTab);
                break;
            }
            case HIDDEN_DEVICES: {
                String string3 = this.context.getResources().getString(R.string.home_remote_tabs_many_hidden_devices, new Object[]{this.hiddenClients.size()});
                ((TextView)combinedHistoryItem.itemView).setText((CharSequence)string3);
            }
        }
    }

    public int getItemCount() {
        return this.adapterList.size();
    }

    private CombinedHistoryItem.ItemType getItemTypeForPosition(int n) {
        if (n == 0) {
            return CombinedHistoryItem.ItemType.NAVIGATION_BACK;
        }
        Pair<String, Integer> pair = this.adapterList.get(n);
        if (pair == null) {
            return CombinedHistoryItem.ItemType.HIDDEN_DEVICES;
        }
        if ((Integer)pair.second == -1) {
            return CombinedHistoryItem.ItemType.CLIENT;
        }
        return CombinedHistoryItem.ItemType.CHILD;
    }

    public int getItemViewType(int n) {
        return CombinedHistoryItem.ItemType.itemTypeToViewType(this.getItemTypeForPosition(n));
    }

    public int getClientsCount() {
        return this.hiddenClients.size() + this.visibleClients.size();
    }

    @UiThread
    public void setClients(List<RemoteClient> list) {
        this.adapterList.clear();
        this.adapterList.add(null);
        this.hiddenClients.clear();
        this.visibleClients.clear();
        for (RemoteClient remoteClient : list) {
            String string2 = remoteClient.guid;
            if (sState.isClientHidden(string2)) {
                this.hiddenClients.add(remoteClient);
                continue;
            }
            this.visibleClients.put(string2, remoteClient);
            this.adapterList.addAll(ClientsAdapter.getVisibleItems(remoteClient));
        }
        if (!this.hiddenClients.isEmpty()) {
            this.adapterList.add(null);
        }
        this.notifyDataSetChanged();
    }

    private static List<Pair<String, Integer>> getVisibleItems(RemoteClient remoteClient) {
        LinkedList<Pair<String, Integer>> linkedList = new LinkedList<Pair<String, Integer>>();
        String string2 = remoteClient.guid;
        linkedList.add(new Pair((Object)string2, (Object)-1));
        if (!sState.isClientCollapsed(remoteClient.guid)) {
            for (int i = 0; i < remoteClient.tabs.size(); ++i) {
                linkedList.add((Pair<String, Integer>)new Pair((Object)string2, (Object)i));
            }
        }
        return linkedList;
    }

    public List<RemoteClient> getHiddenClients() {
        return this.hiddenClients;
    }

    public void toggleClient(int n) {
        Pair<String, Integer> pair = this.adapterList.get(n);
        if ((Integer)pair.second != -1) {
            return;
        }
        String string2 = (String)pair.first;
        RemoteClient remoteClient = this.visibleClients.get(string2);
        boolean bl = sState.isClientCollapsed(string2);
        sState.setClientCollapsed(string2, !bl);
        this.notifyItemChanged(n);
        if (bl) {
            for (int i = remoteClient.tabs.size() - 1; i > -1; --i) {
                this.adapterList.add(n + 1, (Pair<String, Integer>)new Pair((Object)string2, (Object)i));
            }
            this.notifyItemRangeInserted(n + 1, remoteClient.tabs.size());
        } else {
            for (int i = remoteClient.tabs.size(); i > 0; --i) {
                this.adapterList.remove(n + 1);
            }
            this.notifyItemRangeRemoved(n + 1, remoteClient.tabs.size());
        }
    }

    public void unhideClients(List<RemoteClient> list) {
        int n = list.size();
        if (n == 0) {
            return;
        }
        int n2 = this.adapterList.size() - 1;
        int n3 = n;
        for (RemoteClient remoteClient : list) {
            String string2 = remoteClient.guid;
            sState.setClientHidden(string2, false);
            this.hiddenClients.remove(remoteClient);
            this.visibleClients.put(string2, remoteClient);
            sState.setClientCollapsed(string2, false);
            this.adapterList.addAll(this.adapterList.size() - 1, ClientsAdapter.getVisibleItems(remoteClient));
            n3 += remoteClient.tabs.size();
        }
        this.notifyItemRangeInserted(n2, n3);
        int n4 = this.adapterList.size() - 1;
        if (this.hiddenClients.isEmpty()) {
            this.adapterList.remove(n4);
            this.notifyItemRemoved(n4);
        } else {
            this.notifyItemChanged(n4);
        }
    }

    public void removeItem(int n) {
        CombinedHistoryItem.ItemType itemType = this.getItemTypeForPosition(n);
        switch (itemType) {
            case CLIENT: {
                int n2;
                String string2 = (String)this.adapterList.get((int)n).first;
                RemoteClient remoteClient = this.visibleClients.remove(string2);
                boolean bl = !this.hiddenClients.isEmpty();
                for (int i = n2 = sState.isClientCollapsed(string2) ? 1 : remoteClient.tabs.size() + 1; i > 0; --i) {
                    this.adapterList.remove(n);
                }
                this.notifyItemRangeRemoved(n, n2);
                sState.setClientHidden(string2, true);
                this.hiddenClients.add(remoteClient);
                if (!bl) {
                    this.adapterList.add(null);
                    this.notifyItemInserted(this.adapterList.size() - 1);
                    break;
                }
                this.notifyItemChanged(this.adapterList.size() - 1);
            }
        }
    }

    @Override
    public HomeContextMenuInfo makeContextMenuInfoFromPosition(View view, int n) {
        CombinedHistoryItem.ItemType itemType = this.getItemTypeForPosition(n);
        Pair<String, Integer> pair = this.adapterList.get(n);
        switch (itemType) {
            case CHILD: {
                HomeContextMenuInfo homeContextMenuInfo = new HomeContextMenuInfo(view, n, -1L);
                return ClientsAdapter.populateChildInfoFromTab(homeContextMenuInfo, this.visibleClients.get((Object)pair.first).tabs.get((Integer)pair.second));
            }
            case CLIENT: {
                CombinedHistoryPanel.RemoteTabsClientContextMenuInfo remoteTabsClientContextMenuInfo = new CombinedHistoryPanel.RemoteTabsClientContextMenuInfo(view, n, -1L, this.visibleClients.get(pair.first));
                return remoteTabsClientContextMenuInfo;
            }
        }
        return null;
    }

    protected static HomeContextMenuInfo populateChildInfoFromTab(HomeContextMenuInfo homeContextMenuInfo, RemoteTab remoteTab) {
        homeContextMenuInfo.url = remoteTab.url;
        homeContextMenuInfo.title = remoteTab.title;
        return homeContextMenuInfo;
    }

    public static String getLastSyncedString(Context context, long l, long l2) {
        if (new Date(l2).before(EARLIEST_VALID_SYNCED_DATE)) {
            return context.getString(R.string.remote_tabs_never_synced);
        }
        CharSequence charSequence = DateUtils.getRelativeTimeSpanString((long)l2, (long)l, (long)60000L);
        return context.getResources().getString(R.string.remote_tabs_last_synced, new Object[]{charSequence});
    }

    static {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(2000, 0, 1, 0, 0, 0);
        EARLIEST_VALID_SYNCED_DATE = calendar.getTime();
    }
}

