/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.content.res.Resources;
import android.database.Cursor;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.CombinedHistoryItem;
import org.mozilla.gecko.home.CombinedHistoryRecyclerView;
import org.mozilla.gecko.home.HistorySectionsHelper;
import org.mozilla.gecko.home.HomeContextMenuInfo;

public class CombinedHistoryAdapter
extends RecyclerView.Adapter<CombinedHistoryItem>
implements CombinedHistoryRecyclerView.AdapterContextMenuBuilder {
    private static final int RECENT_TABS_SMARTFOLDER_INDEX = 0;
    private static final int SYNCED_DEVICES_SMARTFOLDER_INDEX = 1;
    static final HistorySectionsHelper.SectionDateRange[] sectionDateRangeArray = new HistorySectionsHelper.SectionDateRange[SectionHeader.values().length];
    private Cursor historyCursor;
    private DevicesUpdateHandler devicesUpdateHandler;
    private int deviceCount = 0;
    private RecentTabsUpdateHandler recentTabsUpdateHandler;
    private int recentTabsCount = 0;
    private final SparseArray<SectionHeader> sectionHeaders = new SparseArray();

    public CombinedHistoryAdapter(Resources resources) {
        HistorySectionsHelper.updateRecentSectionOffset(resources, sectionDateRangeArray);
    }

    public void setHistory(Cursor cursor) {
        this.historyCursor = cursor;
        CombinedHistoryAdapter.populateSectionHeaders(this.historyCursor, this.sectionHeaders);
        this.notifyDataSetChanged();
    }

    public DevicesUpdateHandler getDeviceUpdateHandler() {
        if (this.devicesUpdateHandler == null) {
            this.devicesUpdateHandler = new DevicesUpdateHandler(){

                @Override
                public void onDeviceCountUpdated(int n) {
                    CombinedHistoryAdapter.this.deviceCount = n;
                    CombinedHistoryAdapter.this.notifyItemChanged(1);
                }
            };
        }
        return this.devicesUpdateHandler;
    }

    public RecentTabsUpdateHandler getRecentTabsUpdateHandler() {
        if (this.recentTabsUpdateHandler == null) {
            this.recentTabsUpdateHandler = new RecentTabsUpdateHandler(){

                @Override
                public void onRecentTabsCountUpdated(int n) {
                    CombinedHistoryAdapter.this.recentTabsCount = n;
                    CombinedHistoryAdapter.this.notifyItemChanged(0);
                }
            };
        }
        return this.recentTabsUpdateHandler;
    }

    public CombinedHistoryItem onCreateViewHolder(ViewGroup viewGroup, int n) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)viewGroup.getContext());
        CombinedHistoryItem.ItemType itemType = CombinedHistoryItem.ItemType.viewTypeToItemType(n);
        switch (itemType) {
            case RECENT_TABS: 
            case SYNCED_DEVICES: {
                View view = layoutInflater.inflate(R.layout.home_smartfolder, viewGroup, false);
                return new CombinedHistoryItem.SmartFolder(view);
            }
            case SECTION_HEADER: {
                View view = layoutInflater.inflate(R.layout.home_header_row, viewGroup, false);
                return new CombinedHistoryItem.BasicItem(view);
            }
            case HISTORY: {
                View view = layoutInflater.inflate(R.layout.home_item_row, viewGroup, false);
                return new CombinedHistoryItem.HistoryItem(view);
            }
        }
        throw new IllegalArgumentException("Unexpected Home Panel item type");
    }

    public void onBindViewHolder(CombinedHistoryItem combinedHistoryItem, int n) {
        CombinedHistoryItem.ItemType itemType = this.getItemTypeForPosition(n);
        int n2 = this.transformAdapterPositionForDataStructure(itemType, n);
        switch (itemType) {
            case RECENT_TABS: {
                ((CombinedHistoryItem.SmartFolder)combinedHistoryItem).bind(R.drawable.icon_recent, R.string.home_closed_tabs_title2, R.string.home_closed_tabs_one, R.string.home_closed_tabs_number, this.recentTabsCount);
                break;
            }
            case SYNCED_DEVICES: {
                ((CombinedHistoryItem.SmartFolder)combinedHistoryItem).bind(R.drawable.cloud, R.string.home_synced_devices_smartfolder, R.string.home_synced_devices_one, R.string.home_synced_devices_number, this.deviceCount);
                break;
            }
            case SECTION_HEADER: {
                ((TextView)combinedHistoryItem.itemView).setText((CharSequence)CombinedHistoryAdapter.getSectionHeaderTitle((SectionHeader)((Object)this.sectionHeaders.get(n2))));
                break;
            }
            case HISTORY: {
                if (this.historyCursor == null || !this.historyCursor.moveToPosition(n2)) {
                    throw new IllegalStateException("Couldn't move cursor to position " + n2);
                }
                ((CombinedHistoryItem.HistoryItem)combinedHistoryItem).bind(this.historyCursor);
            }
        }
    }

    private int transformAdapterPositionForDataStructure(CombinedHistoryItem.ItemType itemType, int n) {
        if (itemType == CombinedHistoryItem.ItemType.SECTION_HEADER) {
            return n;
        }
        if (itemType == CombinedHistoryItem.ItemType.HISTORY) {
            return n - this.getHeadersBefore(n) - 2;
        }
        return n;
    }

    private CombinedHistoryItem.ItemType getItemTypeForPosition(int n) {
        if (n == 0) {
            return CombinedHistoryItem.ItemType.RECENT_TABS;
        }
        if (n == 1) {
            return CombinedHistoryItem.ItemType.SYNCED_DEVICES;
        }
        int n2 = this.transformAdapterPositionForDataStructure(CombinedHistoryItem.ItemType.SECTION_HEADER, n);
        if (this.sectionHeaders.get(n2) != null) {
            return CombinedHistoryItem.ItemType.SECTION_HEADER;
        }
        return CombinedHistoryItem.ItemType.HISTORY;
    }

    public int getItemViewType(int n) {
        return CombinedHistoryItem.ItemType.itemTypeToViewType(this.getItemTypeForPosition(n));
    }

    public int getItemCount() {
        int n = this.historyCursor == null ? 0 : this.historyCursor.getCount();
        return n + this.sectionHeaders.size() + 2;
    }

    private static void populateSectionHeaders(Cursor cursor, SparseArray<SectionHeader> sparseArray) {
        sparseArray.clear();
        if (cursor == null || !cursor.moveToFirst()) {
            return;
        }
        SectionHeader sectionHeader = null;
        do {
            int n = cursor.getPosition();
            long l = cursor.getLong(cursor.getColumnIndexOrThrow("date"));
            SectionHeader sectionHeader2 = CombinedHistoryAdapter.getSectionFromTime(l);
            if (sectionHeader == sectionHeader2) continue;
            sectionHeader = sectionHeader2;
            sparseArray.append(n + sparseArray.size() + 2, (Object)sectionHeader);
        } while (sectionHeader != SectionHeader.OLDER_THAN_SIX_MONTHS && cursor.moveToNext());
    }

    private static String getSectionHeaderTitle(SectionHeader sectionHeader) {
        return CombinedHistoryAdapter.sectionDateRangeArray[sectionHeader.ordinal()].displayName;
    }

    private static SectionHeader getSectionFromTime(long l) {
        for (int i = 0; i < SectionHeader.OLDER_THAN_SIX_MONTHS.ordinal(); ++i) {
            if (l <= CombinedHistoryAdapter.sectionDateRangeArray[i].start) continue;
            return SectionHeader.values()[i];
        }
        return SectionHeader.OLDER_THAN_SIX_MONTHS;
    }

    private int getHeadersBefore(int n) {
        for (int i = 1; i < this.sectionHeaders.size(); ++i) {
            if (this.sectionHeaders.keyAt(i) <= n) continue;
            return i;
        }
        return this.sectionHeaders.size();
    }

    @Override
    public HomeContextMenuInfo makeContextMenuInfoFromPosition(View view, int n) {
        CombinedHistoryItem.ItemType itemType = this.getItemTypeForPosition(n);
        if (itemType == CombinedHistoryItem.ItemType.HISTORY) {
            HomeContextMenuInfo homeContextMenuInfo = new HomeContextMenuInfo(view, n, -1L);
            this.historyCursor.moveToPosition(this.transformAdapterPositionForDataStructure(CombinedHistoryItem.ItemType.HISTORY, n));
            return CombinedHistoryAdapter.populateHistoryInfoFromCursor(homeContextMenuInfo, this.historyCursor);
        }
        return null;
    }

    protected static HomeContextMenuInfo populateHistoryInfoFromCursor(HomeContextMenuInfo homeContextMenuInfo, Cursor cursor) {
        homeContextMenuInfo.url = cursor.getString(cursor.getColumnIndexOrThrow("url"));
        homeContextMenuInfo.title = cursor.getString(cursor.getColumnIndexOrThrow("title"));
        homeContextMenuInfo.historyId = cursor.getInt(cursor.getColumnIndexOrThrow("history_id"));
        homeContextMenuInfo.itemType = HomeContextMenuInfo.RemoveItemType.HISTORY;
        int n = cursor.getColumnIndexOrThrow("bookmark_id");
        homeContextMenuInfo.bookmarkId = cursor.isNull(n) ? -1 : cursor.getInt(n);
        return homeContextMenuInfo;
    }

    public static interface RecentTabsUpdateHandler {
        public void onRecentTabsCountUpdated(int var1);
    }

    public static interface DevicesUpdateHandler {
        public void onDeviceCountUpdated(int var1);
    }

    public static enum SectionHeader {
        TODAY,
        YESTERDAY,
        WEEK,
        THIS_MONTH,
        MONTH_AGO,
        TWO_MONTHS_AGO,
        THREE_MONTHS_AGO,
        FOUR_MONTHS_AGO,
        FIVE_MONTHS_AGO,
        OLDER_THAN_SIX_MONTHS;

    }
}

