/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.menu;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.gecko.R;
import org.mozilla.gecko.menu.GeckoMenuItem;
import org.mozilla.gecko.menu.MenuItemActionBar;
import org.mozilla.gecko.menu.MenuItemDefault;

public class MenuItemSwitcherLayout
extends LinearLayout
implements GeckoMenuItem.Layout,
View.OnClickListener {
    private final MenuItemDefault mMenuItem;
    private final MenuItemActionBar mMenuButton;
    private final List<ImageButton> mActionButtons;
    private final List<View.OnClickListener> mActionButtonListeners = new ArrayList<View.OnClickListener>();

    public MenuItemSwitcherLayout(Context context) {
        this(context, null);
    }

    public MenuItemSwitcherLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.menuItemSwitcherLayoutStyle);
    }

    @TargetApi(value=14)
    public MenuItemSwitcherLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet);
        LayoutInflater.from((Context)context).inflate(R.layout.menu_item_switcher_layout, (ViewGroup)this);
        this.mMenuItem = (MenuItemDefault)this.findViewById(R.id.menu_item);
        this.mMenuButton = (MenuItemActionBar)this.findViewById(R.id.menu_item_button);
        this.mActionButtons = new ArrayList<ImageButton>();
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5 = n3 - n;
        View view = (View)this.getParent();
        int n6 = view.getPaddingLeft() + view.getPaddingRight();
        int n7 = view.getMeasuredWidth() - n6;
        if (n5 < n7 || this.mActionButtons.size() != 0) {
            this.mMenuItem.setVisibility(8);
            this.mMenuButton.setVisibility(0);
        } else {
            this.mMenuItem.setVisibility(0);
            this.mMenuButton.setVisibility(8);
        }
        super.onLayout(bl, n, n2, n3, n4);
    }

    @Override
    public void initialize(GeckoMenuItem geckoMenuItem) {
        if (geckoMenuItem == null) {
            return;
        }
        this.mMenuItem.initialize(geckoMenuItem);
        this.mMenuButton.initialize(geckoMenuItem);
        this.setEnabled(geckoMenuItem.isEnabled());
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.mMenuItem.setEnabled(bl);
        this.mMenuButton.setEnabled(bl);
        for (ImageButton imageButton : this.mActionButtons) {
            imageButton.setEnabled(bl);
            imageButton.setAlpha(bl ? 255 : 99);
        }
    }

    public void setMenuItemClickListener(View.OnClickListener onClickListener) {
        this.mMenuItem.setOnClickListener(onClickListener);
        this.mMenuButton.setOnClickListener(onClickListener);
    }

    public void setMenuItemLongClickListener(View.OnLongClickListener onLongClickListener) {
        this.mMenuItem.setOnLongClickListener(onLongClickListener);
        this.mMenuButton.setOnLongClickListener(onLongClickListener);
    }

    public void addActionButtonClickListener(View.OnClickListener onClickListener) {
        this.mActionButtonListeners.add(onClickListener);
    }

    @Override
    public void setShowIcon(boolean bl) {
        this.mMenuItem.setShowIcon(bl);
    }

    public void setIcon(Drawable drawable2) {
        this.mMenuItem.setIcon(drawable2);
        this.mMenuButton.setIcon(drawable2);
    }

    public void setIcon(int n) {
        this.mMenuItem.setIcon(n);
        this.mMenuButton.setIcon(n);
    }

    public void setTitle(CharSequence charSequence) {
        this.mMenuItem.setTitle(charSequence);
        this.mMenuButton.setContentDescription(charSequence);
    }

    public void setSubMenuIndicator(boolean bl) {
        this.mMenuItem.setSubMenuIndicator(bl);
    }

    public void addActionButton(Drawable drawable2, CharSequence charSequence) {
        int n = this.mActionButtons.size();
        this.mMenuItem.setVisibility(8);
        this.mMenuButton.setVisibility(0);
        if (drawable2 != null) {
            ImageButton imageButton = new ImageButton(this.getContext(), null, R.attr.menuItemSecondaryActionBarStyle);
            imageButton.setImageDrawable(drawable2);
            imageButton.setContentDescription(charSequence);
            imageButton.setOnClickListener((View.OnClickListener)this);
            imageButton.setTag((Object)n);
            int n2 = (int)this.getResources().getDimension(R.dimen.menu_item_row_height);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(0, n2);
            layoutParams.weight = 1.0f;
            imageButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mActionButtons.add(imageButton);
            this.addView((View)imageButton, n + 1);
        }
    }

    protected int getActionButtonCount() {
        return this.mActionButtons.size();
    }

    public void onClick(View view) {
        for (View.OnClickListener onClickListener : this.mActionButtonListeners) {
            onClickListener.onClick(view);
        }
    }

    public void initContextMenuStyles() {
        int n = this.getContext().getResources().getDimensionPixelOffset(R.dimen.context_menu_item_horizontal_padding);
        this.mMenuItem.setPadding(n, this.getPaddingTop(), n, this.getPaddingBottom());
    }
}

