/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.overlays.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import org.mozilla.gecko.R;

public class OverlayDialogButton
extends LinearLayout {
    private static final String LOGTAG = "GeckoOverlayDialogButton";
    private boolean isEnabled = true;
    private final ImageView iconView;
    private final TextView labelView;
    private String enabledText = "";
    private String disabledText = "";
    private View.OnClickListener enabledOnClickListener;

    public OverlayDialogButton(Context context) {
        this(context, null);
    }

    public OverlayDialogButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        String string2;
        String string3;
        this.setOrientation(0);
        LayoutInflater.from((Context)context).inflate(R.layout.overlay_share_button, (ViewGroup)this);
        this.iconView = (ImageView)this.findViewById(R.id.overlaybtn_icon);
        this.labelView = (TextView)this.findViewById(R.id.overlaybtn_label);
        super.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (OverlayDialogButton.this.isEnabled) {
                    if (OverlayDialogButton.this.enabledOnClickListener != null) {
                        OverlayDialogButton.this.enabledOnClickListener.onClick(view);
                    } else {
                        Log.e((String)OverlayDialogButton.LOGTAG, (String)"enabledOnClickListener is null.");
                    }
                } else {
                    Animation animation = AnimationUtils.loadAnimation((Context)OverlayDialogButton.this.getContext(), (int)R.anim.overlay_pop);
                    OverlayDialogButton.this.iconView.startAnimation(animation);
                }
            }
        });
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.OverlayDialogButton);
        Drawable drawable2 = typedArray.getDrawable(R.styleable.OverlayDialogButton_drawable);
        if (drawable2 != null) {
            this.setDrawable(drawable2);
        }
        if ((string3 = typedArray.getString(R.styleable.OverlayDialogButton_disabledText)) != null) {
            this.disabledText = string3;
        }
        if ((string2 = typedArray.getString(R.styleable.OverlayDialogButton_enabledText)) != null) {
            this.enabledText = string2;
        }
        typedArray.recycle();
        this.setEnabled(true);
    }

    public void setDrawable(Drawable drawable2) {
        this.iconView.setImageDrawable(drawable2);
    }

    public void setText(String string2) {
        this.labelView.setText((CharSequence)string2);
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.enabledOnClickListener = onClickListener;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
        this.iconView.setEnabled(bl);
        this.labelView.setEnabled(bl);
        if (bl) {
            this.setText(this.enabledText);
        } else {
            this.setText(this.disabledText);
        }
    }
}

