/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.overlays.ui;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import java.net.URISyntaxException;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.LocalBrowserDB;
import org.mozilla.gecko.db.RemoteClient;
import org.mozilla.gecko.overlays.service.OverlayActionService;
import org.mozilla.gecko.overlays.service.sharemethods.ShareMethod;
import org.mozilla.gecko.overlays.ui.OverlayDialogButton;
import org.mozilla.gecko.overlays.ui.SendTabDeviceListArrayAdapter;
import org.mozilla.gecko.overlays.ui.SendTabList;
import org.mozilla.gecko.overlays.ui.SendTabTargetSelectedListener;
import org.mozilla.gecko.sync.setup.activities.WebURLFinder;
import org.mozilla.gecko.util.IntentUtils;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.UIAsyncTask;

public class ShareDialog
extends Locales.LocaleAwareActivity
implements SendTabTargetSelectedListener {
    private static final String LOGTAG = "GeckoShareDialog";
    public static final String INTENT_EXTRA_DEVICES_ONLY = "org.mozilla.fennec.intent.extra.DEVICES_ONLY";
    private static final int MAXIMUM_INLINE_DEVICES = 2;
    private State state;
    private SendTabList sendTabList;
    private OverlayDialogButton bookmarkButton;
    private Drawable bookmarkButtonDrawable;
    private String url;
    private String title;
    private Intent sendTabOverrideIntent;
    private boolean isAnimating;
    private final BroadcastReceiver uiEventListener = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            ShareMethod.Type type = (ShareMethod.Type)intent.getParcelableExtra("SHARE_METHOD");
            switch (type) {
                case SEND_TAB: {
                    ShareDialog.this.handleSendTabUIEvent(intent);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("UIEvent broadcast from ShareMethod that isn't thought to support such broadcasts.");
                }
            }
        }
    };

    protected void handleSendTabUIEvent(Intent intent) {
        this.sendTabOverrideIntent = (Intent)intent.getParcelableExtra("OVERRIDE_INTENT");
        RemoteClient[] remoteClientArray = (RemoteClient[])intent.getParcelableArrayExtra("RECORDS");
        if (this.state == State.DEVICES_ONLY && (remoteClientArray == null || remoteClientArray.length == 0)) {
            Log.e((String)LOGTAG, (String)("In state: " + (Object)((Object)State.DEVICES_ONLY) + " and received 0 synced clients. Finishing..."));
            Toast.makeText((Context)this, (CharSequence)this.getResources().getText(R.string.overlay_no_synced_devices), (int)0).show();
            this.finish();
            return;
        }
        this.sendTabList.setSyncClients(remoteClientArray);
        if (this.state == State.DEVICES_ONLY || remoteClientArray == null || remoteClientArray.length <= 2) {
            this.sendTabList.switchState(SendTabList.State.LIST);
            if (remoteClientArray == null || remoteClientArray.length == 0) {
                this.bookmarkButton.setBackgroundResource(R.drawable.overlay_share_button_background_first);
            }
            return;
        }
        this.sendTabList.switchState(SendTabList.State.SHOW_DEVICES);
    }

    protected void onDestroy() {
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.uiEventListener);
        super.onDestroy();
    }

    private void abortDueToNoURL() {
        Log.e((String)LOGTAG, (String)"Unable to process shared intent. No URL found!");
        Toast toast = Toast.makeText((Context)this, (CharSequence)this.getResources().getText(R.string.overlay_share_no_url), (int)0);
        toast.show();
        this.finish();
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.overlay_share_dialog);
        LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.uiEventListener, new IntentFilter("org.mozilla.gecko.overlays.ACTION_SHARE_METHOD_UI_EVENT"));
        this.sendTabList = (SendTabList)this.findViewById(R.id.overlay_send_tab_btn);
        SendTabDeviceListArrayAdapter sendTabDeviceListArrayAdapter = new SendTabDeviceListArrayAdapter((Context)this, this);
        this.sendTabList.setAdapter((ListAdapter)sendTabDeviceListArrayAdapter);
        this.sendTabList.setSendTabTargetSelectedListener(this);
        this.bookmarkButton = (OverlayDialogButton)this.findViewById(R.id.overlay_share_bookmark_btn);
        this.bookmarkButtonDrawable = this.bookmarkButton.getBackground();
        this.bookmarkButton = (OverlayDialogButton)this.findViewById(R.id.overlay_share_bookmark_btn);
        this.bookmarkButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ShareDialog.this.addBookmark();
            }
        });
    }

    protected void onResume() {
        super.onResume();
        Intent intent = this.getIntent();
        this.state = intent.getBooleanExtra(INTENT_EXTRA_DEVICES_ONLY, false) ? State.DEVICES_ONLY : State.DEFAULT;
        this.sendTabList.switchState(SendTabList.State.LOADING);
        this.bookmarkButton.setBackgroundDrawable(this.bookmarkButtonDrawable);
        String string2 = IntentUtils.getStringExtraSafe((Intent)intent, (String)"android.intent.extra.TEXT");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.abortDueToNoURL();
            return;
        }
        String string3 = new WebURLFinder(string2).bestWebURL();
        if (TextUtils.isEmpty((CharSequence)string3)) {
            this.abortDueToNoURL();
            return;
        }
        Intent intent2 = new Intent((Context)this, OverlayActionService.class);
        intent2.setAction("org.mozilla.gecko.overlays.ACTION_PREPARE_SHARE");
        this.startService(intent2);
        this.getWindow().setWindowAnimations(0);
        Animation animation = AnimationUtils.loadAnimation((Context)this, (int)R.anim.overlay_slide_up);
        this.findViewById(R.id.sharedialog).startAnimation(animation);
        String string4 = intent.getStringExtra("android.intent.extra.SUBJECT");
        String string5 = "title=" + (string4 != null);
        if (string4 != null) {
            ((TextView)this.findViewById(R.id.title)).setText((CharSequence)string4);
        }
        Telemetry.sendUIEvent(TelemetryContract.Event.SHOW, TelemetryContract.Method.SHARE_OVERLAY, string5);
        this.title = string4;
        this.url = string3;
        TextView textView = (TextView)this.findViewById(R.id.subtitle);
        textView.setText((CharSequence)string3);
        textView.setEllipsize(TextUtils.TruncateAt.MARQUEE);
        textView.setSingleLine(true);
        textView.setMarqueeRepeatLimit(5);
        textView.setSelected(true);
        View view = this.findViewById(R.id.title);
        if (this.state == State.DEVICES_ONLY) {
            this.bookmarkButton.setVisibility(8);
            view.setOnClickListener(null);
            textView.setOnClickListener(null);
            return;
        }
        this.bookmarkButton.setVisibility(0);
        View.OnClickListener onClickListener = new View.OnClickListener(){

            public void onClick(View view) {
                ShareDialog.this.launchBrowser();
            }
        };
        view.setOnClickListener(onClickListener);
        textView.setOnClickListener(onClickListener);
        LocalBrowserDB localBrowserDB = new LocalBrowserDB(this.getCurrentProfile());
        this.setButtonState(this.url, localBrowserDB);
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
    }

    private void setButtonState(final String string2, final LocalBrowserDB localBrowserDB) {
        new UIAsyncTask.WithoutParams<Void>(ThreadUtils.getBackgroundHandler()){
            boolean isBookmark;

            protected Void doInBackground() {
                ContentResolver contentResolver = ShareDialog.this.getApplicationContext().getContentResolver();
                this.isBookmark = localBrowserDB.isBookmark(contentResolver, string2);
                return null;
            }

            protected void onPostExecute(Void void_) {
                ShareDialog.this.findViewById(R.id.overlay_share_bookmark_btn).setEnabled(!this.isBookmark);
            }
        }.execute();
    }

    private Intent getServiceIntent(ShareMethod.Type type) {
        Intent intent = new Intent((Context)this, OverlayActionService.class);
        intent.setAction("org.mozilla.gecko.overlays.ACTION_SHARE");
        intent.putExtra("SHARE_METHOD", (Parcelable)type);
        intent.putExtra("URL", this.url);
        intent.putExtra("TITLE", this.title);
        return intent;
    }

    public void finish() {
        this.finish(true);
    }

    private void finish(boolean bl) {
        super.finish();
        if (bl) {
            this.overridePendingTransition(0, 0);
        }
    }

    @Override
    public void onSendTabActionSelected() {
        if (this.sendTabOverrideIntent == null) {
            throw new IllegalStateException("sendTabOverrideIntent must not be null");
        }
        this.startActivity(this.sendTabOverrideIntent);
        this.finish();
    }

    @Override
    public void onSendTabTargetSelected(String string2) {
        if (string2 == null) {
            throw new IllegalStateException("targetGUID must not be null");
        }
        Intent intent = this.getServiceIntent(ShareMethod.Type.SEND_TAB);
        Bundle bundle = new Bundle();
        bundle.putStringArray("SEND_TAB_TARGET_DEVICES", new String[]{string2});
        intent.putExtra("EXTRA", bundle);
        this.startService(intent);
        this.animateOut(true);
        Telemetry.sendUIEvent(TelemetryContract.Event.SHARE, TelemetryContract.Method.SHARE_OVERLAY, "sendtab");
    }

    public void addBookmark() {
        this.startService(this.getServiceIntent(ShareMethod.Type.ADD_BOOKMARK));
        this.animateOut(true);
        Telemetry.sendUIEvent(TelemetryContract.Event.SAVE, TelemetryContract.Method.SHARE_OVERLAY, "bookmark");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchBrowser() {
        try {
            Intent intent = Intent.parseUri((String)this.url, (int)1);
            intent.setClassName("org.mozilla.fennec", "org.mozilla.gecko.BrowserApp");
            this.startActivity(intent);
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        finally {
            this.finish(false);
        }
    }

    private String getCurrentProfile() {
        return "default";
    }

    private void animateOut(boolean bl) {
        Animation animation;
        if (this.isAnimating) {
            return;
        }
        this.isAnimating = true;
        Animation animation2 = AnimationUtils.loadAnimation((Context)this, (int)R.anim.overlay_slide_down);
        if (!bl) {
            animation = animation2;
        } else {
            View view = this.findViewById(R.id.check);
            view.setVisibility(0);
            Animation animation3 = AnimationUtils.loadAnimation((Context)this, (int)R.anim.overlay_check_entry);
            Animation animation4 = AnimationUtils.loadAnimation((Context)this, (int)R.anim.overlay_check_exit);
            animation4.setStartOffset(animation3.getDuration() + 500L);
            AnimationSet animationSet = new AnimationSet((Context)this, null);
            animationSet.addAnimation(animation3);
            animationSet.addAnimation(animation4);
            view.startAnimation((Animation)animationSet);
            animation = animation4;
        }
        this.findViewById(R.id.sharedialog).startAnimation(animation2);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                ShareDialog.this.finish();
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.setFullscreenFinishOnClickListener();
    }

    private void setFullscreenFinishOnClickListener() {
        View view = this.findViewById(R.id.fullscreen_click_target);
        view.setVisibility(0);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ShareDialog.this.finish();
            }
        });
    }

    public void onBackPressed() {
        this.animateOut(false);
        Telemetry.sendUIEvent(TelemetryContract.Event.CANCEL, TelemetryContract.Method.SHARE_OVERLAY);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        this.animateOut(false);
        Telemetry.sendUIEvent(TelemetryContract.Event.CANCEL, TelemetryContract.Method.SHARE_OVERLAY);
        return true;
    }

    private static enum State {
        DEFAULT,
        DEVICES_ONLY;

    }
}

