/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.NotificationManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.preference.CheckBoxPreference;
import android.preference.EditTextPreference;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceGroup;
import android.preference.SwitchPreference;
import android.preference.TwoStatePreference;
import android.support.design.widget.TextInputLayout;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mozilla.gecko.AdjustConstants;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.BrowserLocaleManager;
import org.mozilla.gecko.DynamicToolbar;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoActivityStatus;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoApplication;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.LocaleManager;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.R;
import org.mozilla.gecko.SnackbarHelper;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.feeds.FeedService;
import org.mozilla.gecko.permissions.Permissions;
import org.mozilla.gecko.preferences.AndroidImportPreference;
import org.mozilla.gecko.preferences.AppCompatPreferenceActivity;
import org.mozilla.gecko.preferences.ClearOnShutdownPref;
import org.mozilla.gecko.preferences.CustomListPreference;
import org.mozilla.gecko.preferences.FontSizePreference;
import org.mozilla.gecko.preferences.GeckoPreferenceFragment;
import org.mozilla.gecko.preferences.LinkPreference;
import org.mozilla.gecko.restrictions.Restrictable;
import org.mozilla.gecko.restrictions.Restrictions;
import org.mozilla.gecko.tabqueue.TabQueueHelper;
import org.mozilla.gecko.tabqueue.TabQueuePrompt;
import org.mozilla.gecko.updater.UpdateService;
import org.mozilla.gecko.updater.UpdateServiceHelper;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.util.InputOptionsUtils;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSObject;
import org.mozilla.gecko.util.ThreadUtils;

public class GeckoPreferences
extends AppCompatPreferenceActivity
implements GeckoActivityStatus,
GeckoEventListener,
NativeEventListener,
Preference.OnPreferenceChangeListener,
SharedPreferences.OnSharedPreferenceChangeListener {
    private static final String LOGTAG = "GeckoPreferences";
    private static final boolean NO_TRANSITIONS = HardwareUtils.IS_KINDLE_DEVICE;
    private static final int NO_SUCH_ID = 0;
    public static final String NON_PREF_PREFIX = "android.not_a_preference.";
    public static final String INTENT_EXTRA_RESOURCES = "resource";
    public static final String PREFS_TRACKING_PROTECTION_PROMPT_SHOWN = "android.not_a_preference.trackingProtectionPromptShown";
    public static String PREFS_HEALTHREPORT_UPLOAD_ENABLED = "android.not_a_preference.healthreport.uploadEnabled";
    public static final String PREFS_SYNC = "android.not_a_preference.sync";
    private static boolean sIsCharEncodingEnabled;
    private boolean mInitialized;
    private PrefsHelper.PrefHandler mPrefsRequest;
    private List<PreferenceActivity.Header> mHeaders;
    private static final String PREFS_SEARCH_RESTORE_DEFAULTS = "android.not_a_preference.search.restore_defaults";
    private static final String PREFS_DATA_REPORTING_PREFERENCES = "android.not_a_preference.datareporting.preferences";
    private static final String PREFS_TELEMETRY_ENABLED = "toolkit.telemetry.enabled";
    private static final String PREFS_CRASHREPORTER_ENABLED = "datareporting.crashreporter.submitEnabled";
    private static final String PREFS_MENU_CHAR_ENCODING = "browser.menu.showCharacterEncoding";
    private static final String PREFS_MP_ENABLED = "privacy.masterpassword.enabled";
    private static final String PREFS_UPDATER_AUTODOWNLOAD = "app.update.autodownload";
    private static final String PREFS_UPDATER_URL = "app.update.url.android";
    private static final String PREFS_GEO_REPORTING = "android.not_a_preference.app.geo.reportdata";
    private static final String PREFS_GEO_LEARN_MORE = "android.not_a_preference.geo.learn_more";
    private static final String PREFS_HEALTHREPORT_LINK = "android.not_a_preference.healthreport.link";
    private static final String PREFS_DEVTOOLS_REMOTE_USB_ENABLED = "devtools.remote.usb.enabled";
    private static final String PREFS_DEVTOOLS_REMOTE_WIFI_ENABLED = "devtools.remote.wifi.enabled";
    private static final String PREFS_DEVTOOLS_REMOTE_LINK = "android.not_a_preference.remote_debugging.link";
    private static final String PREFS_TRACKING_PROTECTION = "privacy.trackingprotection.state";
    private static final String PREFS_TRACKING_PROTECTION_PB = "privacy.trackingprotection.pbmode.enabled";
    private static final String PREFS_ZOOMED_VIEW_ENABLED = "ui.zoomedview.enabled";
    public static final String PREFS_VOICE_INPUT_ENABLED = "android.not_a_preference.voice_input_enabled";
    public static final String PREFS_QRCODE_ENABLED = "android.not_a_preference.qrcode_enabled";
    private static final String PREFS_TRACKING_PROTECTION_PRIVATE_BROWSING = "privacy.trackingprotection.pbmode.enabled";
    private static final String PREFS_TRACKING_PROTECTION_LEARN_MORE = "android.not_a_preference.trackingprotection.learn_more";
    private static final String PREFS_CLEAR_PRIVATE_DATA = "android.not_a_preference.privacy.clear";
    private static final String PREFS_CLEAR_PRIVATE_DATA_EXIT = "android.not_a_preference.history.clear_on_exit";
    private static final String PREFS_SCREEN_ADVANCED = "android.not_a_preference.advanced_screen";
    public static final String PREFS_HOMEPAGE = "android.not_a_preference.homepage";
    public static final String PREFS_HISTORY_SAVED_SEARCH = "android.not_a_preference.search.search_history.enabled";
    private static final String PREFS_FAQ_LINK = "android.not_a_preference.faq.link";
    private static final String PREFS_FEEDBACK_LINK = "android.not_a_preference.feedback.link";
    public static final String PREFS_NOTIFICATIONS_CONTENT = "android.not_a_preference.notifications.content";
    public static final String PREFS_NOTIFICATIONS_CONTENT_LEARN_MORE = "android.not_a_preference.notifications.content.learn_more";
    public static final String PREFS_NOTIFICATIONS_WHATS_NEW = "android.not_a_preference.notifications.whats_new";
    public static final String PREFS_APP_UPDATE_LAST_BUILD_ID = "app.update.last_build_id";
    private static final String ACTION_STUMBLER_UPLOAD_PREF = "org.mozilla.fennec.STUMBLER_PREF";
    private static final String PREFS_BROWSER_LOCALE = "locale";
    public static final String PREFS_RESTORE_SESSION = "android.not_a_preference.restoreSession3";
    public static final String PREFS_RESTORE_SESSION_FROM_CRASH = "browser.sessionstore.resume_from_crash";
    public static final String PREFS_RESTORE_SESSION_MAX_CRASH_RESUMES = "browser.sessionstore.max_resumed_crashes";
    public static final String PREFS_TAB_QUEUE = "android.not_a_preference.tab_queue";
    public static final String PREFS_TAB_QUEUE_LAST_SITE = "android.not_a_preference.last_site";
    public static final String PREFS_TAB_QUEUE_LAST_TIME = "android.not_a_preference.last_time";
    private static final String PREFS_DYNAMIC_TOOLBAR = "browser.chrome.dynamictoolbar";
    private static final int REQUEST_CODE_PREF_SCREEN = 5;
    private static final int RESULT_CODE_EXIT_SETTINGS = 6;
    public static final int RESULT_CODE_LOCALE_DID_CHANGE = 7;
    private static final int REQUEST_CODE_TAB_QUEUE = 8;
    private final Map<String, PrefHandler> HANDLERS;
    private SwitchPreference tabQueuePreference;
    private Locale lastLocale;
    private boolean localeSwitchingIsEnabled;
    private final int DIALOG_CREATE_MASTER_PASSWORD = 0;
    private final int DIALOG_REMOVE_MASTER_PASSWORD = 1;

    public GeckoPreferences() {
        HashMap<String, PrefHandler> hashMap = new HashMap<String, PrefHandler>(2);
        hashMap.put(PREFS_CLEAR_PRIVATE_DATA_EXIT, new ClearOnShutdownPref());
        hashMap.put("android.not_a_preference.import_android", new AndroidImportPreference.Handler());
        this.HANDLERS = Collections.unmodifiableMap(hashMap);
        this.lastLocale = Locale.getDefault();
        this.DIALOG_CREATE_MASTER_PASSWORD = 0;
        this.DIALOG_REMOVE_MASTER_PASSWORD = 1;
    }

    private void startActivityForResultChoosingTransition(Intent intent, int n) {
        this.startActivityForResult(intent, n);
        if (NO_TRANSITIONS) {
            this.overridePendingTransition(0, 0);
        }
    }

    private void finishChoosingTransition() {
        this.finish();
        if (NO_TRANSITIONS) {
            this.overridePendingTransition(0, 0);
        }
    }

    private void updateActionBarTitle(int n) {
        String string2;
        if (AppConstants.Versions.feature14Plus && (string2 = this.getString(n)) != null) {
            Log.v((String)LOGTAG, (String)("Setting action bar title to " + string2));
            this.setTitle(string2);
        }
    }

    private void updateTitleForPrefsResource(int n) {
        int n2 = -1;
        if (n == R.xml.preferences) {
            n2 = R.string.settings_title;
        } else if (n == R.xml.preferences_locale) {
            n2 = R.string.pref_category_language;
        } else if (n == R.xml.preferences_vendor) {
            n2 = R.string.pref_category_vendor;
        } else if (n == R.xml.preferences_general) {
            n2 = R.string.pref_category_general;
        } else if (n == R.xml.preferences_search) {
            n2 = R.string.pref_category_search;
        }
        if (n2 != -1) {
            this.setTitle(n2);
        }
    }

    private void onLocaleChanged(Locale locale) {
        Log.d((String)LOGTAG, (String)("onLocaleChanged: " + locale));
        BrowserLocaleManager.getInstance().updateConfiguration(this.getApplicationContext(), locale);
        this.lastLocale = locale;
        if (this.isMultiPane()) {
            int n;
            this.invalidateHeaders();
            FragmentManager fragmentManager = this.getFragmentManager();
            int n2 = this.getResources().getIdentifier("android:id/prefs", null, null);
            Fragment fragment = fragmentManager.findFragmentById(n2);
            if (fragment != null) {
                fragmentManager.beginTransaction().disallowAddToBackStack().detach(fragment).attach(fragment).commitAllowingStateLoss();
            } else {
                Log.e((String)LOGTAG, (String)"No prefs fragment to reattach!");
            }
            if (this.onIsMultiPane()) {
                this.updateActionBarTitle(R.string.settings_title);
            }
            if ((n = this.getIntent().getExtras().getInt(":android:show_fragment_title")) == 0) {
                throw new IllegalStateException("Title id not found in intent bundle extras");
            }
            this.setTitle(n);
            this.setResult(7);
            return;
        }
        this.refreshSuggestedSites();
        Intent intent = (Intent)this.getIntent().clone();
        intent.addFlags(65536);
        this.startActivityForResultChoosingTransition(intent, 5);
        this.setResult(7);
        this.finishChoosingTransition();
    }

    private void checkLocale() {
        Locale locale = Locale.getDefault();
        Log.v((String)LOGTAG, (String)("Checking locale: " + locale + " vs " + this.lastLocale));
        if (locale.equals(this.lastLocale)) {
            return;
        }
        this.onLocaleChanged(locale);
    }

    @Override
    protected void onCreate(Bundle bundle) {
        this.checkLocale();
        this.localeSwitchingIsEnabled = BrowserLocaleManager.getInstance().isEnabled();
        if (AppConstants.Versions.feature11Plus && !this.getIntent().hasExtra(":android:show_fragment")) {
            this.setupTopLevelFragmentIntent();
        }
        super.onCreate(bundle);
        if (AppConstants.Versions.feature11Plus && this.onIsMultiPane()) {
            this.updateActionBarTitle(R.string.settings_title);
            if (Build.VERSION.SDK_INT < 13) {
                this.localeSwitchingIsEnabled = false;
                throw new IllegalStateException("foobar");
            }
        }
        Bundle bundle2 = this.getIntent().getExtras();
        EventDispatcher.getInstance().registerGeckoThreadListener(this, new String[]{"Sanitize:Finished"});
        EventDispatcher.getInstance().registerGeckoThreadListener(this, new String[]{"Snackbar:Show"});
        ListView listView = this.getListView();
        listView.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

            public boolean onItemLongClick(AdapterView<?> adapterView, View view, int n, long l) {
                ListAdapter listAdapter = ((ListView)adapterView).getAdapter();
                Object object = listAdapter.getItem(n);
                if (object instanceof CustomListPreference && object instanceof View.OnLongClickListener) {
                    View.OnLongClickListener onLongClickListener = (View.OnLongClickListener)object;
                    return onLongClickListener.onLongClick(view);
                }
                return false;
            }
        });
        if (bundle2 != null && bundle2.containsKey("datareporting-notification")) {
            Telemetry.sendUIEvent(TelemetryContract.Event.LAUNCH, TelemetryContract.Method.NOTIFICATION, "settings-data-choices");
            NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
            notificationManager.cancel("datareporting-notification".hashCode());
        }
        if (bundle2 != null && bundle2.containsKey("content-notification")) {
            Telemetry.startUISession(TelemetryContract.Session.EXPERIMENT, FeedService.getEnabledExperiment((Context)this));
            Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.BUTTON, "notification-settings");
            Telemetry.stopUISession(TelemetryContract.Session.EXPERIMENT, FeedService.getEnabledExperiment((Context)this));
        }
    }

    private void setupTopLevelFragmentIntent() {
        Intent intent = this.getIntent();
        Bundle bundle = intent.getExtras();
        Bundle bundle2 = new Bundle();
        if (bundle != null && bundle.containsKey(INTENT_EXTRA_RESOURCES)) {
            String string2 = bundle.getString(INTENT_EXTRA_RESOURCES);
            bundle2.putString(INTENT_EXTRA_RESOURCES, string2);
        } else if (!this.onIsMultiPane()) {
            bundle2.putString(INTENT_EXTRA_RESOURCES, "preferences");
        } else {
            bundle2.putString(INTENT_EXTRA_RESOURCES, "preferences_general_tablet");
        }
        intent.putExtra(":android:show_fragment", GeckoPreferenceFragment.class.getName());
        intent.putExtra(":android:show_fragment_args", bundle2);
        intent.putExtra(":android:show_fragment_title", R.string.settings_title);
    }

    public boolean isValidFragment(String string2) {
        return GeckoPreferenceFragment.class.getName().equals(string2);
    }

    @TargetApi(value=11)
    public void onBuildHeaders(List<PreferenceActivity.Header> list) {
        if (this.onIsMultiPane()) {
            this.loadHeadersFromResource(R.xml.preference_headers, list);
            Iterator<PreferenceActivity.Header> iterator = list.iterator();
            while (iterator.hasNext()) {
                PreferenceActivity.Header header = iterator.next();
                if (header.id == (long)R.id.pref_header_advanced && !Restrictions.isAllowed((Context)this, Restrictable.ADVANCED_SETTINGS)) {
                    iterator.remove();
                    continue;
                }
                if (header.id != (long)R.id.pref_header_clear_private_data || Restrictions.isAllowed((Context)this, Restrictable.CLEAR_HISTORY)) continue;
                iterator.remove();
            }
            this.mHeaders = list;
        }
    }

    @TargetApi(value=11)
    public void switchToHeader(int n) {
        if (this.mHeaders == null) {
            return;
        }
        for (PreferenceActivity.Header header : this.mHeaders) {
            if (header.id != (long)n) continue;
            this.switchToHeader(header);
            return;
        }
    }

    public void onWindowFocusChanged(boolean bl) {
        if (!bl || this.mInitialized) {
            return;
        }
        this.mInitialized = true;
    }

    public void onBackPressed() {
        super.onBackPressed();
        if (NO_TRANSITIONS) {
            this.overridePendingTransition(0, 0);
        }
        Telemetry.sendUIEvent(TelemetryContract.Event.CANCEL, TelemetryContract.Method.BACK, "settings");
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, new String[]{"Sanitize:Finished"});
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, new String[]{"Snackbar:Show"});
        if (this.mPrefsRequest != null) {
            PrefsHelper.removeObserver(this.mPrefsRequest);
            this.mPrefsRequest = null;
        }
    }

    public void onPause() {
        if (AppConstants.Versions.feature11Plus && this.isMultiPane()) {
            SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp((Context)this);
            sharedPreferences.unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        }
        super.onPause();
        if (this.getApplication() instanceof GeckoApplication) {
            ((GeckoApplication)this.getApplication()).onActivityPause(this);
        }
    }

    public void onResume() {
        super.onResume();
        if (this.getApplication() instanceof GeckoApplication) {
            ((GeckoApplication)this.getApplication()).onActivityResume(this);
        }
        if (AppConstants.Versions.feature11Plus && this.isMultiPane()) {
            SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp((Context)this);
            sharedPreferences.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        }
    }

    public void startActivity(Intent intent) {
        this.startActivityForResultChoosingTransition(intent, 5);
    }

    public void startWithFragment(String string2, Bundle bundle, Fragment fragment, int n, int n2, int n3) {
        Log.v((String)LOGTAG, (String)("Starting with fragment: " + string2 + ", title " + n2));
        Intent intent = this.onBuildStartFragmentIntent(string2, bundle, n2, n3);
        if (fragment == null) {
            this.startActivityForResultChoosingTransition(intent, 5);
        } else {
            fragment.startActivityForResult(intent, n);
            if (NO_TRANSITIONS) {
                this.overridePendingTransition(0, 0);
            }
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        this.checkLocale();
        switch (n) {
            case 5: {
                switch (n2) {
                    case 6: {
                        this.updateActionBarTitle(R.string.settings_title);
                        this.setResult(6);
                        this.finishChoosingTransition();
                    }
                }
                break;
            }
            case 8: {
                if (!TabQueueHelper.processTabQueuePromptResponse(n2, (Context)this)) break;
                this.tabQueuePreference.setChecked(true);
            }
        }
    }

    public void onRequestPermissionsResult(int n, String[] stringArray, int[] nArray) {
        Permissions.onRequestPermissionsResult((Activity)this, stringArray, nArray);
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        try {
            if (string2.equals("Sanitize:Finished")) {
                boolean bl = jSONObject.getBoolean("success");
                int n = bl ? R.string.private_data_success : R.string.private_data_fail;
                SnackbarHelper.showSnackbar((Activity)this, this.getString(n), 0);
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("Exception handling message \"" + string2 + "\":"), (Throwable)exception);
        }
    }

    public void handleMessage(String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
        if ("Snackbar:Show".equals(string2)) {
            SnackbarHelper.showSnackbar((Activity)this, nativeJSObject, eventCallback);
        }
    }

    public PrefsHelper.PrefHandler setupPreferences(PreferenceGroup preferenceGroup) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.setupPreferences(preferenceGroup, arrayList);
        return this.getGeckoPreferences(preferenceGroup, arrayList);
    }

    private void setupPreferences(PreferenceGroup preferenceGroup, ArrayList<String> arrayList) {
        for (int i = 0; i < preferenceGroup.getPreferenceCount(); ++i) {
            Object object;
            Preference preference = preferenceGroup.getPreference(i);
            if (!this.localeSwitchingIsEnabled && "preferences_locale".equals(preference.getExtras().getString(INTENT_EXTRA_RESOURCES))) {
                preferenceGroup.removePreference(preference);
                --i;
                continue;
            }
            String string2 = preference.getKey();
            if (preference instanceof PreferenceGroup) {
                if (PREFS_DATA_REPORTING_PREFERENCES.equals(string2)) {
                    if (!Restrictions.isAllowed((Context)this, Restrictable.DATA_CHOICES)) {
                        preferenceGroup.removePreference(preference);
                        --i;
                        continue;
                    }
                } else if (PREFS_SCREEN_ADVANCED.equals(string2) && !Restrictions.isAllowed((Context)this, Restrictable.ADVANCED_SETTINGS)) {
                    preferenceGroup.removePreference(preference);
                    --i;
                    continue;
                }
                this.setupPreferences((PreferenceGroup)preference, arrayList);
                continue;
            }
            if (this.HANDLERS.containsKey(string2) && !(object = this.HANDLERS.get(string2)).setupPref((Context)this, preference)) {
                preferenceGroup.removePreference(preference);
                --i;
                continue;
            }
            preference.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
            if (!PREFS_UPDATER_AUTODOWNLOAD.equals(string2) && !PREFS_TRACKING_PROTECTION.equals(string2)) {
                if ("privacy.trackingprotection.pbmode.enabled".equals(string2)) {
                    preferenceGroup.removePreference(preference);
                    --i;
                    continue;
                }
                if (PREFS_TELEMETRY_ENABLED.equals(string2)) {
                    if (!Restrictions.isAllowed((Context)this, Restrictable.DATA_CHOICES)) {
                        preferenceGroup.removePreference(preference);
                        --i;
                        continue;
                    }
                } else if (PREFS_HEALTHREPORT_UPLOAD_ENABLED.equals(string2) || PREFS_HEALTHREPORT_LINK.equals(string2)) {
                    if (!Restrictions.isAllowed((Context)this, Restrictable.DATA_CHOICES)) {
                        preferenceGroup.removePreference(preference);
                        --i;
                        continue;
                    }
                } else if (PREFS_CRASHREPORTER_ENABLED.equals(string2)) {
                    if (!Restrictions.isAllowed((Context)this, Restrictable.DATA_CHOICES)) {
                        preferenceGroup.removePreference(preference);
                        --i;
                        continue;
                    }
                } else if (PREFS_GEO_REPORTING.equals(string2) || PREFS_GEO_LEARN_MORE.equals(string2)) {
                    if (!Restrictions.isAllowed((Context)this, Restrictable.DATA_CHOICES)) {
                        preferenceGroup.removePreference(preference);
                        --i;
                        continue;
                    }
                } else if (PREFS_DEVTOOLS_REMOTE_USB_ENABLED.equals(string2)) {
                    if (!Restrictions.isAllowed((Context)this, Restrictable.REMOTE_DEBUGGING)) {
                        preferenceGroup.removePreference(preference);
                        --i;
                        continue;
                    }
                } else if (PREFS_DEVTOOLS_REMOTE_WIFI_ENABLED.equals(string2)) {
                    if (!Restrictions.isAllowed((Context)this, Restrictable.REMOTE_DEBUGGING)) {
                        preferenceGroup.removePreference(preference);
                        --i;
                        continue;
                    }
                    if (!InputOptionsUtils.supportsQrCodeReader((Context)this.getApplicationContext())) {
                        preference.setEnabled(false);
                        preference.setSummary((CharSequence)this.getString(R.string.pref_developer_remotedebugging_wifi_disabled_summary));
                        continue;
                    }
                } else if (PREFS_DEVTOOLS_REMOTE_LINK.equals(string2)) {
                    if (!Restrictions.isAllowed((Context)this, Restrictable.REMOTE_DEBUGGING)) {
                        preferenceGroup.removePreference(preference);
                        --i;
                        continue;
                    }
                } else {
                    if (PREFS_RESTORE_SESSION.equals(string2) || PREFS_BROWSER_LOCALE.equals(string2)) {
                        object = (ListPreference)preference;
                        CharSequence charSequence = object.getEntry();
                        object.setSummary(charSequence);
                        continue;
                    }
                    if (PREFS_SYNC.equals(string2)) {
                        if (!Restrictions.isAllowed((Context)this, Restrictable.MODIFY_ACCOUNTS)) {
                            preferenceGroup.removePreference(preference);
                            --i;
                            continue;
                        }
                    } else if (PREFS_SEARCH_RESTORE_DEFAULTS.equals(string2)) {
                        preference.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

                            public boolean onPreferenceClick(Preference preference) {
                                GeckoPreferences.this.restoreDefaultSearchEngines();
                                Telemetry.sendUIEvent(TelemetryContract.Event.SEARCH_RESTORE_DEFAULTS, TelemetryContract.Method.LIST_ITEM);
                                return true;
                            }
                        });
                    } else if (PREFS_TAB_QUEUE.equals(string2)) {
                        this.tabQueuePreference = (SwitchPreference)preference;
                        if (!TabQueueHelper.TAB_QUEUE_ENABLED) {
                            preferenceGroup.removePreference(preference);
                            --i;
                            continue;
                        }
                    } else if (!PREFS_ZOOMED_VIEW_ENABLED.equals(string2)) {
                        if (PREFS_VOICE_INPUT_ENABLED.equals(string2)) {
                            if (!InputOptionsUtils.supportsVoiceRecognizer((Context)this.getApplicationContext(), (String)this.getResources().getString(R.string.voicesearch_prompt))) {
                                preferenceGroup.removePreference(preference);
                                --i;
                                continue;
                            }
                        } else if (PREFS_QRCODE_ENABLED.equals(string2)) {
                            if (!InputOptionsUtils.supportsQrCodeReader((Context)this.getApplicationContext())) {
                                preferenceGroup.removePreference(preference);
                                --i;
                                continue;
                            }
                        } else if ("privacy.trackingprotection.pbmode.enabled".equals(string2)) {
                            if (!Restrictions.isAllowed((Context)this, Restrictable.PRIVATE_BROWSING)) {
                                preferenceGroup.removePreference(preference);
                                --i;
                                continue;
                            }
                        } else if (PREFS_TRACKING_PROTECTION_LEARN_MORE.equals(string2)) {
                            if (!Restrictions.isAllowed((Context)this, Restrictable.PRIVATE_BROWSING)) {
                                preferenceGroup.removePreference(preference);
                                --i;
                                continue;
                            }
                        } else if (PREFS_MP_ENABLED.equals(string2)) {
                            if (!Restrictions.isAllowed((Context)this, Restrictable.MASTER_PASSWORD)) {
                                preferenceGroup.removePreference(preference);
                                --i;
                                continue;
                            }
                        } else if (PREFS_CLEAR_PRIVATE_DATA.equals(string2) || PREFS_CLEAR_PRIVATE_DATA_EXIT.equals(string2)) {
                            if (!Restrictions.isAllowed((Context)this, Restrictable.CLEAR_HISTORY)) {
                                preferenceGroup.removePreference(preference);
                                --i;
                                continue;
                            }
                        } else if (PREFS_HOMEPAGE.equals(string2)) {
                            object = GeckoSharedPrefs.forProfile(this.getBaseContext()).getString(PREFS_HOMEPAGE, "about:home");
                            this.setHomePageSummary(preference, (String)object);
                            preference.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
                        } else if (PREFS_FAQ_LINK.equals(string2)) {
                            String string3 = Locales.getLanguageTag((Locale)Locale.getDefault());
                            String string4 = this.getResources().getString(R.string.faq_link, new Object[]{"50.0a1", "Android", string3});
                            ((LinkPreference)preference).setUrl(string4);
                        } else if (PREFS_FEEDBACK_LINK.equals(string2)) {
                            object = this.getResources().getString(R.string.feedback_link, new Object[]{"50.0a1", "nightly"});
                            ((LinkPreference)preference).setUrl((String)object);
                        } else if (PREFS_DYNAMIC_TOOLBAR.equals(string2)) {
                            if (DynamicToolbar.isForceDisabled()) {
                                preferenceGroup.removePreference(preference);
                                --i;
                                continue;
                            }
                        } else if ((PREFS_NOTIFICATIONS_CONTENT.equals(string2) || PREFS_NOTIFICATIONS_CONTENT_LEARN_MORE.equals(string2)) && !FeedService.isInExperiment((Context)this)) {
                            preferenceGroup.removePreference(preference);
                            --i;
                            continue;
                        }
                    }
                }
            }
            if (!this.isGeckoPref(string2)) continue;
            arrayList.add(string2);
        }
    }

    private void setHomePageSummary(Preference preference, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            preference.setSummary((CharSequence)string2);
        } else {
            preference.setSummary((CharSequence)"about:home");
        }
    }

    private boolean isGeckoPref(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        if (string2.startsWith(NON_PREF_PREFIX)) {
            return false;
        }
        return !string2.equals(PREFS_BROWSER_LOCALE);
    }

    protected void restoreDefaultSearchEngines() {
        GeckoAppShell.notifyObservers("SearchEngines:RestoreDefaults", null);
        GeckoAppShell.notifyObservers("SearchEngines:GetVisible", null);
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        int n = menuItem.getItemId();
        switch (n) {
            case 16908332: {
                this.finishChoosingTransition();
                return true;
            }
        }
        if (n == R.id.restore_defaults) {
            this.restoreDefaultSearchEngines();
            Telemetry.sendUIEvent(TelemetryContract.Event.SEARCH_RESTORE_DEFAULTS, TelemetryContract.Method.MENU);
            return true;
        }
        return super.onOptionsItemSelected(menuItem);
    }

    public static void setCharEncodingState(boolean bl) {
        sIsCharEncodingEnabled = bl;
    }

    public static boolean getCharEncodingState() {
        return sIsCharEncodingEnabled;
    }

    public static void broadcastAction(Context context, Intent intent) {
        GeckoPreferences.fillIntentWithProfileInfo(context, intent);
        context.sendBroadcast(intent, "org.mozilla.fennec.permission.PER_ANDROID_PACKAGE");
    }

    private static void fillIntentWithProfileInfo(Context context, Intent intent) {
        GeckoProfile geckoProfile = GeckoProfile.get(context);
        if (geckoProfile != null) {
            intent.putExtra("profileName", geckoProfile.getName()).putExtra("profilePath", geckoProfile.getDir().getAbsolutePath());
        }
    }

    public static void broadcastStumblerPref(Context context, boolean bl) {
        Intent intent = new Intent(ACTION_STUMBLER_UPLOAD_PREF).putExtra("pref", PREFS_GEO_REPORTING).putExtra("branch", "GeckoApp").putExtra("enabled", bl).putExtra("moz_mozilla_api_key", "3b4d27dd-703d-4094-8398-4de2c763505a");
        if (GeckoAppShell.getGeckoInterface() != null) {
            intent.putExtra("user_agent", GeckoAppShell.getGeckoInterface().getDefaultUAString());
        }
        GeckoPreferences.broadcastAction(context, intent);
    }

    public static void broadcastStumblerPref(Context context) {
        boolean bl = GeckoPreferences.getBooleanPref(context, PREFS_GEO_REPORTING, false);
        GeckoPreferences.broadcastStumblerPref(context, bl);
    }

    public static boolean getBooleanPref(Context context, String string2, boolean bl) {
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp(context);
        return sharedPreferences.getBoolean(string2, bl);
    }

    private boolean onLocaleSelected(final String string2, final String string3) {
        final Context context = this.getApplicationContext();
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                LocaleManager localeManager = BrowserLocaleManager.getInstance();
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    BrowserLocaleManager.getInstance().resetToSystemLocale(context);
                    Telemetry.sendUIEvent(TelemetryContract.Event.LOCALE_BROWSER_RESET);
                } else {
                    if (null == localeManager.setSelectedLocale(context, string3)) {
                        localeManager.updateConfiguration(context, Locale.getDefault());
                    }
                    Telemetry.sendUIEvent(TelemetryContract.Event.LOCALE_BROWSER_UNSELECTED, TelemetryContract.Method.NONE, string2 == null ? "unknown" : string2);
                    Telemetry.sendUIEvent(TelemetryContract.Event.LOCALE_BROWSER_SELECTED, TelemetryContract.Method.NONE, string3);
                }
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GeckoPreferences.this.onLocaleChanged(Locale.getDefault());
                    }
                });
            }
        });
        return true;
    }

    private void refreshSuggestedSites() {
        ContentResolver contentResolver = this.getApplicationContext().getContentResolver();
        contentResolver.notifyChange(BrowserContract.SuggestedSites.CONTENT_URI, null);
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        Log.d((String)LOGTAG, (String)("onConfigurationChanged: " + configuration.locale));
        if (this.lastLocale.equals(configuration.locale)) {
            Log.d((String)LOGTAG, (String)"Old locale same as new locale. Short-circuiting.");
            return;
        }
        LocaleManager localeManager = BrowserLocaleManager.getInstance();
        Locale locale = localeManager.onSystemConfigurationChanged((Context)this, this.getResources(), configuration, this.lastLocale);
        if (locale != null) {
            this.onLocaleChanged(locale);
        }
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String string2) {
        if (PREFS_BROWSER_LOCALE.equals(string2)) {
            this.onLocaleSelected(Locales.getLanguageTag((Locale)this.lastLocale), sharedPreferences.getString(string2, null));
        }
    }

    private void recordSettingChangeTelemetry(String string2, Object object) {
        String string3 = object instanceof Boolean ? ((Boolean)object != false ? "1" : "0") : (string2.equals(PREFS_HOMEPAGE) ? "*" : object.toString());
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)string2);
        jSONArray.put((Object)string3);
        Telemetry.sendUIEvent(TelemetryContract.Event.EDIT, TelemetryContract.Method.SETTINGS, jSONArray.toString());
    }

    public boolean onPreferenceChange(Preference preference, Object object) {
        Object object2;
        String string2 = preference.getKey();
        Log.i((String)LOGTAG, (String)("Changed " + string2 + " = " + object));
        this.recordSettingChangeTelemetry(string2, object);
        if (PREFS_MP_ENABLED.equals(string2)) {
            this.showDialog((Boolean)object != false ? 0 : 1);
            return false;
        }
        if (PREFS_HOMEPAGE.equals(string2)) {
            this.setHomePageSummary(preference, String.valueOf(object));
        }
        if (PREFS_BROWSER_LOCALE.equals(string2)) {
            return this.onLocaleSelected(Locales.getLanguageTag((Locale)this.lastLocale), (String)object);
        }
        if (PREFS_MENU_CHAR_ENCODING.equals(string2)) {
            GeckoPreferences.setCharEncodingState(((String)object).equals("true"));
        } else if (PREFS_UPDATER_AUTODOWNLOAD.equals(string2)) {
            UpdateServiceHelper.setAutoDownloadPolicy((Context)this, UpdateService.AutoDownloadPolicy.get((String)object));
        } else if (PREFS_UPDATER_URL.equals(string2)) {
            UpdateServiceHelper.setUpdateUrl((Context)this, (String)object);
        } else if (PREFS_HEALTHREPORT_UPLOAD_ENABLED.equals(string2)) {
            object2 = (Boolean)object;
            AdjustConstants.getAdjustHelper().setEnabled(((Boolean)object2).booleanValue());
        } else {
            if (PREFS_GEO_REPORTING.equals(string2)) {
                if (((Boolean)object).booleanValue()) {
                    this.enableStumbler((CheckBoxPreference)preference);
                    return false;
                }
                GeckoPreferences.broadcastStumblerPref((Context)this, false);
                return true;
            }
            if (PREFS_TAB_QUEUE.equals(string2)) {
                if (((Boolean)object).booleanValue() && !TabQueueHelper.canDrawOverlays((Context)this)) {
                    Intent intent = new Intent((Context)this, TabQueuePrompt.class);
                    this.startActivityForResult(intent, 8);
                    return false;
                }
            } else if (PREFS_NOTIFICATIONS_CONTENT.equals(string2)) {
                FeedService.setup((Context)this);
            } else if (this.HANDLERS.containsKey(string2)) {
                object2 = this.HANDLERS.get(string2);
                object2.onChange((Context)this, preference, object);
            }
        }
        if (this.isGeckoPref(string2)) {
            PrefsHelper.setPref(string2, object, true);
        }
        if (preference instanceof ListPreference) {
            int n = ((ListPreference)preference).findIndexOfValue((String)object);
            CharSequence charSequence = ((ListPreference)preference).getEntries()[n];
            ((ListPreference)preference).setSummary(charSequence);
        } else if (preference instanceof LinkPreference) {
            this.setResult(6);
            this.finishChoosingTransition();
        } else if (preference instanceof FontSizePreference) {
            object2 = (FontSizePreference)preference;
            object2.setSummary((CharSequence)((FontSizePreference)((Object)object2)).getSavedFontSizeName());
        }
        return true;
    }

    private void enableStumbler(final CheckBoxPreference checkBoxPreference) {
        Permissions.from((Context)this).withPermissions("android.permission.ACCESS_FINE_LOCATION").onUIThread().andFallback(new Runnable(){

            @Override
            public void run() {
                checkBoxPreference.setChecked(false);
            }
        }).run(new Runnable(){

            @Override
            public void run() {
                checkBoxPreference.setChecked(true);
                GeckoPreferences.broadcastStumblerPref((Context)GeckoPreferences.this, true);
            }
        });
    }

    private TextInputLayout getTextBox(int n) {
        EditText editText = new EditText((Context)this);
        int n2 = 1;
        editText.setInputType(n2 |= 0x80080);
        editText.setHint(n);
        TextInputLayout textInputLayout = new TextInputLayout((Context)this);
        textInputLayout.addView((View)editText);
        return textInputLayout;
    }

    protected Dialog onCreateDialog(int n) {
        AlertDialog alertDialog;
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        LinearLayout linearLayout = new LinearLayout((Context)this);
        linearLayout.setOrientation(1);
        switch (n) {
            case 0: {
                TextInputLayout textInputLayout = this.getTextBox(R.string.masterpassword_password);
                TextInputLayout textInputLayout2 = this.getTextBox(R.string.masterpassword_confirm);
                linearLayout.addView((View)textInputLayout);
                linearLayout.addView((View)textInputLayout2);
                final EditText editText = textInputLayout.getEditText();
                final EditText editText2 = textInputLayout2.getEditText();
                builder.setTitle(R.string.masterpassword_create_title).setView((View)linearLayout).setPositiveButton(R.string.button_ok, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                        PrefsHelper.setPref(GeckoPreferences.PREFS_MP_ENABLED, editText.getText().toString(), true);
                    }
                }).setNegativeButton(R.string.button_cancel, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                    }
                });
                alertDialog = builder.create();
                alertDialog.setOnShowListener(new DialogInterface.OnShowListener(){

                    public void onShow(DialogInterface dialogInterface) {
                        editText.setText((CharSequence)"");
                        editText2.setText((CharSequence)"");
                        editText.requestFocus();
                    }
                });
                PasswordTextWatcher passwordTextWatcher = new PasswordTextWatcher(editText, editText2, alertDialog);
                editText.addTextChangedListener((TextWatcher)passwordTextWatcher);
                editText2.addTextChangedListener((TextWatcher)passwordTextWatcher);
                break;
            }
            case 1: {
                TextInputLayout textInputLayout = this.getTextBox(R.string.masterpassword_password);
                linearLayout.addView((View)textInputLayout);
                final EditText editText = textInputLayout.getEditText();
                builder.setTitle(R.string.masterpassword_remove_title).setView((View)linearLayout).setPositiveButton(R.string.button_ok, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                        PrefsHelper.setPref(GeckoPreferences.PREFS_MP_ENABLED, editText.getText().toString());
                    }
                }).setNegativeButton(R.string.button_cancel, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                    }
                });
                alertDialog = builder.create();
                alertDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                    public void onDismiss(DialogInterface dialogInterface) {
                        editText.setText((CharSequence)"");
                    }
                });
                alertDialog.setOnShowListener(new DialogInterface.OnShowListener(){

                    public void onShow(DialogInterface dialogInterface) {
                        editText.setText((CharSequence)"");
                    }
                });
                editText.addTextChangedListener((TextWatcher)new EmptyTextWatcher(editText, alertDialog));
                break;
            }
            default: {
                return null;
            }
        }
        return alertDialog;
    }

    private PrefsHelper.PrefHandler getGeckoPreferences(PreferenceGroup preferenceGroup, ArrayList<String> arrayList) {
        PrefCallbacks prefCallbacks = new PrefCallbacks(preferenceGroup);
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        PrefsHelper.addObserver(stringArray, prefCallbacks);
        return prefCallbacks;
    }

    @Override
    public boolean isGeckoActivityOpened() {
        return false;
    }

    public static void setResourceToOpen(Intent intent, String string2) {
        if (intent == null) {
            throw new IllegalArgumentException("intent must not be null");
        }
        if (string2 == null) {
            return;
        }
        intent.putExtra(":android:show_fragment", GeckoPreferenceFragment.class.getName());
        Bundle bundle = new Bundle();
        bundle.putString(INTENT_EXTRA_RESOURCES, string2);
        intent.putExtra(":android:show_fragment_args", bundle);
    }

    private static class PrefCallbacks
    extends PrefsHelper.PrefHandlerBase {
        private final PreferenceGroup screen;

        public PrefCallbacks(PreferenceGroup preferenceGroup) {
            this.screen = preferenceGroup;
        }

        private Preference getField(String string2) {
            return this.screen.findPreference((CharSequence)string2);
        }

        @Override
        public void prefValue(String string2, final boolean bl) {
            final TwoStatePreference twoStatePreference = (TwoStatePreference)this.getField(string2);
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (twoStatePreference.isChecked() != bl) {
                        twoStatePreference.setChecked(bl);
                    }
                }
            });
        }

        @Override
        public void prefValue(String string2, final String string3) {
            final Preference preference = this.getField(string2);
            if (preference instanceof EditTextPreference) {
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ((EditTextPreference)preference).setText(string3);
                    }
                });
            } else if (preference instanceof ListPreference) {
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ((ListPreference)preference).setValue(string3);
                        CharSequence charSequence = ((ListPreference)preference).getEntry();
                        ((ListPreference)preference).setSummary(charSequence);
                    }
                });
            } else if (preference instanceof FontSizePreference) {
                final FontSizePreference fontSizePreference = (FontSizePreference)preference;
                fontSizePreference.setSavedFontSize(string3);
                final String string4 = fontSizePreference.getSavedFontSizeName();
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        fontSizePreference.setSummary(string4);
                    }
                });
            }
        }

        @Override
        public void prefValue(String string2, int n) {
            Preference preference = this.getField(string2);
            Log.w((String)GeckoPreferences.LOGTAG, (String)("Unhandled int value for pref [" + preference + "]"));
        }

        @Override
        public void finish() {
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    PrefCallbacks.this.screen.setEnabled(true);
                }
            });
        }
    }

    private class EmptyTextWatcher
    implements TextWatcher {
        EditText input;
        AlertDialog dialog;

        EmptyTextWatcher(EditText editText, AlertDialog alertDialog) {
            this.input = editText;
            this.dialog = alertDialog;
        }

        public void afterTextChanged(Editable editable) {
            if (this.dialog == null) {
                return;
            }
            String string2 = this.input.getText().toString();
            boolean bl = TextUtils.isEmpty((CharSequence)string2);
            this.dialog.getButton(-1).setEnabled(!bl);
        }

        public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }

        public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }
    }

    private class PasswordTextWatcher
    implements TextWatcher {
        EditText input1;
        EditText input2;
        AlertDialog dialog;

        PasswordTextWatcher(EditText editText, EditText editText2, AlertDialog alertDialog) {
            this.input1 = editText;
            this.input2 = editText2;
            this.dialog = alertDialog;
        }

        public void afterTextChanged(Editable editable) {
            if (this.dialog == null) {
                return;
            }
            String string2 = this.input1.getText().toString();
            String string3 = this.input2.getText().toString();
            boolean bl = TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3) || !string2.equals(string3);
            this.dialog.getButton(-1).setEnabled(!bl);
        }

        public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }

        public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }
    }

    public static interface PrefHandler {
        public boolean setupPref(Context var1, Preference var2);

        public void onChange(Context var1, Preference var2, Object var3);
    }
}

