/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.prompts;

import android.content.Context;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import org.json.JSONObject;
import org.mozilla.gecko.R;
import org.mozilla.gecko.prompts.PromptInput;
import org.mozilla.gecko.widget.BasicColorPicker;

public class ColorPickerInput
extends PromptInput {
    public static final String INPUT_TYPE = "color";
    public static final String LOGTAG = "GeckoColorPickerInput";
    private final boolean mShowAdvancedButton = true;
    private final int mInitialColor;

    public ColorPickerInput(JSONObject jSONObject) {
        super(jSONObject);
        String string2 = jSONObject.optString("value");
        this.mInitialColor = Color.rgb((int)Integer.parseInt(string2.substring(1, 3), 16), (int)Integer.parseInt(string2.substring(3, 5), 16), (int)Integer.parseInt(string2.substring(5, 7), 16));
    }

    @Override
    public View getView(Context context) throws UnsupportedOperationException {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        this.mView = layoutInflater.inflate(R.layout.basic_color_picker_dialog, null);
        BasicColorPicker basicColorPicker = (BasicColorPicker)this.mView.findViewById(R.id.colorpicker);
        basicColorPicker.setColor(this.mInitialColor);
        return this.mView;
    }

    @Override
    public Object getValue() {
        BasicColorPicker basicColorPicker = (BasicColorPicker)this.mView.findViewById(R.id.colorpicker);
        int n = basicColorPicker.getColor();
        return "#" + Integer.toHexString(n).substring(2);
    }

    @Override
    public boolean getScrollable() {
        return true;
    }

    @Override
    public boolean canApplyInputStyle() {
        return false;
    }
}

