/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.telemetry;

import android.content.Context;
import android.content.SharedPreferences;
import java.lang.ref.WeakReference;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.PrefsHelper;

public class TelemetryPreferences {
    private static final String GECKO_PREF_SERVER_URL = "toolkit.telemetry.server";
    private static final String SHARED_PREF_SERVER_URL = "telemetry-serverUrl";
    private static final String DEFAULT_SERVER_URL = "https://incoming.telemetry.mozilla.org";
    private static final String[] OBSERVED_PREFS = new String[]{"toolkit.telemetry.server"};

    private TelemetryPreferences() {
    }

    public static String getServerSchemeHostPort(Context context, String string2) {
        return TelemetryPreferences.getSharedPrefs(context, string2).getString(SHARED_PREF_SERVER_URL, DEFAULT_SERVER_URL);
    }

    public static void initPreferenceObserver(Context context, String string2) {
        TelemetryPrefHandler telemetryPrefHandler = new TelemetryPrefHandler(context, string2);
        PrefsHelper.addObserver(OBSERVED_PREFS, telemetryPrefHandler);
    }

    private static SharedPreferences getSharedPrefs(Context context, String string2) {
        return GeckoSharedPrefs.forProfileName(context, string2);
    }

    private static class TelemetryPrefHandler
    extends PrefsHelper.PrefHandlerBase {
        private final WeakReference<Context> contextWeakReference;
        private final String profileName;

        private TelemetryPrefHandler(Context context, String string2) {
            this.contextWeakReference = new WeakReference<Context>(context);
            this.profileName = string2;
        }

        @Override
        public void prefValue(String string2, String string3) {
            Context context = (Context)this.contextWeakReference.get();
            if (context == null) {
                return;
            }
            if (!string2.equals(TelemetryPreferences.GECKO_PREF_SERVER_URL)) {
                throw new IllegalStateException("Unknown preference: " + string2);
            }
            TelemetryPreferences.getSharedPrefs(context, this.profileName).edit().putString(TelemetryPreferences.SHARED_PREF_SERVER_URL, string3).apply();
        }
    }
}

