/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mozilla.gecko.mozglue.SafeIntent;

public class IntentUtils {
    public static final String ENV_VAR_IN_AUTOMATION = "MOZ_IN_AUTOMATION";
    private static final String ENV_VAR_REGEX = "(.+)=(.*)";

    private IntentUtils() {
    }

    public static HashMap<String, String> getEnvVarMap(@NonNull Intent intent) {
        Pattern pattern = Pattern.compile(ENV_VAR_REGEX);
        Matcher matcher = pattern.matcher("");
        SafeIntent safeIntent = new SafeIntent(intent);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        while (true) {
            String string = "env" + n;
            ++n;
            if (!intent.hasExtra(string)) break;
            IntentUtils.maybeAddEnvVarToEnvVarMap(hashMap, safeIntent, string, matcher);
        }
        return hashMap;
    }

    private static void maybeAddEnvVarToEnvVarMap(@NonNull HashMap<String, String> hashMap, @NonNull SafeIntent safeIntent, @NonNull String string, @NonNull Matcher matcher) {
        String string2 = safeIntent.getStringExtra(string);
        if (string2 == null) {
            return;
        }
        matcher.reset(string2);
        if (matcher.matches()) {
            String string3 = matcher.group(1);
            String string4 = matcher.group(2);
            hashMap.put(string3, string4);
        }
    }

    public static Bundle getBundleExtraSafe(Intent intent, String string) {
        return new SafeIntent(intent).getBundleExtra(string);
    }

    public static String getStringExtraSafe(Intent intent, String string) {
        return new SafeIntent(intent).getStringExtra(string);
    }

    public static boolean getBooleanExtraSafe(Intent intent, String string, boolean bl) {
        return new SafeIntent(intent).getBooleanExtra(string, bl);
    }
}

