/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.mozilla.apache.commons.codec.binary.Base64;
import org.mozilla.gecko.sync.NonArrayJSONException;
import org.mozilla.gecko.sync.NonObjectJSONException;
import org.mozilla.gecko.sync.UnexpectedJSONException;
import org.mozilla.gecko.sync.Utils;

public class ExtendedJSONObject {
    public JSONObject object;

    protected static JSONParser getJSONParser() {
        return new JSONParser();
    }

    protected static Object parseRaw(Reader reader) throws ParseException, IOException {
        try {
            return ExtendedJSONObject.getJSONParser().parse(reader);
        }
        catch (Error error) {
            throw new ParseException(2, (Throwable)error);
        }
    }

    protected static Object parseRaw(String string) throws ParseException {
        try {
            return ExtendedJSONObject.getJSONParser().parse(string);
        }
        catch (Error error) {
            throw new ParseException(2, (Throwable)error);
        }
    }

    public static JSONArray parseJSONArray(Reader reader) throws IOException, ParseException, NonArrayJSONException {
        Object object = ExtendedJSONObject.parseRaw(reader);
        if (object == null) {
            return null;
        }
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new NonArrayJSONException("value must be a JSON array");
    }

    public static JSONArray parseJSONArray(String string) throws IOException, NonArrayJSONException {
        Object object = null;
        try {
            object = ExtendedJSONObject.parseRaw(string);
        }
        catch (ParseException parseException) {
            throw new NonArrayJSONException(parseException);
        }
        if (object == null) {
            return null;
        }
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new NonArrayJSONException("value must be a JSON array");
    }

    public static ExtendedJSONObject parseUTF8AsJSONObject(byte[] byArray) throws NonObjectJSONException, IOException {
        return new ExtendedJSONObject(new String(byArray, "UTF-8"));
    }

    public ExtendedJSONObject() {
        this.object = new JSONObject();
    }

    public ExtendedJSONObject(JSONObject jSONObject) {
        this.object = jSONObject;
    }

    public ExtendedJSONObject(Reader reader) throws IOException, NonObjectJSONException {
        if (reader == null) {
            this.object = new JSONObject();
            return;
        }
        Object object = null;
        try {
            object = ExtendedJSONObject.parseRaw(reader);
        }
        catch (ParseException parseException) {
            throw new NonObjectJSONException(parseException);
        }
        if (!(object instanceof JSONObject)) {
            throw new NonObjectJSONException("value must be a JSON object");
        }
        this.object = (JSONObject)object;
    }

    public ExtendedJSONObject(String string) throws IOException, NonObjectJSONException {
        this(string == null ? null : new StringReader(string));
    }

    public ExtendedJSONObject clone() {
        return new ExtendedJSONObject((JSONObject)this.object.clone());
    }

    public Object get(String string) {
        return this.object.get((Object)string);
    }

    public long getLong(String string, long l) {
        if (!this.object.containsKey((Object)string)) {
            return l;
        }
        Long l2 = this.getLong(string);
        if (l2 == null) {
            return l;
        }
        return l2;
    }

    public Long getLong(String string) {
        return (Long)this.get(string);
    }

    public String getString(String string) {
        return (String)this.get(string);
    }

    public Boolean getBoolean(String string) {
        return (Boolean)this.get(string);
    }

    public Integer getIntegerSafely(String string) throws NumberFormatException {
        Object object = this.object.get((Object)string);
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Long) {
            return ((Long)object).intValue();
        }
        if (object instanceof String) {
            return Integer.parseInt((String)object, 10);
        }
        throw new NumberFormatException("Expecting Integer, got " + object.getClass());
    }

    public Long getTimestamp(String string) {
        Object object = this.object.get((Object)string);
        if (object instanceof Double) {
            double d = (Double)object * 1000.0;
            return Double.valueOf(d).longValue();
        }
        if (object instanceof Float) {
            double d = ((Float)object).doubleValue() * 1000.0;
            return Double.valueOf(d).longValue();
        }
        if (object instanceof Number) {
            return ((Number)object).longValue() * 1000L;
        }
        return null;
    }

    public boolean containsKey(String string) {
        return this.object.containsKey((Object)string);
    }

    public String toJSONString() {
        return this.object.toJSONString();
    }

    public String toString() {
        return this.object.toString();
    }

    protected void putRaw(String string, Object object) {
        JSONObject jSONObject = this.object;
        jSONObject.put(string, object);
    }

    public void put(String string, String string2) {
        this.putRaw(string, string2);
    }

    public void put(String string, boolean bl) {
        this.putRaw(string, bl);
    }

    public void put(String string, long l) {
        this.putRaw(string, l);
    }

    public void put(String string, int n) {
        this.putRaw(string, n);
    }

    public void put(String string, ExtendedJSONObject extendedJSONObject) {
        this.putRaw(string, extendedJSONObject);
    }

    public void put(String string, JSONArray jSONArray) {
        this.putRaw(string, jSONArray);
    }

    public void putArray(String string, List<String> list) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.addAll(list);
        this.putRaw(string, jSONArray);
    }

    public boolean remove(String string) {
        Object object = this.object.remove((Object)string);
        return object != null;
    }

    public ExtendedJSONObject getObject(String string) throws NonObjectJSONException {
        Object object = this.object.get((Object)string);
        if (object == null) {
            return null;
        }
        if (object instanceof ExtendedJSONObject) {
            return (ExtendedJSONObject)object;
        }
        if (object instanceof JSONObject) {
            return new ExtendedJSONObject((JSONObject)object);
        }
        throw new NonObjectJSONException("value must be a JSON object for key: " + string);
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.object.entrySet();
    }

    public Set<String> keySet() {
        return this.object.keySet();
    }

    public JSONArray getArray(String string) throws NonArrayJSONException {
        Object object = this.object.get((Object)string);
        if (object == null) {
            return null;
        }
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new NonArrayJSONException("key must be a JSON array: " + string);
    }

    public int size() {
        return this.object.size();
    }

    public int hashCode() {
        if (this.object == null) {
            return this.getClass().hashCode();
        }
        return this.object.hashCode() ^ this.getClass().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ExtendedJSONObject)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        ExtendedJSONObject extendedJSONObject = (ExtendedJSONObject)object;
        if (this.object == null) {
            return extendedJSONObject.object == null;
        }
        return this.object.equals((Object)extendedJSONObject.object);
    }

    public void throwIfFieldsMissingOrMisTyped(String[] stringArray, Class<?> clazz) throws UnexpectedJSONException.BadRequiredFieldJSONException {
        for (String string : stringArray) {
            Object object = this.get(string);
            if (object == null) {
                throw new UnexpectedJSONException.BadRequiredFieldJSONException("Expected key not present in result: " + string);
            }
            if (clazz == null || clazz.isInstance(object)) continue;
            throw new UnexpectedJSONException.BadRequiredFieldJSONException("Value for key not an instance of " + clazz + ": " + string);
        }
    }

    public byte[] getByteArrayBase64(String string) {
        String string2 = (String)this.object.get((Object)string);
        if (string2 == null) {
            return null;
        }
        return Base64.decodeBase64((String)string2);
    }

    public byte[] getByteArrayHex(String string) {
        String string2 = (String)this.object.get((Object)string);
        if (string2 == null) {
            return null;
        }
        return Utils.hex2Byte(string2);
    }
}

