/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.net;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestBase;
import ch.boye.httpclientandroidlib.client.methods.HttpUriRequest;
import ch.boye.httpclientandroidlib.impl.client.DefaultHttpClient;
import ch.boye.httpclientandroidlib.message.BasicHeader;
import ch.boye.httpclientandroidlib.protocol.BasicHttpContext;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.mozilla.apache.commons.codec.binary.Base64;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;

public class HMACAuthHeaderProvider
implements AuthHeaderProvider {
    public static final String LOG_TAG = "HMACAuthHeaderProvider";
    public static final int NONCE_LENGTH_IN_BYTES = 8;
    public static final String HMAC_SHA1_ALGORITHM = "hmacSHA1";
    public final String identifier;
    public final String key;

    public HMACAuthHeaderProvider(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("identifier must not be null.");
        }
        if (!HMACAuthHeaderProvider.isPlainString(string)) {
            throw new IllegalArgumentException("identifier must be a plain-string.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("key must not be null.");
        }
        this.identifier = string;
        this.key = string2;
    }

    @Override
    public Header getAuthHeader(HttpRequestBase httpRequestBase, BasicHttpContext basicHttpContext, DefaultHttpClient defaultHttpClient) throws GeneralSecurityException {
        long l = System.currentTimeMillis() / 1000L;
        String string = Base64.encodeBase64String((byte[])Utils.generateRandomBytes(8));
        String string2 = "";
        try {
            return this.getAuthHeader(httpRequestBase, basicHttpContext, defaultHttpClient, l, string, string2);
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException exception) {
            throw new GeneralSecurityException(exception);
        }
    }

    protected static boolean isPlainString(String string) {
        byte[] byArray;
        if (string == null || string.length() == 0) {
            return false;
        }
        try {
            byArray = string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.warn(LOG_TAG, "Got exception in isPlainString; returning false.", unsupportedEncodingException);
            return false;
        }
        for (byte by : byArray) {
            if (32 <= by && by <= 33 || 35 <= by && by <= 91 || 93 <= by && by <= 126) continue;
            return false;
        }
        return true;
    }

    protected Header getAuthHeader(HttpRequestBase httpRequestBase, BasicHttpContext basicHttpContext, DefaultHttpClient defaultHttpClient, long l, String string, String string2) throws UnsupportedEncodingException, InvalidKeyException, NoSuchAlgorithmException {
        if (l < 0L) {
            throw new IllegalArgumentException("timestamp must contain only [0-9].");
        }
        if (string == null) {
            throw new IllegalArgumentException("nonce must not be null.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("nonce must not be empty.");
        }
        if (!HMACAuthHeaderProvider.isPlainString(string)) {
            throw new IllegalArgumentException("nonce must be a plain-string.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("extra must not be null.");
        }
        if (string2.length() > 0 && !HMACAuthHeaderProvider.isPlainString(string2)) {
            throw new IllegalArgumentException("extra must be a plain-string.");
        }
        String string3 = HMACAuthHeaderProvider.getRequestString((HttpUriRequest)httpRequestBase, l, string, string2);
        String string4 = HMACAuthHeaderProvider.getSignature(string3, this.key);
        String string5 = "MAC id=\"" + this.identifier + "\", " + "ts=\"" + l + "\", " + "nonce=\"" + string + "\", " + "mac=\"" + string4 + "\"";
        if (string2 != null) {
            string5 = string5 + ", ext=\"" + string2 + "\"";
        }
        BasicHeader basicHeader = new BasicHeader("Authorization", string5);
        return basicHeader;
    }

    protected static byte[] sha1(byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, HMAC_SHA1_ALGORITHM);
        Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
        mac.init(secretKeySpec);
        mac.update(byArray);
        byte[] byArray3 = mac.doFinal();
        return byArray3;
    }

    protected static String getSignature(String string, String string2) throws InvalidKeyException, NoSuchAlgorithmException, UnsupportedEncodingException {
        String string3 = Base64.encodeBase64String((byte[])HMACAuthHeaderProvider.sha1(string.getBytes("UTF-8"), string2.getBytes("UTF-8")));
        return string3;
    }

    protected static String getRequestString(HttpUriRequest httpUriRequest, long l, String string, String string2) {
        String string3 = httpUriRequest.getMethod().toUpperCase();
        URI uRI = httpUriRequest.getURI();
        String string4 = uRI.getHost();
        String string5 = uRI.getRawPath();
        if (uRI.getRawQuery() != null) {
            string5 = string5 + "?";
            string5 = string5 + uRI.getRawQuery();
        }
        if (uRI.getRawFragment() != null) {
            string5 = string5 + "#";
            string5 = string5 + uRI.getRawFragment();
        }
        int n = uRI.getPort();
        String string6 = uRI.getScheme();
        if (n == -1) {
            if ("http".equalsIgnoreCase(string6)) {
                n = 80;
            } else if ("https".equalsIgnoreCase(string6)) {
                n = 443;
            } else {
                throw new IllegalArgumentException("Unsupported URI scheme: " + string6 + ".");
            }
        }
        String string7 = l + "\n" + string + "\n" + string3 + "\n" + string5 + "\n" + string4 + "\n" + n + "\n" + string2 + "\n";
        return string7;
    }
}

