/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.android;

import android.content.ContentProviderClient;
import android.content.Context;
import android.database.Cursor;
import android.os.RemoteException;
import java.util.ArrayList;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.repositories.InvalidSessionTransitionException;
import org.mozilla.gecko.sync.repositories.NoGuidForIdException;
import org.mozilla.gecko.sync.repositories.NullCursorException;
import org.mozilla.gecko.sync.repositories.ParentNotFoundException;
import org.mozilla.gecko.sync.repositories.Repository;
import org.mozilla.gecko.sync.repositories.android.AndroidBrowserHistoryDataAccessor;
import org.mozilla.gecko.sync.repositories.android.AndroidBrowserRepositorySession;
import org.mozilla.gecko.sync.repositories.android.BrowserContractHelpers;
import org.mozilla.gecko.sync.repositories.android.RepoUtils;
import org.mozilla.gecko.sync.repositories.android.VisitsHelper;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionBeginDelegate;
import org.mozilla.gecko.sync.repositories.domain.HistoryRecord;
import org.mozilla.gecko.sync.repositories.domain.Record;

public class AndroidBrowserHistoryRepositorySession
extends AndroidBrowserRepositorySession {
    public static final String LOG_TAG = "ABHistoryRepoSess";
    public static final int INSERT_RECORD_THRESHOLD = 50;
    public static final int RECENT_VISITS_LIMIT = 20;
    protected final Object recordsBufferMonitor = new Object();
    protected ArrayList<HistoryRecord> recordsBuffer = new ArrayList();

    public AndroidBrowserHistoryRepositorySession(Repository repository, Context context) {
        super(repository);
        this.dbHelper = new AndroidBrowserHistoryDataAccessor(context);
    }

    @Override
    public void begin(RepositorySessionBeginDelegate repositorySessionBeginDelegate) throws InvalidSessionTransitionException {
        try {
            this.dbHelper.delete("guid IS NULL", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.begin(repositorySessionBeginDelegate);
    }

    @Override
    protected Record retrieveDuringStore(Cursor cursor) {
        return RepoUtils.historyFromMirrorCursor(cursor);
    }

    @Override
    protected Record retrieveDuringFetch(Cursor cursor) {
        return RepoUtils.historyFromMirrorCursor(cursor);
    }

    @Override
    protected String buildRecordString(Record record) {
        HistoryRecord historyRecord = (HistoryRecord)record;
        return historyRecord.histURI;
    }

    @Override
    public boolean shouldIgnore(Record record) {
        if (super.shouldIgnore(record)) {
            return true;
        }
        if (!(record instanceof HistoryRecord)) {
            return true;
        }
        HistoryRecord historyRecord = (HistoryRecord)record;
        return !RepoUtils.isValidHistoryURI(historyRecord.histURI);
    }

    @Override
    protected Record transformRecord(Record record) throws NullCursorException {
        return this.addVisitsToRecord(record);
    }

    private Record addVisitsToRecord(Record record) throws NullCursorException {
        Logger.debug(LOG_TAG, "Adding visits for GUID " + record.guid);
        ContentProviderClient contentProviderClient = this.dbHelper.context.getContentResolver().acquireContentProviderClient(BrowserContractHelpers.VISITS_CONTENT_URI);
        if (contentProviderClient == null) {
            throw new IllegalStateException("Could not obtain a ContentProviderClient for Visits URI");
        }
        try {
            ((HistoryRecord)record).visits = VisitsHelper.getRecentHistoryVisitsForGUID(contentProviderClient, record.guid, 20);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException("Error while obtaining visits for a record", remoteException);
        }
        finally {
            contentProviderClient.release();
        }
        return record;
    }

    @Override
    protected Record prepareRecord(Record record) {
        return record;
    }

    @Override
    protected void insert(Record record) throws NoGuidForIdException, NullCursorException, ParentNotFoundException {
        this.enqueueNewRecord((HistoryRecord)this.prepareRecord(record));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueueNewRecord(HistoryRecord historyRecord) throws NullCursorException {
        Object object = this.recordsBufferMonitor;
        synchronized (object) {
            if (this.recordsBuffer.size() >= 50) {
                this.flushNewRecords();
            }
            Logger.debug(LOG_TAG, "Enqueuing new record with GUID " + historyRecord.guid);
            this.recordsBuffer.add(historyRecord);
        }
    }

    protected void flushNewRecords() throws NullCursorException {
        if (this.recordsBuffer.size() < 1) {
            Logger.debug(LOG_TAG, "No records to flush, returning.");
            return;
        }
        ArrayList<HistoryRecord> arrayList = this.recordsBuffer;
        this.recordsBuffer = new ArrayList();
        Logger.debug(LOG_TAG, "Flushing " + arrayList.size() + " records to database.");
        int n = ((AndroidBrowserHistoryDataAccessor)this.dbHelper).bulkInsert(arrayList);
        if (n != arrayList.size()) {
            for (HistoryRecord historyRecord : arrayList) {
                this.delegate.onRecordStoreFailed(new RuntimeException("Failed to insert history item with guid " + historyRecord.guid + "."), historyRecord.guid);
            }
            return;
        }
        for (HistoryRecord historyRecord : arrayList) {
            try {
                this.updateBookkeeping(historyRecord);
            }
            catch (NoGuidForIdException | ParentNotFoundException syncException) {
                throw new NullCursorException(syncException);
            }
            catch (NullCursorException nullCursorException) {
                throw nullCursorException;
            }
            this.trackRecord(historyRecord);
            this.delegate.onRecordStoreSucceeded(historyRecord.guid);
        }
    }

    @Override
    public void storeDone() {
        this.storeWorkQueue.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = AndroidBrowserHistoryRepositorySession.this.recordsBufferMonitor;
                synchronized (object) {
                    try {
                        AndroidBrowserHistoryRepositorySession.this.flushNewRecords();
                    }
                    catch (Exception exception) {
                        Logger.warn(AndroidBrowserHistoryRepositorySession.LOG_TAG, "Error flushing records to database.", exception);
                    }
                }
                AndroidBrowserHistoryRepositorySession.this.storeDone(System.currentTimeMillis());
            }
        });
    }
}

