/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.fxa.FirefoxAccounts;

public abstract class FxAccountAbstractActivity
extends Locales.LocaleAwareActivity {
    private static final String LOG_TAG = FxAccountAbstractActivity.class.getSimpleName();
    protected final boolean cannotResumeWhenAccountsExist;
    protected final boolean cannotResumeWhenNoAccountsExist;
    public static final int CAN_ALWAYS_RESUME = 0;
    public static final int CANNOT_RESUME_WHEN_ACCOUNTS_EXIST = 1;
    public static final int CANNOT_RESUME_WHEN_NO_ACCOUNTS_EXIST = 2;

    public FxAccountAbstractActivity(int n) {
        this.cannotResumeWhenAccountsExist = 0 != (n & 1);
        this.cannotResumeWhenNoAccountsExist = 0 != (n & 2);
    }

    protected boolean redirectIfAppropriate() {
        if (this.cannotResumeWhenAccountsExist || this.cannotResumeWhenNoAccountsExist) {
            Account account = FirefoxAccounts.getFirefoxAccount((Context)this);
            if (this.cannotResumeWhenAccountsExist && account != null) {
                this.redirectToAction("org.mozilla.fennec.ACTION_FXA_STATUS");
                return true;
            }
            if (this.cannotResumeWhenNoAccountsExist && account == null) {
                this.redirectToAction("org.mozilla.fennec.ACTION_FXA_GET_STARTED");
                return true;
            }
        }
        return false;
    }

    public void onResume() {
        super.onResume();
        this.redirectIfAppropriate();
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.overridePendingTransition(0, 0);
    }

    protected void launchActivity(Class<? extends Activity> clazz) {
        Intent intent = new Intent((Context)this, clazz);
        intent.setFlags(65536);
        this.startActivity(intent);
    }

    protected void redirectToAction(String string2) {
        Intent intent = new Intent(string2);
        intent.setFlags(65536);
        this.startActivity(intent);
        this.finish();
    }
}

