/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.json.simple.JSONObject;
import org.mozilla.apache.commons.codec.binary.Base64;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.NonObjectJSONException;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.crypto.CryptoException;
import org.mozilla.gecko.sync.crypto.CryptoInfo;
import org.mozilla.gecko.sync.crypto.KeyBundle;
import org.mozilla.gecko.sync.crypto.MissingCryptoInputException;
import org.mozilla.gecko.sync.crypto.NoKeyBundleException;
import org.mozilla.gecko.sync.repositories.domain.Record;
import org.mozilla.gecko.sync.repositories.domain.RecordParseException;

public class CryptoRecord
extends Record {
    private static final String KEY_ID = "id";
    private static final String KEY_COLLECTION = "collection";
    private static final String KEY_PAYLOAD = "payload";
    private static final String KEY_MODIFIED = "modified";
    private static final String KEY_SORTINDEX = "sortindex";
    private static final String KEY_TTL = "ttl";
    private static final String KEY_CIPHERTEXT = "ciphertext";
    private static final String KEY_HMAC = "hmac";
    private static final String KEY_IV = "IV";
    public ExtendedJSONObject payload;
    public KeyBundle keyBundle;

    private static byte[] decryptPayload(ExtendedJSONObject extendedJSONObject, KeyBundle keyBundle) throws CryptoException, UnsupportedEncodingException {
        byte[] byArray = Base64.decodeBase64((byte[])((String)extendedJSONObject.get(KEY_CIPHERTEXT)).getBytes("UTF-8"));
        byte[] byArray2 = Base64.decodeBase64((byte[])((String)extendedJSONObject.get(KEY_IV)).getBytes("UTF-8"));
        byte[] byArray3 = Utils.hex2Byte((String)extendedJSONObject.get(KEY_HMAC));
        return CryptoInfo.decrypt(byArray, byArray2, byArray3, keyBundle).getMessage();
    }

    public CryptoRecord() {
        super(null, null, 0L, false);
    }

    public CryptoRecord(ExtendedJSONObject extendedJSONObject) {
        super(null, null, 0L, false);
        if (extendedJSONObject == null) {
            throw new IllegalArgumentException("No payload provided to CryptoRecord constructor.");
        }
        this.payload = extendedJSONObject;
    }

    public CryptoRecord(String string) throws IOException, NonObjectJSONException {
        this(new ExtendedJSONObject(string));
    }

    public CryptoRecord(Record record) {
        super(record.guid, record.collection, record.lastModified, record.deleted);
        this.ttl = record.ttl;
    }

    @Override
    public Record copyWithIDs(String string, long l) {
        CryptoRecord cryptoRecord = new CryptoRecord(this);
        cryptoRecord.guid = string;
        cryptoRecord.androidID = l;
        cryptoRecord.sortIndex = this.sortIndex;
        cryptoRecord.ttl = this.ttl;
        cryptoRecord.payload = this.payload == null ? null : new ExtendedJSONObject(this.payload.object);
        cryptoRecord.keyBundle = this.keyBundle;
        return cryptoRecord;
    }

    public static CryptoRecord fromJSONRecord(String string) throws NonObjectJSONException, IOException, RecordParseException {
        byte[] byArray = string.getBytes("UTF-8");
        ExtendedJSONObject extendedJSONObject = ExtendedJSONObject.parseUTF8AsJSONObject(byArray);
        return CryptoRecord.fromJSONRecord(extendedJSONObject);
    }

    public static CryptoRecord fromJSONRecord(ExtendedJSONObject extendedJSONObject) throws IOException, NonObjectJSONException, RecordParseException {
        String string = (String)extendedJSONObject.get(KEY_ID);
        String string2 = (String)extendedJSONObject.get(KEY_COLLECTION);
        String string3 = (String)extendedJSONObject.get(KEY_PAYLOAD);
        ExtendedJSONObject extendedJSONObject2 = new ExtendedJSONObject(string3);
        CryptoRecord cryptoRecord = new CryptoRecord(extendedJSONObject2);
        cryptoRecord.guid = string;
        cryptoRecord.collection = string2;
        if (extendedJSONObject.containsKey(KEY_MODIFIED)) {
            Long l = extendedJSONObject.getTimestamp(KEY_MODIFIED);
            if (l == null) {
                throw new RecordParseException("timestamp could not be parsed");
            }
            cryptoRecord.lastModified = l;
        }
        if (extendedJSONObject.containsKey(KEY_SORTINDEX)) {
            try {
                cryptoRecord.sortIndex = extendedJSONObject.getLong(KEY_SORTINDEX);
            }
            catch (Exception exception) {
                throw new RecordParseException("timestamp could not be parsed");
            }
        }
        if (extendedJSONObject.containsKey(KEY_TTL)) {
            try {
                cryptoRecord.ttl = extendedJSONObject.getLong(KEY_TTL);
            }
            catch (Exception exception) {
                throw new RecordParseException("TTL could not be parsed");
            }
        }
        return cryptoRecord;
    }

    public void setKeyBundle(KeyBundle keyBundle) {
        this.keyBundle = keyBundle;
    }

    public CryptoRecord decrypt() throws CryptoException, IOException, NonObjectJSONException {
        if (this.keyBundle == null) {
            throw new NoKeyBundleException();
        }
        if (!(this.payload.containsKey(KEY_CIPHERTEXT) && this.payload.containsKey(KEY_IV) && this.payload.containsKey(KEY_HMAC))) {
            throw new MissingCryptoInputException();
        }
        byte[] byArray = CryptoRecord.decryptPayload(this.payload, this.keyBundle);
        this.payload = ExtendedJSONObject.parseUTF8AsJSONObject(byArray);
        return this;
    }

    public CryptoRecord encrypt() throws CryptoException, UnsupportedEncodingException {
        if (this.keyBundle == null) {
            throw new NoKeyBundleException();
        }
        String string = this.payload.toJSONString();
        byte[] byArray = string.getBytes("UTF-8");
        CryptoInfo cryptoInfo = CryptoInfo.encrypt(byArray, this.keyBundle);
        String string2 = new String(Base64.encodeBase64((byte[])cryptoInfo.getMessage()));
        String string3 = new String(Base64.encodeBase64((byte[])cryptoInfo.getIV()));
        String string4 = Utils.byte2Hex(cryptoInfo.getHMAC());
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        extendedJSONObject.put(KEY_CIPHERTEXT, string2);
        extendedJSONObject.put(KEY_HMAC, string4);
        extendedJSONObject.put(KEY_IV, string3);
        this.payload = extendedJSONObject;
        return this;
    }

    @Override
    public void initFromEnvelope(CryptoRecord cryptoRecord) {
        throw new IllegalStateException("Can't do this with a CryptoRecord.");
    }

    @Override
    public CryptoRecord getEnvelope() {
        throw new IllegalStateException("Can't do this with a CryptoRecord.");
    }

    @Override
    protected void populatePayload(ExtendedJSONObject extendedJSONObject) {
        throw new IllegalStateException("Can't do this with a CryptoRecord.");
    }

    @Override
    protected void initFromPayload(ExtendedJSONObject extendedJSONObject) {
        throw new IllegalStateException("Can't do this with a CryptoRecord.");
    }

    public JSONObject toJSONObject() {
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        extendedJSONObject.put(KEY_PAYLOAD, this.payload.toJSONString());
        extendedJSONObject.put(KEY_ID, this.guid);
        if (this.ttl > 0L) {
            extendedJSONObject.put(KEY_TTL, this.ttl);
        }
        return extendedJSONObject.object;
    }

    @Override
    public String toJSONString() {
        return this.toJSONObject().toJSONString();
    }
}

