/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.net;

import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.client.entity.GzipCompressingEntity;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class GzipNonChunkedCompressingEntity
extends GzipCompressingEntity {
    final int MAX_BUFFER_SIZE_BYTES = 10000000;
    private byte[] gzippedContent;

    public GzipNonChunkedCompressingEntity(HttpEntity httpEntity) {
        super(httpEntity);
    }

    public long getContentLength() {
        try {
            this.initBuffer();
        }
        catch (IOException iOException) {
            return -1L;
        }
        return this.gzippedContent.length;
    }

    public boolean isChunked() {
        return false;
    }

    public InputStream getContent() throws IOException {
        this.initBuffer();
        return new ByteArrayInputStream(this.gzippedContent);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.initBuffer();
        outputStream.write(this.gzippedContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBuffer() throws IOException {
        if (this.gzippedContent != null) {
            return;
        }
        long l = this.wrappedEntity.getContentLength();
        if (l > 10000000L) {
            throw new IOException("Wrapped entity content length, " + l + " bytes, exceeds max: " + 10000000);
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)l);){
            super.writeTo((OutputStream)byteArrayOutputStream);
        }
        this.gzippedContent = byteArrayOutputStream.toByteArray();
    }
}

