/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.util.Log;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.annotation.WrapForJNI;

public final class HardwareCodecCapabilityUtils {
    private static final String LOGTAG = "GeckoHardwareCodecCapabilityUtils";
    private static final String[] supportedVp8HwEncCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Intel."};
    private static final String[] supportedVp8HwDecCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Nvidia.", "OMX.Exynos.", "OMX.Intel."};
    private static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final int[] supportedColorList = new int[]{19, 21, 2141391872, 2141391876};

    @WrapForJNI(allowMultithread=true, stubName="FindDecoderCodecInfoForMimeType")
    public static boolean findDecoderCodecInfoForMimeType(String string) {
        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (mediaCodecInfo.isEncoder()) continue;
            for (String string2 : mediaCodecInfo.getSupportedTypes()) {
                if (!string2.equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean getHWEncoderCapability() {
        if (AppConstants.Versions.feature20Plus) {
            for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
                MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i);
                if (!mediaCodecInfo.isEncoder()) continue;
                String string = null;
                for (String string2 : mediaCodecInfo.getSupportedTypes()) {
                    if (!string2.equals(VP8_MIME_TYPE)) continue;
                    string = mediaCodecInfo.getName();
                    break;
                }
                if (string == null) continue;
                Log.e((String)LOGTAG, (String)("Found candidate encoder " + string));
                boolean bl = false;
                for (String string3 : supportedVp8HwEncCodecPrefixes) {
                    if (!string.startsWith(string3)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(VP8_MIME_TYPE);
                for (int n : codecCapabilities.colorFormats) {
                    Log.v((String)LOGTAG, (String)("   Color: 0x" + Integer.toHexString(n)));
                }
                for (int n : supportedColorList) {
                    for (int n2 : codecCapabilities.colorFormats) {
                        if (n2 != n) continue;
                        Log.e((String)LOGTAG, (String)("Found target encoder " + string + ". Color: 0x" + Integer.toHexString(n2)));
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean getHWDecoderCapability() {
        if (AppConstants.Versions.feature20Plus) {
            for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
                MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i);
                if (mediaCodecInfo.isEncoder()) continue;
                String string = null;
                for (String string2 : mediaCodecInfo.getSupportedTypes()) {
                    if (!string2.equals(VP8_MIME_TYPE)) continue;
                    string = mediaCodecInfo.getName();
                    break;
                }
                if (string == null) continue;
                Log.e((String)LOGTAG, (String)("Found candidate decoder " + string));
                boolean bl = false;
                for (String string3 : supportedVp8HwDecCodecPrefixes) {
                    if (!string.startsWith(string3)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(VP8_MIME_TYPE);
                for (int n : codecCapabilities.colorFormats) {
                    Log.v((String)LOGTAG, (String)("   Color: 0x" + Integer.toHexString(n)));
                }
                for (int n : supportedColorList) {
                    for (int n2 : codecCapabilities.colorFormats) {
                        if (n2 != n) continue;
                        Log.e((String)LOGTAG, (String)("Found target decoder " + string + ". Color: 0x" + Integer.toHexString(n2)));
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

