/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.os.Handler;
import android.os.Looper;

public abstract class UIAsyncTask<Param, Result> {
    final Handler mBackgroundThreadHandler;
    private volatile boolean mCancelled;
    private static Handler sHandler;

    public UIAsyncTask(Handler handler) {
        this.mBackgroundThreadHandler = handler;
    }

    private static synchronized Handler getUiHandler() {
        if (sHandler == null) {
            sHandler = new Handler(Looper.getMainLooper());
        }
        return sHandler;
    }

    protected void execute(final Param Param) {
        UIAsyncTask.getUiHandler().post(new Runnable(){

            @Override
            public void run() {
                UIAsyncTask.this.onPreExecute();
                UIAsyncTask.this.mBackgroundThreadHandler.post((Runnable)new BackgroundTaskRunnable(Param));
            }
        });
    }

    public final boolean cancel() {
        this.mCancelled = true;
        return this.mCancelled;
    }

    public final boolean isCancelled() {
        return this.mCancelled;
    }

    protected void onPreExecute() {
    }

    protected void onPostExecute(Result Result) {
    }

    protected void onCancelled() {
    }

    protected abstract Result doInBackground(Param var1);

    private final class BackgroundTaskRunnable
    implements Runnable {
        private final Param mParam;

        public BackgroundTaskRunnable(Param Param) {
            this.mParam = Param;
        }

        @Override
        public void run() {
            final Object Result = UIAsyncTask.this.doInBackground(this.mParam);
            UIAsyncTask.getUiHandler().post(new Runnable(){

                @Override
                public void run() {
                    if (UIAsyncTask.this.mCancelled) {
                        UIAsyncTask.this.onCancelled();
                    } else {
                        UIAsyncTask.this.onPostExecute(Result);
                    }
                }
            });
        }
    }

    public static abstract class WithoutParams<InnerResult>
    extends UIAsyncTask<Void, InnerResult> {
        public WithoutParams(Handler handler) {
            super(handler);
        }

        public void execute() {
            this.execute(null);
        }

        @Override
        protected InnerResult doInBackground(Void void_) {
            return this.doInBackground();
        }

        protected abstract InnerResult doInBackground();
    }
}

