/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.DownloadManager;
import android.content.Context;
import android.database.Cursor;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.annotation.WrapForJNI;
import org.mozilla.gecko.permissions.Permissions;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSObject;

public class DownloadsIntegration
implements NativeEventListener {
    private static final String LOGTAG = "GeckoDownloadsIntegration";
    private static final List<String> UNKNOWN_MIME_TYPES;
    private static final String DOWNLOAD_REMOVE = "Download:Remove";
    private static DownloadsIntegration sInstance;

    private DownloadsIntegration() {
        EventDispatcher.getInstance().registerGeckoThreadListener(this, DOWNLOAD_REMOVE);
    }

    public static void init() {
        if (sInstance == null) {
            sInstance = new DownloadsIntegration();
        }
    }

    public void handleMessage(String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
        if (DOWNLOAD_REMOVE.equals(string2)) {
            Download download = Download.fromJSON(nativeJSObject);
            DownloadsIntegration.removeDownload(download);
        }
    }

    private static boolean useSystemDownloadManager() {
        if (!AppConstants.ANDROID_DOWNLOADS_INTEGRATION) {
            return false;
        }
        int n = 0;
        try {
            n = GeckoAppShell.getContext().getPackageManager().getApplicationEnabledSetting("com.android.providers.downloads");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return 1 == n || 0 == n;
    }

    @WrapForJNI
    public static String getTemporaryDownloadDirectory() {
        Context context = GeckoAppShell.getApplicationContext();
        if (Permissions.has(context, "android.permission.WRITE_EXTERNAL_STORAGE")) {
            return Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getAbsolutePath();
        }
        return context.getCacheDir().getAbsolutePath();
    }

    @WrapForJNI
    public static void scanMedia(String string2, String string3) {
        int n;
        String string4 = string3;
        if (UNKNOWN_MIME_TYPES.contains(string4)) {
            string4 = "";
        }
        if (TextUtils.isEmpty((CharSequence)string4) && (n = string2.lastIndexOf(".")) > 0 && n < string2.length() - 1) {
            string4 = GeckoAppShell.getMimeTypeFromExtension(string2.substring(n + 1));
        }
        if (TextUtils.isEmpty((CharSequence)string4)) {
            string4 = TextUtils.isEmpty((CharSequence)string3) ? UNKNOWN_MIME_TYPES.get(0) : string3;
        }
        if (DownloadsIntegration.useSystemDownloadManager()) {
            File file = new File(string2);
            DownloadManager downloadManager = (DownloadManager)GeckoAppShell.getContext().getSystemService("download");
            downloadManager.addCompletedDownload(file.getName(), file.getName(), true, string4, file.getAbsolutePath(), Math.max(1L, file.length()), false);
        } else {
            Context context = GeckoAppShell.getContext();
            GeckoMediaScannerClient geckoMediaScannerClient = new GeckoMediaScannerClient(context, string2, string4);
            geckoMediaScannerClient.connect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDownload(Download download) {
        if (!DownloadsIntegration.useSystemDownloadManager()) {
            return;
        }
        DownloadManager downloadManager = (DownloadManager)GeckoAppShell.getContext().getSystemService("download");
        try (Cursor cursor = null;){
            cursor = downloadManager.query(new DownloadManager.Query().setFilterByStatus(8));
            if (cursor == null || !cursor.moveToFirst()) {
                return;
            }
            do {
                Download download2;
                if (!download.equals(download2 = Download.fromCursor(cursor))) continue;
                downloadManager.remove(new long[]{download2.id});
            } while (cursor.moveToNext());
        }
    }

    static {
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add("unknown/unknown");
        arrayList.add("application/unknown");
        arrayList.add("application/octet-stream");
        UNKNOWN_MIME_TYPES = Collections.unmodifiableList(arrayList);
    }

    private static final class GeckoMediaScannerClient
    implements MediaScannerConnection.MediaScannerConnectionClient {
        private final String mFile;
        private final String mMimeType;
        private MediaScannerConnection mScanner;

        public GeckoMediaScannerClient(Context context, String string2, String string3) {
            this.mFile = string2;
            this.mMimeType = string3;
            this.mScanner = new MediaScannerConnection(context, (MediaScannerConnection.MediaScannerConnectionClient)this);
        }

        public void connect() {
            this.mScanner.connect();
        }

        public void onMediaScannerConnected() {
            this.mScanner.scanFile(this.mFile, this.mMimeType);
        }

        public void onScanCompleted(String string2, Uri uri) {
            if (string2.equals(this.mFile)) {
                this.mScanner.disconnect();
                this.mScanner = null;
            }
        }
    }

    private static class Download {
        final File file;
        final long id;
        private static final int UNKNOWN_ID = -1;

        public Download(String string2) {
            this(string2, -1L);
        }

        public Download(String string2, long l) {
            this.file = new File(string2);
            this.id = l;
        }

        public static Download fromJSON(NativeJSObject nativeJSObject) {
            String string2 = nativeJSObject.getString("path");
            return new Download(string2);
        }

        public static Download fromCursor(Cursor cursor) {
            String string2 = cursor.getString(cursor.getColumnIndexOrThrow("local_filename"));
            long l = cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
            return new Download(string2, l);
        }

        public boolean equals(Download download) {
            return this.file.equals(download.file);
        }
    }
}

