/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.DhcpInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.telephony.TelephonyManager;
import android.text.format.Formatter;
import android.util.Log;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.annotation.JNITarget;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSObject;
import org.mozilla.gecko.util.NetworkUtils;

public class GeckoNetworkManager
extends BroadcastReceiver
implements NativeEventListener {
    private static final String LOGTAG = "GeckoNetworkManager";
    private static final String LINK_DATA_CHANGED = "changed";
    private static GeckoNetworkManager instance;
    private ManagerState currentState = ManagerState.OffNoListeners;
    private NetworkUtils.ConnectionType currentConnectionType = NetworkUtils.ConnectionType.NONE;
    private NetworkUtils.NetworkStatus currentNetworkStatus = NetworkUtils.NetworkStatus.UNKNOWN;
    private NetworkUtils.ConnectionSubType currentConnectionSubtype = NetworkUtils.ConnectionSubType.UNKNOWN;

    public static void destroy() {
        if (instance != null) {
            instance.onDestroy();
            instance = null;
        }
    }

    private GeckoNetworkManager() {
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "Wifi:Enable", "Wifi:GetIPAddress");
    }

    private void onDestroy() {
        this.handleManagerEvent(ManagerEvent.stop);
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "Wifi:Enable", "Wifi:GetIPAddress");
    }

    public static GeckoNetworkManager getInstance() {
        if (instance == null) {
            instance = new GeckoNetworkManager();
        }
        return instance;
    }

    public double[] getCurrentInformation() {
        Context context = GeckoAppShell.getApplicationContext();
        NetworkUtils.ConnectionType connectionType = this.currentConnectionType;
        return new double[]{connectionType.value, connectionType == NetworkUtils.ConnectionType.WIFI ? 1.0 : 0.0, connectionType == NetworkUtils.ConnectionType.WIFI ? (double)GeckoNetworkManager.wifiDhcpGatewayAddress(context) : 0.0};
    }

    public void onReceive(Context context, Intent intent) {
        this.handleManagerEvent(ManagerEvent.receivedUpdate);
    }

    public void start() {
        this.handleManagerEvent(ManagerEvent.start);
    }

    public void stop() {
        this.handleManagerEvent(ManagerEvent.stop);
    }

    public void enableNotifications() {
        this.handleManagerEvent(ManagerEvent.enableNotifications);
    }

    public void disableNotifications() {
        this.handleManagerEvent(ManagerEvent.disableNotifications);
    }

    private synchronized boolean handleManagerEvent(ManagerEvent managerEvent) {
        ManagerState managerState = GeckoNetworkManager.getNextState(this.currentState, managerEvent);
        Log.d((String)LOGTAG, (String)("Incoming event " + (Object)((Object)managerEvent) + " for state " + (Object)((Object)this.currentState) + " -> " + (Object)((Object)managerState)));
        if (managerState == null) {
            Log.w((String)LOGTAG, (String)("Invalid event " + (Object)((Object)managerEvent) + " for state " + (Object)((Object)this.currentState)));
            return false;
        }
        this.performActionsForStateEvent(this.currentState, managerEvent);
        this.currentState = managerState;
        return true;
    }

    @Nullable
    public static ManagerState getNextState(@NonNull ManagerState managerState, @NonNull ManagerEvent managerEvent) {
        switch (managerState) {
            case OffNoListeners: {
                switch (managerEvent) {
                    case start: {
                        return ManagerState.OnNoListeners;
                    }
                    case enableNotifications: {
                        return ManagerState.OffWithListeners;
                    }
                }
                return null;
            }
            case OnNoListeners: {
                switch (managerEvent) {
                    case stop: {
                        return ManagerState.OffNoListeners;
                    }
                    case enableNotifications: {
                        return ManagerState.OnWithListeners;
                    }
                    case receivedUpdate: {
                        return ManagerState.OnNoListeners;
                    }
                }
                return null;
            }
            case OnWithListeners: {
                switch (managerEvent) {
                    case stop: {
                        return ManagerState.OffWithListeners;
                    }
                    case disableNotifications: {
                        return ManagerState.OnNoListeners;
                    }
                    case receivedUpdate: {
                        return ManagerState.OnWithListeners;
                    }
                }
                return null;
            }
            case OffWithListeners: {
                switch (managerEvent) {
                    case start: {
                        return ManagerState.OnWithListeners;
                    }
                    case disableNotifications: {
                        return ManagerState.OffNoListeners;
                    }
                }
                return null;
            }
        }
        throw new IllegalStateException("Unknown current state: " + managerState.name());
    }

    private void performActionsForStateEvent(ManagerState managerState, ManagerEvent managerEvent) {
        switch (managerState) {
            case OffNoListeners: {
                if (managerEvent == ManagerEvent.start) {
                    this.updateNetworkStateAndConnectionType();
                    this.registerBroadcastReceiver();
                }
                if (managerEvent != ManagerEvent.enableNotifications) break;
                this.updateNetworkStateAndConnectionType();
                break;
            }
            case OnNoListeners: {
                if (managerEvent == ManagerEvent.receivedUpdate) {
                    this.updateNetworkStateAndConnectionType();
                    this.sendNetworkStateToListeners();
                }
                if (managerEvent == ManagerEvent.enableNotifications) {
                    this.updateNetworkStateAndConnectionType();
                    this.registerBroadcastReceiver();
                }
                if (managerEvent != ManagerEvent.stop) break;
                this.unregisterBroadcastReceiver();
                break;
            }
            case OnWithListeners: {
                if (managerEvent == ManagerEvent.receivedUpdate) {
                    this.updateNetworkStateAndConnectionType();
                    this.sendNetworkStateToListeners();
                }
                if (managerEvent != ManagerEvent.stop) break;
                this.unregisterBroadcastReceiver();
                break;
            }
            case OffWithListeners: {
                if (managerEvent != ManagerEvent.start) break;
                this.registerBroadcastReceiver();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown current state: " + managerState.name());
            }
        }
    }

    private void updateNetworkStateAndConnectionType() {
        Context context = GeckoAppShell.getApplicationContext();
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            Log.e((String)LOGTAG, (String)"ConnectivityManager does not exist.");
        }
        this.currentConnectionType = NetworkUtils.getConnectionType((ConnectivityManager)connectivityManager);
        this.currentNetworkStatus = NetworkUtils.getNetworkStatus((ConnectivityManager)connectivityManager);
        this.currentConnectionSubtype = NetworkUtils.getConnectionSubType((ConnectivityManager)connectivityManager);
        Log.d((String)LOGTAG, (String)("New network state: " + this.currentNetworkStatus + ", " + this.currentConnectionType + ", " + this.currentConnectionSubtype));
    }

    private void sendNetworkStateToListeners() {
        Context context = GeckoAppShell.getApplicationContext();
        GeckoEvent geckoEvent = GeckoEvent.createNetworkEvent(this.currentConnectionType.value, this.currentConnectionType == NetworkUtils.ConnectionType.WIFI, GeckoNetworkManager.wifiDhcpGatewayAddress(context), this.currentConnectionSubtype.value);
        GeckoEvent geckoEvent2 = GeckoEvent.createNetworkLinkChangeEvent(this.currentNetworkStatus.value);
        GeckoEvent geckoEvent3 = GeckoEvent.createNetworkLinkChangeEvent(LINK_DATA_CHANGED);
        GeckoAppShell.sendEventToGecko(geckoEvent);
        GeckoAppShell.sendEventToGecko(geckoEvent2);
        GeckoAppShell.sendEventToGecko(geckoEvent3);
    }

    private void unregisterBroadcastReceiver() {
        GeckoAppShell.getApplicationContext().unregisterReceiver((BroadcastReceiver)this);
    }

    private void registerBroadcastReceiver() {
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        GeckoAppShell.getApplicationContext().registerReceiver((BroadcastReceiver)this, intentFilter);
    }

    private static int wifiDhcpGatewayAddress(Context context) {
        if (context == null) {
            return 0;
        }
        try {
            WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            DhcpInfo dhcpInfo = wifiManager.getDhcpInfo();
            if (dhcpInfo == null) {
                return 0;
            }
            return dhcpInfo.gateway;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void handleMessage(String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
        Context context = GeckoAppShell.getApplicationContext();
        switch (string2) {
            case "Wifi:Enable": {
                WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
                if (!wifiManager.isWifiEnabled()) {
                    wifiManager.setWifiEnabled(true);
                    break;
                }
                Intent intent = new Intent("android.settings.WIFI_SETTINGS");
                intent.addFlags(0x10000000);
                context.startActivity(intent);
                break;
            }
            case "Wifi:GetIPAddress": {
                this.getWifiIPAddress(eventCallback);
            }
        }
    }

    private void getWifiIPAddress(EventCallback eventCallback) {
        WifiManager wifiManager = (WifiManager)GeckoAppShell.getApplicationContext().getSystemService("wifi");
        if (wifiManager == null) {
            eventCallback.sendError((Object)"Cannot get WifiManager");
            return;
        }
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        if (wifiInfo == null) {
            eventCallback.sendError((Object)"Cannot get connection info");
            return;
        }
        int n = wifiInfo.getIpAddress();
        if (n == 0) {
            eventCallback.sendError((Object)"Cannot get IPv4 address");
            return;
        }
        eventCallback.sendSuccess((Object)Formatter.formatIpAddress((int)n));
    }

    private static int getNetworkOperator(InfoType infoType, Context context) {
        if (null == context) {
            return -1;
        }
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager == null) {
            Log.e((String)LOGTAG, (String)"Telephony service does not exist");
            return -1;
        }
        String string2 = telephonyManager.getNetworkOperator();
        if (string2 == null || string2.length() <= 3) {
            return -1;
        }
        if (infoType == InfoType.MNC) {
            return Integer.parseInt(string2.substring(3));
        }
        if (infoType == InfoType.MCC) {
            return Integer.parseInt(string2.substring(0, 3));
        }
        return -1;
    }

    @JNITarget
    public static int getMCC() {
        return GeckoNetworkManager.getNetworkOperator(InfoType.MCC, GeckoAppShell.getApplicationContext());
    }

    @JNITarget
    public static int getMNC() {
        return GeckoNetworkManager.getNetworkOperator(InfoType.MNC, GeckoAppShell.getApplicationContext());
    }

    private static enum InfoType {
        MCC,
        MNC;

    }

    public static enum ManagerEvent {
        start,
        stop,
        enableNotifications,
        disableNotifications,
        receivedUpdate;

    }

    public static enum ManagerState {
        OffNoListeners,
        OffWithListeners,
        OnNoListeners,
        OnWithListeners;

    }
}

