/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.BaseGeckoInterface;
import org.mozilla.gecko.ContextGetter;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAccessibility;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.InputConnectionListener;
import org.mozilla.gecko.annotation.ReflectionTarget;
import org.mozilla.gecko.annotation.WrapForJNI;
import org.mozilla.gecko.gfx.GLController;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.mozglue.JNIObject;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSObject;
import org.mozilla.gecko.util.ThreadUtils;

public class GeckoView
extends LayerView
implements ContextGetter,
GeckoEventListener,
NativeEventListener {
    private static final String DEFAULT_SHARED_PREFERENCES_FILE = "GeckoView";
    private static final String LOGTAG = "GeckoView";
    private ChromeDelegate mChromeDelegate;
    private ContentDelegate mContentDelegate;
    private InputConnectionListener mInputConnectionListener;
    private Window window;
    private boolean stateSaved;

    public void handleMessage(final String string2, final JSONObject jSONObject) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    int n;
                    if (string2.equals("Gecko:Ready")) {
                        GeckoView.this.handleReady(jSONObject);
                    } else if (string2.equals("Content:StateChange")) {
                        GeckoView.this.handleStateChange(jSONObject);
                    } else if (string2.equals("Content:LoadError")) {
                        GeckoView.this.handleLoadError(jSONObject);
                    } else if (string2.equals("Content:PageShow")) {
                        GeckoView.this.handlePageShow(jSONObject);
                    } else if (string2.equals("DOMTitleChanged")) {
                        GeckoView.this.handleTitleChanged(jSONObject);
                    } else if (string2.equals("Link:Favicon")) {
                        GeckoView.this.handleLinkFavicon(jSONObject);
                    } else if (string2.equals("Prompt:Show") || string2.equals("Prompt:ShowTop")) {
                        GeckoView.this.handlePrompt(jSONObject);
                    } else if (string2.equals("Accessibility:Event") && ((n = GeckoView.this.getImportantForAccessibility()) == 1 || n == 0)) {
                        GeckoAccessibility.sendAccessibilityEvent(jSONObject);
                    }
                }
                catch (Exception exception) {
                    Log.e((String)"GeckoView", (String)("handleMessage threw for " + string2), (Throwable)exception);
                }
            }
        });
    }

    public void handleMessage(String string2, NativeJSObject nativeJSObject, final EventCallback eventCallback) {
        try {
            if ("Accessibility:Ready".equals(string2)) {
                GeckoAccessibility.updateAccessibilitySettings(this.getContext());
            } else if ("GeckoView:Message".equals(string2)) {
                NativeJSObject nativeJSObject2 = nativeJSObject.optObject("data", null);
                if (nativeJSObject2 == null) {
                    return;
                }
                final Bundle bundle = nativeJSObject2.toBundle();
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GeckoView.this.handleScriptMessage(bundle, eventCallback);
                    }
                });
            }
        }
        catch (Exception exception) {
            Log.w((String)"GeckoView", (String)("handleMessage threw for " + string2), (Throwable)exception);
        }
    }

    public GeckoView(Context context) {
        super(context);
        this.init(context);
    }

    public GeckoView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    private void init(Context context) {
        if (GeckoAppShell.getApplicationContext() == null) {
            GeckoAppShell.setApplicationContext(context.getApplicationContext());
        }
        if (context instanceof Activity && GeckoView.getGeckoInterface() == null) {
            GeckoView.setGeckoInterface(new BaseGeckoInterface(context));
            GeckoAppShell.setContextGetter(this);
        }
        GeckoAppShell.setLayerView(this);
        this.initializeView(EventDispatcher.getInstance());
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        this.stateSaved = true;
        return new StateBinder(parcelable, this.window);
    }

    protected void onRestoreInstanceState(Parcelable parcelable) {
        StateBinder stateBinder = (StateBinder)parcelable;
        super.onRestoreInstanceState(stateBinder.superState);
        if (stateBinder.window != null) {
            this.window = stateBinder.window;
        }
        this.stateSaved = false;
    }

    @Override
    public void onAttachedToWindow() {
        DisplayMetrics displayMetrics = this.getContext().getResources().getDisplayMetrics();
        if (this.window == null) {
            this.window = new Window();
            String string2 = GeckoView.getGeckoInterface().getDefaultChromeURI();
            if (GeckoThread.isStateAtLeast(GeckoThread.State.PROFILE_READY)) {
                Window.open(this.window, this, this.window.glController, string2, displayMetrics.widthPixels, displayMetrics.heightPixels);
            } else {
                GeckoThread.queueNativeCallUntil(GeckoThread.State.PROFILE_READY, Window.class, "open", new Object[]{this.window, GeckoView.class, this, this.window.glController, String.class, string2, displayMetrics.widthPixels, displayMetrics.heightPixels});
            }
        } else if (GeckoThread.isStateAtLeast(GeckoThread.State.PROFILE_READY)) {
            this.window.reattach(this);
        } else {
            GeckoThread.queueNativeCallUntil(GeckoThread.State.PROFILE_READY, (Object)this.window, "reattach", GeckoView.class, this);
        }
        this.setGLController(this.window.glController);
        super.onAttachedToWindow();
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        super.destroy();
        if (this.stateSaved) {
            return;
        }
        if (GeckoThread.isStateAtLeast(GeckoThread.State.PROFILE_READY)) {
            this.window.close();
            this.window.disposeNative();
        } else {
            GeckoThread.queueNativeCallUntil(GeckoThread.State.PROFILE_READY, (Object)this.window, "close", new Object[0]);
            GeckoThread.queueNativeCallUntil(GeckoThread.State.PROFILE_READY, (Object)this.window, "disposeNative", new Object[0]);
        }
    }

    void setInputConnectionListener(InputConnectionListener inputConnectionListener) {
        this.mInputConnectionListener = inputConnectionListener;
    }

    public Handler getHandler() {
        if (this.mInputConnectionListener != null) {
            return this.mInputConnectionListener.getHandler(super.getHandler());
        }
        return super.getHandler();
    }

    public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
        if (this.mInputConnectionListener != null) {
            return this.mInputConnectionListener.onCreateInputConnection(editorInfo);
        }
        return null;
    }

    public boolean onKeyPreIme(int n, KeyEvent keyEvent) {
        if (super.onKeyPreIme(n, keyEvent)) {
            return true;
        }
        return this.mInputConnectionListener != null && this.mInputConnectionListener.onKeyPreIme(n, keyEvent);
    }

    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        if (super.onKeyUp(n, keyEvent)) {
            return true;
        }
        return this.mInputConnectionListener != null && this.mInputConnectionListener.onKeyUp(n, keyEvent);
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (super.onKeyDown(n, keyEvent)) {
            return true;
        }
        return this.mInputConnectionListener != null && this.mInputConnectionListener.onKeyDown(n, keyEvent);
    }

    public boolean onKeyLongPress(int n, KeyEvent keyEvent) {
        if (super.onKeyLongPress(n, keyEvent)) {
            return true;
        }
        return this.mInputConnectionListener != null && this.mInputConnectionListener.onKeyLongPress(n, keyEvent);
    }

    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
        if (super.onKeyMultiple(n, n2, keyEvent)) {
            return true;
        }
        return this.mInputConnectionListener != null && this.mInputConnectionListener.onKeyMultiple(n, n2, keyEvent);
    }

    boolean isIMEEnabled() {
        return this.mInputConnectionListener != null && this.mInputConnectionListener.isIMEEnabled();
    }

    public void importScript(String string2) {
        if (string2.startsWith("resource://android/assets/")) {
            GeckoAppShell.notifyObservers("GeckoView:ImportScript", string2);
            return;
        }
        throw new IllegalArgumentException("Must import script from 'resources://android/assets/' location.");
    }

    public void connectToGecko() {
        GeckoAppShell.notifyObservers("Viewport:Flush", null);
    }

    private void handleReady(JSONObject jSONObject) {
        this.connectToGecko();
        if (this.mChromeDelegate != null) {
            this.mChromeDelegate.onReady(this);
        }
    }

    private void handleStateChange(JSONObject jSONObject) throws JSONException {
        int n = jSONObject.getInt("state");
        if ((n & 0x40000) != 0) {
            if ((n & 1) != 0) {
                if (this.mContentDelegate != null) {
                    int n2 = jSONObject.getInt("tabID");
                    this.mContentDelegate.onPageStart(this, new Browser(n2), jSONObject.getString("uri"));
                }
            } else if ((n & 0x10) != 0 && this.mContentDelegate != null) {
                int n3 = jSONObject.getInt("tabID");
                this.mContentDelegate.onPageStop(this, new Browser(n3), jSONObject.getBoolean("success"));
            }
        }
    }

    private void handleLoadError(JSONObject jSONObject) throws JSONException {
        if (this.mContentDelegate != null) {
            int n = jSONObject.getInt("tabID");
            this.mContentDelegate.onPageStop(this, new Browser(n), false);
        }
    }

    private void handlePageShow(JSONObject jSONObject) throws JSONException {
        if (this.mContentDelegate != null) {
            int n = jSONObject.getInt("tabID");
            this.mContentDelegate.onPageShow(this, new Browser(n));
        }
    }

    private void handleTitleChanged(JSONObject jSONObject) throws JSONException {
        if (this.mContentDelegate != null) {
            int n = jSONObject.getInt("tabID");
            this.mContentDelegate.onReceivedTitle(this, new Browser(n), jSONObject.getString("title"));
        }
    }

    private void handleLinkFavicon(JSONObject jSONObject) throws JSONException {
        if (this.mContentDelegate != null) {
            int n = jSONObject.getInt("tabID");
            this.mContentDelegate.onReceivedFavicon(this, new Browser(n), jSONObject.getString("href"), jSONObject.getInt("size"));
        }
    }

    private void handlePrompt(JSONObject jSONObject) throws JSONException {
        if (this.mChromeDelegate != null) {
            String string2 = jSONObject.optString("hint");
            if ("alert".equals(string2)) {
                String string3 = jSONObject.optString("text");
                this.mChromeDelegate.onAlert(this, null, string3, new PromptResult(jSONObject));
            } else if ("confirm".equals(string2)) {
                String string4 = jSONObject.optString("text");
                this.mChromeDelegate.onConfirm(this, null, string4, new PromptResult(jSONObject));
            } else if ("prompt".equals(string2)) {
                String string5 = jSONObject.optString("text");
                String string6 = jSONObject.optString("textbox0");
                this.mChromeDelegate.onPrompt(this, null, string5, string6, new PromptResult(jSONObject));
            } else if ("remotedebug".equals(string2)) {
                this.mChromeDelegate.onDebugRequest(this, new PromptResult(jSONObject));
            }
        }
    }

    private void handleScriptMessage(Bundle bundle, EventCallback eventCallback) {
        if (this.mChromeDelegate != null) {
            MessageResult messageResult = null;
            if (eventCallback != null) {
                messageResult = new MessageResult(eventCallback);
            }
            this.mChromeDelegate.onScriptMessage(this, bundle, messageResult);
        }
    }

    public void setChromeDelegate(ChromeDelegate chromeDelegate) {
        this.mChromeDelegate = chromeDelegate;
    }

    public void setContentDelegate(ContentDelegate contentDelegate) {
        this.mContentDelegate = contentDelegate;
    }

    public static void setGeckoInterface(BaseGeckoInterface baseGeckoInterface) {
        GeckoAppShell.setGeckoInterface(baseGeckoInterface);
    }

    public static GeckoAppShell.GeckoInterface getGeckoInterface() {
        return GeckoAppShell.getGeckoInterface();
    }

    protected String getSharedPreferencesFile() {
        return "GeckoView";
    }

    @Override
    public SharedPreferences getSharedPreferences() {
        return this.getContext().getSharedPreferences(this.getSharedPreferencesFile(), 0);
    }

    public static interface ContentDelegate {
        public void onPageStart(GeckoView var1, Browser var2, String var3);

        public void onPageStop(GeckoView var1, Browser var2, boolean var3);

        public void onPageShow(GeckoView var1, Browser var2);

        public void onReceivedTitle(GeckoView var1, Browser var2, String var3);

        public void onReceivedFavicon(GeckoView var1, Browser var2, String var3, int var4);
    }

    public static interface ChromeDelegate {
        public void onReady(GeckoView var1);

        public void onAlert(GeckoView var1, Browser var2, String var3, PromptResult var4);

        public void onConfirm(GeckoView var1, Browser var2, String var3, PromptResult var4);

        public void onPrompt(GeckoView var1, Browser var2, String var3, String var4, PromptResult var5);

        public void onDebugRequest(GeckoView var1, PromptResult var2);

        public void onScriptMessage(GeckoView var1, Bundle var2, MessageResult var3);
    }

    public class MessageResult {
        private final EventCallback mCallback;

        public MessageResult(EventCallback eventCallback) {
            if (eventCallback == null) {
                throw new IllegalArgumentException("EventCallback should not be null.");
            }
            this.mCallback = eventCallback;
        }

        private JSONObject bundleToJSON(Bundle bundle) {
            JSONObject jSONObject = new JSONObject();
            if (bundle == null) {
                return jSONObject;
            }
            Set set = bundle.keySet();
            for (String string2 : set) {
                try {
                    jSONObject.put(string2, bundle.get(string2));
                }
                catch (JSONException jSONException) {}
            }
            return jSONObject;
        }

        public void success(Bundle bundle) {
            this.mCallback.sendSuccess((Object)this.bundleToJSON(bundle));
        }

        public void failure(Bundle bundle) {
            this.mCallback.sendError((Object)this.bundleToJSON(bundle));
        }
    }

    public class PromptResult {
        private final int RESULT_OK = 0;
        private final int RESULT_CANCEL = 1;
        private final JSONObject mMessage;

        public PromptResult(JSONObject jSONObject) {
            this.mMessage = jSONObject;
        }

        private JSONObject makeResult(int n) {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("button", n);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return jSONObject;
        }

        public void confirm() {
            JSONObject jSONObject = this.makeResult(0);
            EventDispatcher.sendResponse(this.mMessage, jSONObject);
        }

        public void confirmWithValue(String string2) {
            JSONObject jSONObject = this.makeResult(0);
            try {
                jSONObject.put("textbox0", (Object)string2);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            EventDispatcher.sendResponse(this.mMessage, jSONObject);
        }

        public void cancel() {
            JSONObject jSONObject = this.makeResult(1);
            EventDispatcher.sendResponse(this.mMessage, jSONObject);
        }
    }

    public class Browser {
        private final int mId;

        private Browser(int n) {
            this.mId = n;
        }

        private int getId() {
            return this.mId;
        }

        public void loadUrl(String string2) {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("url", (Object)string2);
                jSONObject.put("parentId", -1);
                jSONObject.put("newTab", false);
                jSONObject.put("tabID", this.mId);
            }
            catch (Exception exception) {
                Log.w((String)"GeckoView", (String)"Error building JSON arguments for loadUrl.", (Throwable)exception);
            }
            GeckoAppShell.notifyObservers("Tab:Load", jSONObject.toString());
        }
    }

    private static class StateBinder
    extends Binder
    implements Parcelable {
        public final Parcelable superState;
        public final Window window;
        @ReflectionTarget
        public static final Parcelable.Creator<StateBinder> CREATOR = new Parcelable.Creator<StateBinder>(){

            public StateBinder createFromParcel(Parcel parcel) {
                Parcelable parcelable = parcel.readParcelable(null);
                IBinder iBinder = parcel.readStrongBinder();
                if (iBinder instanceof StateBinder) {
                    return (StateBinder)iBinder;
                }
                return new StateBinder(parcelable, null);
            }

            public StateBinder[] newArray(int n) {
                return new StateBinder[n];
            }
        };

        public StateBinder(Parcelable parcelable, Window window) {
            this.superState = parcelable;
            this.window = window;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeParcelable(this.superState, n);
            parcel.writeStrongBinder((IBinder)this);
        }
    }

    @WrapForJNI
    private static final class Window
    extends JNIObject {
        final GLController glController = new GLController();

        private Window() {
        }

        static native void open(Window var0, GeckoView var1, GLController var2, String var3, int var4, int var5);

        protected native void disposeNative();

        native void close();

        native void reattach(GeckoView var1);
    }
}

