/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.SiteIdentity;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.ThumbnailHelper;
import org.mozilla.gecko.ZoomConstraints;
import org.mozilla.gecko.annotation.RobocopTarget;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.db.URLMetadata;
import org.mozilla.gecko.favicons.FaviconGenerator;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.favicons.OnFaviconLoadedListener;
import org.mozilla.gecko.favicons.RemoteFavicon;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.gfx.Layer;
import org.mozilla.gecko.reader.ReaderModeUtils;
import org.mozilla.gecko.reader.ReadingListHelper;
import org.mozilla.gecko.toolbar.BrowserToolbar;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.widget.SiteLogins;

public class Tab {
    private static final String LOGTAG = "GeckoTab";
    private static Pattern sColorPattern;
    private final int mId;
    private final BrowserDB mDB;
    private long mLastUsed;
    private String mUrl;
    private String mBaseDomain;
    private String mUserRequested;
    private String mTitle;
    private Bitmap mFavicon;
    private String mFaviconUrl;
    private String mApplicationId;
    final TreeSet<RemoteFavicon> mAvailableFavicons = new TreeSet();
    private boolean mHasFeeds;
    private boolean mHasOpenSearch;
    private final SiteIdentity mSiteIdentity;
    private SiteLogins mSiteLogins;
    private BitmapDrawable mThumbnail;
    private final int mParentId;
    private final boolean mExternal;
    private boolean mBookmark;
    private int mFaviconLoadId;
    private String mContentType;
    private boolean mHasTouchListeners;
    private ZoomConstraints mZoomConstraints;
    private boolean mIsRTL;
    private final ArrayList<View> mPluginViews;
    private final HashMap<Object, Layer> mPluginLayers;
    private int mBackgroundColor;
    private int mState;
    private Bitmap mThumbnailBitmap;
    private boolean mDesktopMode;
    private boolean mEnteringReaderMode;
    private final Context mAppContext;
    private ErrorType mErrorType = ErrorType.NONE;
    private volatile int mLoadProgress;
    private volatile int mRecordingCount;
    private volatile boolean mIsAudioPlaying;
    private String mMostRecentHomePanel;
    private boolean mShouldShowToolbarWithoutAnimationOnFirstSelection;
    private Bundle mMostRecentHomePanelData;
    private int mHistoryIndex;
    private int mHistorySize;
    private boolean mCanDoBack;
    private boolean mCanDoForward;
    private boolean mIsEditing;
    private final BrowserToolbar.TabEditingState mEditingState = new BrowserToolbar.TabEditingState();
    private boolean mLoadedFromCache;
    public static final int STATE_DELAYED = 0;
    public static final int STATE_LOADING = 1;
    public static final int STATE_SUCCESS = 2;
    public static final int STATE_ERROR = 3;
    public static final int LOAD_PROGRESS_INIT = 10;
    public static final int LOAD_PROGRESS_START = 20;
    public static final int LOAD_PROGRESS_LOCATION_CHANGE = 60;
    public static final int LOAD_PROGRESS_LOADED = 80;
    public static final int LOAD_PROGRESS_STOP = 100;
    private static final int DEFAULT_BACKGROUND_COLOR = -1;

    public Tab(Context context, int n, String string2, boolean bl, int n2, String string3) {
        this.mAppContext = context.getApplicationContext();
        this.mDB = GeckoProfile.get(context).getDB();
        this.mId = n;
        this.mUrl = string2;
        this.mBaseDomain = "";
        this.mUserRequested = "";
        this.mExternal = bl;
        this.mParentId = n2;
        this.mTitle = string3 == null ? "" : string3;
        this.mSiteIdentity = new SiteIdentity();
        this.mHistoryIndex = -1;
        this.mContentType = "";
        this.mZoomConstraints = new ZoomConstraints(false);
        this.mPluginViews = new ArrayList();
        this.mPluginLayers = new HashMap();
        this.mState = Tab.shouldShowProgress(string2) ? 1 : 2;
        this.mLoadProgress = 10;
        this.mBackgroundColor = -1;
        this.updateBookmark();
    }

    private ContentResolver getContentResolver() {
        return this.mAppContext.getContentResolver();
    }

    public void onDestroy() {
        Tabs.getInstance().notifyListeners(this, Tabs.TabEvents.CLOSED);
    }

    @RobocopTarget
    public int getId() {
        return this.mId;
    }

    public synchronized void onChange() {
        this.mLastUsed = System.currentTimeMillis();
    }

    public synchronized long getLastUsed() {
        return this.mLastUsed;
    }

    public int getParentId() {
        return this.mParentId;
    }

    public synchronized String getURL() {
        return this.mUrl;
    }

    public synchronized String getUserRequested() {
        return this.mUserRequested;
    }

    public synchronized String getTitle() {
        return this.mTitle;
    }

    public String getDisplayTitle() {
        if (this.mTitle != null && this.mTitle.length() > 0) {
            return this.mTitle;
        }
        return this.mUrl;
    }

    public String getBaseDomain() {
        return this.mBaseDomain;
    }

    public Bitmap getFavicon() {
        return this.mFavicon;
    }

    protected String getApplicationId() {
        return this.mApplicationId;
    }

    protected void setApplicationId(String string2) {
        this.mApplicationId = string2;
    }

    public BitmapDrawable getThumbnail() {
        return this.mThumbnail;
    }

    public String getMostRecentHomePanel() {
        return this.mMostRecentHomePanel;
    }

    public Bundle getMostRecentHomePanelData() {
        return this.mMostRecentHomePanelData;
    }

    public void setMostRecentHomePanel(String string2) {
        this.mMostRecentHomePanel = string2;
        this.mMostRecentHomePanelData = null;
    }

    public void setMostRecentHomePanelData(Bundle bundle) {
        this.mMostRecentHomePanelData = bundle;
    }

    public Bitmap getThumbnailBitmap(int n, int n2) {
        if (this.mThumbnailBitmap != null) {
            boolean bl;
            boolean bl2 = Build.VERSION.SDK_INT >= 11 && Build.VERSION.SDK_INT <= 13;
            boolean bl3 = bl = this.mThumbnailBitmap.getWidth() != n || this.mThumbnailBitmap.getHeight() != n2;
            if (bl2 || bl) {
                this.mThumbnailBitmap = null;
            }
        }
        if (this.mThumbnailBitmap == null) {
            Bitmap.Config config = GeckoAppShell.getScreenDepth() == 24 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
            this.mThumbnailBitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)config);
        }
        return this.mThumbnailBitmap;
    }

    public void updateThumbnail(final Bitmap bitmap, final ThumbnailHelper.CachePolicy cachePolicy) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (bitmap != null) {
                        try {
                            Tab.this.mThumbnail = new BitmapDrawable(Tab.this.mAppContext.getResources(), bitmap);
                            if (Tab.this.mState == 2 && cachePolicy == ThumbnailHelper.CachePolicy.STORE) {
                                Tab.this.saveThumbnailToDB(Tab.this.mDB);
                                break block5;
                            }
                            Tab.this.clearThumbnailFromDB(Tab.this.mDB);
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            Log.w((String)Tab.LOGTAG, (String)"Unable to create/scale bitmap.", (Throwable)outOfMemoryError);
                            Tab.this.mThumbnail = null;
                        }
                    } else {
                        Tab.this.mThumbnail = null;
                    }
                }
                Tabs.getInstance().notifyListeners(Tab.this, Tabs.TabEvents.THUMBNAIL);
            }
        });
    }

    public synchronized String getFaviconURL() {
        return this.mFaviconUrl;
    }

    public boolean hasFeeds() {
        return this.mHasFeeds;
    }

    public boolean hasOpenSearch() {
        return this.mHasOpenSearch;
    }

    public boolean hasLoadedFromCache() {
        return this.mLoadedFromCache;
    }

    public SiteIdentity getSiteIdentity() {
        return this.mSiteIdentity;
    }

    public void resetSiteIdentity() {
        if (this.mSiteIdentity != null) {
            this.mSiteIdentity.reset();
            Tabs.getInstance().notifyListeners(this, Tabs.TabEvents.SECURITY_CHANGE);
        }
    }

    public SiteLogins getSiteLogins() {
        return this.mSiteLogins;
    }

    public boolean isBookmark() {
        return this.mBookmark;
    }

    public boolean isExternal() {
        return this.mExternal;
    }

    public synchronized void updateURL(String string2) {
        if (string2 != null && string2.length() > 0) {
            this.mUrl = string2;
        }
    }

    public synchronized void updateUserRequested(String string2) {
        this.mUserRequested = string2;
    }

    public void setErrorType(String string2) {
        if ("blocked".equals(string2)) {
            this.setErrorType(ErrorType.BLOCKED);
        } else if ("certerror".equals(string2)) {
            this.setErrorType(ErrorType.CERT_ERROR);
        } else if ("neterror".equals(string2)) {
            this.setErrorType(ErrorType.NET_ERROR);
        } else {
            this.setErrorType(ErrorType.NONE);
        }
    }

    public void setErrorType(ErrorType errorType) {
        this.mErrorType = errorType;
    }

    public void setMetadata(JSONObject jSONObject) {
        if (jSONObject == null) {
            return;
        }
        final ContentResolver contentResolver = this.mAppContext.getContentResolver();
        final URLMetadata uRLMetadata = this.mDB.getURLMetadata();
        final Map<String, Object> map = uRLMetadata.fromJSON(jSONObject);
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                uRLMetadata.save(contentResolver, map);
            }
        });
    }

    public ErrorType getErrorType() {
        return this.mErrorType;
    }

    public void setContentType(String string2) {
        this.mContentType = string2 == null ? "" : string2;
    }

    public String getContentType() {
        return this.mContentType;
    }

    public int getHistoryIndex() {
        return this.mHistoryIndex;
    }

    public int getHistorySize() {
        return this.mHistorySize;
    }

    public synchronized void updateTitle(String string2) {
        if (this.mEnteringReaderMode) {
            return;
        }
        if (this.mTitle != null && TextUtils.equals((CharSequence)this.mTitle, (CharSequence)string2)) {
            return;
        }
        this.mTitle = string2 == null ? "" : string2;
        Tabs.getInstance().notifyListeners(this, Tabs.TabEvents.TITLE);
    }

    public void setState(int n) {
        this.mState = n;
        if (this.mState != 1) {
            this.mEnteringReaderMode = false;
        }
    }

    public int getState() {
        return this.mState;
    }

    public void setZoomConstraints(ZoomConstraints zoomConstraints) {
        this.mZoomConstraints = zoomConstraints;
    }

    public ZoomConstraints getZoomConstraints() {
        return this.mZoomConstraints;
    }

    public void setIsRTL(boolean bl) {
        this.mIsRTL = bl;
    }

    public boolean getIsRTL() {
        return this.mIsRTL;
    }

    public void setHasTouchListeners(boolean bl) {
        this.mHasTouchListeners = bl;
    }

    public boolean getHasTouchListeners() {
        return this.mHasTouchListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addFavicon(String string2, int n, String string3) {
        RemoteFavicon remoteFavicon = new RemoteFavicon(string2, n, string3);
        TreeSet<RemoteFavicon> treeSet = this.mAvailableFavicons;
        synchronized (treeSet) {
            this.mAvailableFavicons.add(remoteFavicon);
        }
    }

    public void loadFavicon() {
        Object object;
        if (AboutPages.isBuiltinIconPage(this.mUrl) && this.mFavicon != null) {
            return;
        }
        if (!this.mAvailableFavicons.isEmpty()) {
            object = this.mAvailableFavicons.first();
            if (object.faviconUrl.equals(this.mFaviconUrl)) {
                return;
            }
            Favicons.cancelFaviconLoad(this.mFaviconLoadId);
            this.mFaviconUrl = object.faviconUrl;
        } else {
            this.mFaviconUrl = null;
        }
        object = this.mSiteIdentity.getSecurityMode() == SiteIdentity.SecurityMode.CHROMEUI ? Favicons.LoadType.PRIVILEGED : Favicons.LoadType.UNPRIVILEGED;
        int n = this.isPrivate() || this.mErrorType != ErrorType.NONE ? 0 : 1;
        this.mFaviconLoadId = Favicons.getSizedFavicon(this.mAppContext, this.mUrl, this.mFaviconUrl, (Favicons.LoadType)((Object)object), Favicons.browserToolbarFaviconSize, n, new OnFaviconLoadedListener(){

            @Override
            public void onFaviconLoaded(String string2, String string3, Bitmap bitmap) {
                if (!string2.equals(Tab.this.mUrl)) {
                    return;
                }
                if (bitmap == null) {
                    if (!Tab.this.mAvailableFavicons.isEmpty()) {
                        Tab.this.mAvailableFavicons.remove(Tab.this.mAvailableFavicons.first());
                        Tab.this.loadFavicon();
                        return;
                    }
                    FaviconGenerator.generate(Tab.this.mAppContext, Tab.this.mUrl, this);
                    return;
                }
                Tab.this.mFavicon = bitmap;
                Tab.this.mFaviconLoadId = 0;
                Tabs.getInstance().notifyListeners(Tab.this, Tabs.TabEvents.FAVICON);
            }
        });
    }

    public synchronized void clearFavicon() {
        Favicons.cancelFaviconLoad(this.mFaviconLoadId);
        if (this.mEnteringReaderMode) {
            return;
        }
        this.mFavicon = null;
        this.mFaviconUrl = null;
        this.mAvailableFavicons.clear();
    }

    public void setHasFeeds(boolean bl) {
        this.mHasFeeds = bl;
    }

    public void setHasOpenSearch(boolean bl) {
        this.mHasOpenSearch = bl;
    }

    public void setLoadedFromCache(boolean bl) {
        this.mLoadedFromCache = bl;
    }

    public void updateIdentityData(JSONObject jSONObject) {
        this.mSiteIdentity.update(jSONObject);
    }

    public void setSiteLogins(SiteLogins siteLogins) {
        this.mSiteLogins = siteLogins;
    }

    void updateBookmark() {
        if (this.getURL() == null) {
            return;
        }
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                String string2 = Tab.this.getURL();
                if (string2 == null) {
                    return;
                }
                String string3 = ReaderModeUtils.stripAboutReaderUrl(string2);
                Tab.this.mBookmark = Tab.this.mDB.isBookmark(Tab.this.getContentResolver(), string3);
                Tabs.getInstance().notifyListeners(Tab.this, Tabs.TabEvents.MENU_UPDATED);
            }
        });
    }

    public void addBookmark() {
        String string2 = this.getURL();
        if (string2 == null) {
            return;
        }
        final String string3 = ReaderModeUtils.stripAboutReaderUrl(this.getURL());
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Tab.this.mDB.addBookmark(Tab.this.getContentResolver(), Tab.this.mTitle, string3);
                Tabs.getInstance().notifyListeners(Tab.this, Tabs.TabEvents.BOOKMARK_ADDED);
            }
        });
        if (AboutPages.isAboutReader(string2)) {
            ReadingListHelper.cacheReaderItem(string3, this.mId, this.mAppContext);
        }
    }

    public void removeBookmark() {
        String string2 = this.getURL();
        if (string2 == null) {
            return;
        }
        final String string3 = ReaderModeUtils.stripAboutReaderUrl(this.getURL());
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Tab.this.mDB.removeBookmarksWithURL(Tab.this.getContentResolver(), string3);
                Tabs.getInstance().notifyListeners(Tab.this, Tabs.TabEvents.BOOKMARK_REMOVED);
            }
        });
        ReadingListHelper.removeCachedReaderItem(string3, this.mAppContext);
    }

    public boolean isEnteringReaderMode() {
        return this.mEnteringReaderMode;
    }

    public void doReload(boolean bl) {
        GeckoAppShell.notifyObservers("Session:Reload", "{\"bypassCache\":" + String.valueOf(bl) + "}");
    }

    public boolean canDoBack() {
        return this.mCanDoBack;
    }

    public boolean doBack() {
        if (!this.canDoBack()) {
            return false;
        }
        GeckoAppShell.notifyObservers("Session:Back", "");
        return true;
    }

    public void doStop() {
        GeckoAppShell.notifyObservers("Session:Stop", "");
    }

    public boolean canDoForward() {
        return this.mCanDoForward;
    }

    public boolean doForward() {
        if (!this.canDoForward()) {
            return false;
        }
        GeckoAppShell.notifyObservers("Session:Forward", "");
        return true;
    }

    void handleLocationChange(JSONObject jSONObject) throws JSONException {
        String string2 = jSONObject.getString("uri");
        String string3 = this.getURL();
        boolean bl = jSONObject.getBoolean("sameDocument");
        this.mEnteringReaderMode = ReaderModeUtils.isEnteringReaderMode(string3, string2);
        this.mHistoryIndex = jSONObject.getInt("historyIndex");
        this.mHistorySize = jSONObject.getInt("historySize");
        this.mCanDoBack = jSONObject.getBoolean("canGoBack");
        this.mCanDoForward = jSONObject.getBoolean("canGoForward");
        if (!TextUtils.equals((CharSequence)string3, (CharSequence)string2)) {
            this.updateURL(string2);
            this.updateBookmark();
            if (!bl) {
                this.clearFavicon();
                if (AboutPages.isBuiltinIconPage(string2)) {
                    this.loadFavicon();
                }
                this.updateTitle(null);
            }
        }
        if (bl) {
            Tabs.getInstance().notifyListeners(this, Tabs.TabEvents.LOCATION_CHANGE, string3);
            return;
        }
        this.setContentType(jSONObject.getString("contentType"));
        this.updateUserRequested(jSONObject.getString("userRequested"));
        this.mBaseDomain = jSONObject.optString("baseDomain");
        this.setHasFeeds(false);
        this.setHasOpenSearch(false);
        this.mSiteIdentity.reset();
        this.setSiteLogins(null);
        this.setZoomConstraints(new ZoomConstraints(true));
        this.setHasTouchListeners(false);
        this.setBackgroundColor(-1);
        this.setErrorType(ErrorType.NONE);
        this.setLoadProgressIfLoading(60);
        Tabs.getInstance().notifyListeners(this, Tabs.TabEvents.LOCATION_CHANGE, string3);
    }

    private static boolean shouldShowProgress(String string2) {
        return !AboutPages.isAboutPage(string2);
    }

    void handleDocumentStart(boolean bl, String string2) {
        this.setLoadProgress(20);
        this.setState(!bl && Tab.shouldShowProgress(string2) ? 1 : 2);
        this.mSiteIdentity.reset();
    }

    void handleDocumentStop(boolean bl) {
        this.setState(bl ? 2 : 3);
        final String string2 = this.getURL();
        final Tab tab = this;
        tab.setLoadProgress(100);
        ThreadUtils.getBackgroundHandler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!TextUtils.equals((CharSequence)string2, (CharSequence)Tab.this.getURL())) {
                    return;
                }
                ThumbnailHelper.getInstance().getAndProcessThumbnailFor(tab);
            }
        }, 500L);
    }

    void handleContentLoaded() {
        this.setLoadProgressIfLoading(80);
    }

    protected void saveThumbnailToDB(BrowserDB browserDB) {
        BitmapDrawable bitmapDrawable = this.mThumbnail;
        if (bitmapDrawable == null) {
            return;
        }
        try {
            String string2 = this.getURL();
            if (string2 == null) {
                return;
            }
            browserDB.updateThumbnailForUrl(this.getContentResolver(), string2, bitmapDrawable);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadThumbnailFromDB(BrowserDB browserDB) {
        try {
            String string2 = this.getURL();
            if (string2 == null) {
                return;
            }
            byte[] byArray = browserDB.getThumbnailForUrl(this.getContentResolver(), string2);
            if (byArray == null) {
                return;
            }
            Bitmap bitmap = BitmapUtils.decodeByteArray(byArray);
            this.mThumbnail = new BitmapDrawable(this.mAppContext.getResources(), bitmap);
            Tabs.getInstance().notifyListeners(this, Tabs.TabEvents.THUMBNAIL);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void clearThumbnailFromDB(BrowserDB browserDB) {
        try {
            String string2 = this.getURL();
            if (string2 == null) {
                return;
            }
            browserDB.updateThumbnailForUrl(this.getContentResolver(), string2, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addPluginView(View view) {
        this.mPluginViews.add(view);
    }

    public void removePluginView(View view) {
        this.mPluginViews.remove(view);
    }

    public View[] getPluginViews() {
        return this.mPluginViews.toArray(new View[this.mPluginViews.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPluginLayer(Object object, Layer layer) {
        HashMap<Object, Layer> hashMap = this.mPluginLayers;
        synchronized (hashMap) {
            this.mPluginLayers.put(object, layer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer getPluginLayer(Object object) {
        HashMap<Object, Layer> hashMap = this.mPluginLayers;
        synchronized (hashMap) {
            return this.mPluginLayers.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Layer> getPluginLayers() {
        HashMap<Object, Layer> hashMap = this.mPluginLayers;
        synchronized (hashMap) {
            return new ArrayList<Layer>(this.mPluginLayers.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer removePluginLayer(Object object) {
        HashMap<Object, Layer> hashMap = this.mPluginLayers;
        synchronized (hashMap) {
            return this.mPluginLayers.remove(object);
        }
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public void setBackgroundColor(int n) {
        this.mBackgroundColor = n;
    }

    public void setBackgroundColor(String string2) {
        this.setBackgroundColor(Tab.parseColorFromGecko(string2));
    }

    private static int parseColorFromGecko(String string2) {
        Matcher matcher;
        if (sColorPattern == null) {
            sColorPattern = Pattern.compile("rgb\\((\\d+),\\s*(\\d+),\\s*(\\d+)\\)");
        }
        if (!(matcher = sColorPattern.matcher(string2)).matches()) {
            return -1;
        }
        int n = Integer.parseInt(matcher.group(1));
        int n2 = Integer.parseInt(matcher.group(2));
        int n3 = Integer.parseInt(matcher.group(3));
        return Color.rgb((int)n, (int)n2, (int)n3);
    }

    public void setDesktopMode(boolean bl) {
        this.mDesktopMode = bl;
    }

    public boolean getDesktopMode() {
        return this.mDesktopMode;
    }

    public boolean isPrivate() {
        return false;
    }

    void setLoadProgress(int n) {
        this.mLoadProgress = n;
    }

    void setLoadProgressIfLoading(int n) {
        if (this.getState() == 1) {
            this.setLoadProgress(n);
        }
    }

    public int getLoadProgress() {
        return this.mLoadProgress;
    }

    public void setRecording(boolean bl) {
        this.mRecordingCount = bl ? ++this.mRecordingCount : --this.mRecordingCount;
    }

    public boolean isRecording() {
        return this.mRecordingCount > 0;
    }

    public void setIsAudioPlaying(boolean bl) {
        this.mIsAudioPlaying = bl;
    }

    public boolean isAudioPlaying() {
        return this.mIsAudioPlaying;
    }

    public boolean isEditing() {
        return this.mIsEditing;
    }

    public void setIsEditing(boolean bl) {
        this.mIsEditing = bl;
    }

    public BrowserToolbar.TabEditingState getEditingState() {
        return this.mEditingState;
    }

    public void setShouldShowToolbarWithoutAnimationOnFirstSelection(boolean bl) {
        this.mShouldShowToolbarWithoutAnimationOnFirstSelection = bl;
    }

    public boolean getShouldShowToolbarWithoutAnimationOnFirstSelection() {
        return this.mShouldShowToolbarWithoutAnimationOnFirstSelection;
    }

    public static enum ErrorType {
        CERT_ERROR,
        BLOCKED,
        NET_ERROR,
        NONE;

    }
}

