/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.delegates;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.CallSuper;
import android.support.v4.content.ContextCompat;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.BrowserApp;
import org.mozilla.gecko.R;
import org.mozilla.gecko.SnackbarHelper;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.delegates.TabsTrayVisibilityAwareDelegate;

public class OfflineTabStatusDelegate
extends TabsTrayVisibilityAwareDelegate
implements Tabs.OnTabsChangedListener {
    private WeakReference<Activity> activityReference;
    private WeakHashMap<Tab, Void> tabsQueuedForOfflineSnackbar = new WeakHashMap();

    @Override
    @CallSuper
    public void onCreate(BrowserApp browserApp, Bundle bundle) {
        super.onCreate(browserApp, bundle);
        this.activityReference = new WeakReference<BrowserApp>(browserApp);
    }

    @Override
    public void onResume(BrowserApp browserApp) {
        Tabs.registerOnTabsChangedListener(this);
    }

    @Override
    public void onPause(BrowserApp browserApp) {
        Tabs.unregisterOnTabsChangedListener(this);
    }

    @Override
    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, String string2) {
        if (tab == null) {
            return;
        }
        if (!tab.hasLoadedFromCache()) {
            return;
        }
        if (AboutPages.isAboutPage(tab.getURL())) {
            return;
        }
        switch (tabEvents) {
            case PAGE_SHOW: {
                if (!this.isTabsTrayVisible() && Tabs.getInstance().isSelectedTab(tab)) {
                    OfflineTabStatusDelegate.showLoadedOfflineSnackbar((Activity)this.activityReference.get());
                    break;
                }
                this.tabsQueuedForOfflineSnackbar.put(tab, null);
                break;
            }
            case OPENED_FROM_TABS_TRAY: 
            case SELECTED: {
                if (this.isTabsTrayVisible() || !this.tabsQueuedForOfflineSnackbar.containsKey(tab)) break;
                OfflineTabStatusDelegate.showLoadedOfflineSnackbar((Activity)this.activityReference.get());
                this.tabsQueuedForOfflineSnackbar.remove(tab);
            }
        }
    }

    private static void showLoadedOfflineSnackbar(Activity activity) {
        if (activity == null) {
            return;
        }
        Telemetry.sendUIEvent(TelemetryContract.Event.NETERROR, TelemetryContract.Method.TOAST, "usecache");
        SnackbarHelper.showSnackbarWithActionAndColors(activity, activity.getResources().getString(R.string.tab_offline_version), -2, null, null, null, ContextCompat.getColor((Context)activity, (int)R.color.link_blue), null);
    }
}

