/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.content.Context;
import android.util.Log;
import android.view.ViewConfiguration;
import org.mozilla.gecko.annotation.WrapForJNI;

@WrapForJNI(allowMultithread=true, catchException=true)
public class StackScroller {
    private int mMode;
    private final SplineStackScroller mScrollerX;
    private final SplineStackScroller mScrollerY;
    private final boolean mFlywheel;
    private static final int SCROLL_MODE = 0;
    private static final int FLING_MODE = 1;
    private static float sViscousFluidScale;
    private static float sViscousFluidNormalize;

    public StackScroller(Context context) {
        this.mFlywheel = true;
        this.mScrollerX = new SplineStackScroller(context);
        this.mScrollerY = new SplineStackScroller(context);
        StackScroller.initContants();
    }

    private static void initContants() {
        sViscousFluidScale = 8.0f;
        sViscousFluidNormalize = 1.0f;
        sViscousFluidNormalize = 1.0f / StackScroller.viscousFluid(1.0f);
    }

    public final boolean isFinished() {
        return this.mScrollerX.mFinished && this.mScrollerY.mFinished;
    }

    public final void forceFinished(boolean bl) {
        this.mScrollerX.mFinished = (this.mScrollerY.mFinished = bl);
    }

    public final int getCurrX() {
        return this.mScrollerX.mCurrentPosition;
    }

    public final int getCurrY() {
        return this.mScrollerY.mCurrentPosition;
    }

    public final int getFinalX() {
        return this.mScrollerX.mFinal;
    }

    public final float getCurrSpeedX() {
        return this.mScrollerX.mCurrVelocity;
    }

    public final float getCurrSpeedY() {
        return this.mScrollerY.mCurrVelocity;
    }

    public final int getFinalY() {
        return this.mScrollerY.mFinal;
    }

    public final void setFinalX(int n) {
        this.mScrollerX.setFinalPosition(n);
    }

    private static float viscousFluid(float f) {
        if ((f *= sViscousFluidScale) < 1.0f) {
            f -= 1.0f - (float)Math.exp(-f);
        } else {
            float f2 = 0.36787945f;
            f = 1.0f - (float)Math.exp(1.0f - f);
            f = f2 + f * (1.0f - f2);
        }
        return f *= sViscousFluidNormalize;
    }

    public boolean computeScrollOffset(long l) {
        if (this.isFinished()) {
            return false;
        }
        switch (this.mMode) {
            case 0: {
                long l2 = l - this.mScrollerX.mStartTime;
                int n = this.mScrollerX.mDuration;
                if (l2 < (long)n) {
                    float f = (float)l2 / (float)n;
                    f = StackScroller.viscousFluid(f);
                    this.mScrollerX.updateScroll(f);
                    this.mScrollerY.updateScroll(f);
                    break;
                }
                this.abortAnimation();
                break;
            }
            case 1: {
                if (!(this.mScrollerX.mFinished || this.mScrollerX.update(l) || this.mScrollerX.continueWhenFinished(l))) {
                    this.mScrollerX.finish();
                }
                if (this.mScrollerY.mFinished || this.mScrollerY.update(l) || this.mScrollerY.continueWhenFinished(l)) break;
                this.mScrollerY.finish();
                break;
            }
        }
        return true;
    }

    public void startScroll(int n, int n2, int n3, int n4, long l, int n5) {
        this.mMode = 0;
        this.mScrollerX.startScroll(n, n3, l, n5);
        this.mScrollerY.startScroll(n2, n4, l, n5);
    }

    public boolean springBack(int n, int n2, int n3, int n4, int n5, int n6, long l) {
        this.mMode = 1;
        boolean bl = this.mScrollerX.springback(n, n3, n4, l);
        boolean bl2 = this.mScrollerY.springback(n2, n5, n6, l);
        return bl || bl2;
    }

    public void fling(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, long l) {
        if (this.mFlywheel && !this.isFinished()) {
            float f = this.mScrollerX.mCurrVelocity;
            float f2 = this.mScrollerY.mCurrVelocity;
            if (Math.signum(n3) == Math.signum(f) && Math.signum(n4) == Math.signum(f2)) {
                n3 = (int)((float)n3 + f);
                n4 = (int)((float)n4 + f2);
            }
        }
        this.mMode = 1;
        this.mScrollerX.fling(n, n3, n5, n6, n9, l);
        this.mScrollerY.fling(n2, n4, n7, n8, n10, l);
    }

    public void abortAnimation() {
        this.mScrollerX.finish();
        this.mScrollerY.finish();
    }

    static class SplineStackScroller {
        private int mStart;
        private int mCurrentPosition;
        private int mFinal;
        private int mVelocity;
        private float mCurrVelocity;
        private float mDeceleration;
        private long mStartTime;
        private int mDuration;
        private int mSplineDuration;
        private int mSplineDistance;
        private boolean mFinished = true;
        private int mOver;
        private final float mFlingFriction = ViewConfiguration.getScrollFriction();
        private int mState = 0;
        private static final float GRAVITY = 2000.0f;
        private final float mPhysicalCoeff;
        private static final float DECELERATION_RATE = (float)(Math.log(0.78) / Math.log(0.9));
        private static final float INFLEXION = 0.35f;
        private static final float START_TENSION = 0.5f;
        private static final float END_TENSION = 1.0f;
        private static final float P1 = 0.175f;
        private static final float P2 = 0.35000002f;
        private static final int NB_SAMPLES = 100;
        private static final float[] SPLINE_POSITION = new float[101];
        private static final float[] SPLINE_TIME = new float[101];
        private static final int SPLINE = 0;
        private static final int CUBIC = 1;
        private static final int BALLISTIC = 2;

        SplineStackScroller(Context context) {
            float f = context.getResources().getDisplayMetrics().density * 160.0f;
            this.mPhysicalCoeff = 386.0878f * f * 0.84f;
        }

        void updateScroll(float f) {
            this.mCurrentPosition = this.mStart + Math.round(f * (float)(this.mFinal - this.mStart));
        }

        private static float getDeceleration(int n) {
            return n > 0 ? -2000.0f : 2000.0f;
        }

        private void adjustDuration(int n, int n2, int n3) {
            int n4 = n3 - n;
            int n5 = n2 - n;
            float f = Math.abs((float)n4 / (float)n5);
            int n6 = (int)(100.0f * f);
            if (n6 < 100) {
                float f2 = (float)n6 / 100.0f;
                float f3 = (float)(n6 + 1) / 100.0f;
                float f4 = SPLINE_TIME[n6];
                float f5 = SPLINE_TIME[n6 + 1];
                float f6 = f4 + (f - f2) / (f3 - f2) * (f5 - f4);
                this.mDuration = (int)((float)this.mDuration * f6);
            }
        }

        void startScroll(int n, int n2, long l, int n3) {
            this.mFinished = false;
            this.mStart = n;
            this.mFinal = n + n2;
            this.mStartTime = l;
            this.mDuration = n3;
            this.mDeceleration = 0.0f;
            this.mVelocity = 0;
        }

        void finish() {
            this.mCurrentPosition = this.mFinal;
            this.mFinished = true;
        }

        void setFinalPosition(int n) {
            this.mFinal = n;
            this.mFinished = false;
        }

        boolean springback(int n, int n2, int n3, long l) {
            this.mFinished = true;
            this.mStart = this.mFinal = n;
            this.mVelocity = 0;
            this.mStartTime = l;
            this.mDuration = 0;
            if (n < n2) {
                this.startSpringback(n, n2, 0);
            } else if (n > n3) {
                this.startSpringback(n, n3, 0);
            }
            return !this.mFinished;
        }

        private void startSpringback(int n, int n2, int n3) {
            this.mFinished = false;
            this.mState = 1;
            this.mStart = n;
            this.mFinal = n2;
            int n4 = n - n2;
            this.mDeceleration = SplineStackScroller.getDeceleration(n4);
            this.mVelocity = -n4;
            this.mOver = Math.abs(n4);
            this.mDuration = (int)(1000.0 * Math.sqrt(-2.0 * (double)n4 / (double)this.mDeceleration));
        }

        void fling(int n, int n2, int n3, int n4, int n5, long l) {
            this.mOver = n5;
            this.mFinished = false;
            this.mVelocity = n2;
            this.mCurrVelocity = this.mVelocity;
            this.mSplineDuration = 0;
            this.mDuration = 0;
            this.mStartTime = l;
            this.mCurrentPosition = this.mStart = n;
            if (n > n4 || n < n3) {
                this.startAfterEdge(n, n3, n4, n2, l);
                return;
            }
            this.mState = 0;
            double d = 0.0;
            if (n2 != 0) {
                this.mDuration = this.mSplineDuration = this.getSplineFlingDuration(n2);
                d = this.getSplineFlingDistance(n2);
            }
            this.mSplineDistance = (int)(d * (double)Math.signum(n2));
            this.mFinal = n + this.mSplineDistance;
            if (this.mFinal < n3) {
                this.adjustDuration(this.mStart, this.mFinal, n3);
                this.mFinal = n3;
            }
            if (this.mFinal > n4) {
                this.adjustDuration(this.mStart, this.mFinal, n4);
                this.mFinal = n4;
            }
        }

        private double getSplineDeceleration(int n) {
            return Math.log(0.35f * (float)Math.abs(n) / (this.mFlingFriction * this.mPhysicalCoeff));
        }

        private double getSplineFlingDistance(int n) {
            double d = this.getSplineDeceleration(n);
            double d2 = (double)DECELERATION_RATE - 1.0;
            return (double)(this.mFlingFriction * this.mPhysicalCoeff) * Math.exp((double)DECELERATION_RATE / d2 * d);
        }

        private int getSplineFlingDuration(int n) {
            double d = this.getSplineDeceleration(n);
            double d2 = (double)DECELERATION_RATE - 1.0;
            return (int)(1000.0 * Math.exp(d / d2));
        }

        private void fitOnBounceCurve(int n, int n2, int n3) {
            float f = (float)(-n3) / this.mDeceleration;
            float f2 = (float)(n3 * n3) / 2.0f / Math.abs(this.mDeceleration);
            float f3 = Math.abs(n2 - n);
            float f4 = (float)Math.sqrt(2.0 * (double)(f2 + f3) / (double)Math.abs(this.mDeceleration));
            this.mStartTime -= (long)((int)(1000.0f * (f4 - f)));
            this.mStart = n2;
            this.mVelocity = (int)(-this.mDeceleration * f4);
        }

        private void startBounceAfterEdge(int n, int n2, int n3) {
            this.mDeceleration = SplineStackScroller.getDeceleration(n3 == 0 ? n - n2 : n3);
            this.fitOnBounceCurve(n, n2, n3);
            this.onEdgeReached();
        }

        private void startAfterEdge(int n, int n2, int n3, int n4, long l) {
            boolean bl;
            if (n > n2 && n < n3) {
                Log.e((String)"StackScroller", (String)"startAfterEdge called from a valid position");
                this.mFinished = true;
                return;
            }
            boolean bl2 = n > n3;
            int n5 = bl2 ? n3 : n2;
            int n6 = n - n5;
            boolean bl3 = bl = n6 * n4 >= 0;
            if (bl) {
                this.startBounceAfterEdge(n, n5, n4);
            } else {
                double d = this.getSplineFlingDistance(n4);
                if (d > (double)Math.abs(n6)) {
                    this.fling(n, n4, bl2 ? n2 : n, bl2 ? n : n3, this.mOver, l);
                } else {
                    this.startSpringback(n, n5, n4);
                }
            }
        }

        private void onEdgeReached() {
            float f = (float)(this.mVelocity * this.mVelocity) / (2.0f * Math.abs(this.mDeceleration));
            float f2 = Math.signum(this.mVelocity);
            if (f > (float)this.mOver) {
                this.mDeceleration = -f2 * (float)this.mVelocity * (float)this.mVelocity / (2.0f * (float)this.mOver);
                f = this.mOver;
            }
            this.mOver = (int)f;
            this.mState = 2;
            this.mFinal = this.mStart + (int)(this.mVelocity > 0 ? f : -f);
            this.mDuration = -((int)(1000.0f * (float)this.mVelocity / this.mDeceleration));
        }

        boolean continueWhenFinished(long l) {
            switch (this.mState) {
                case 0: {
                    if (this.mDuration < this.mSplineDuration) {
                        this.mStart = this.mFinal;
                        this.mVelocity = (int)this.mCurrVelocity;
                        this.mDeceleration = SplineStackScroller.getDeceleration(this.mVelocity);
                        this.mStartTime += (long)this.mDuration;
                        this.onEdgeReached();
                        break;
                    }
                    return false;
                }
                case 2: {
                    this.mStartTime += (long)this.mDuration;
                    this.startSpringback(this.mFinal, this.mStart, 0);
                    break;
                }
                case 1: {
                    return false;
                }
            }
            this.update(l);
            return true;
        }

        boolean update(long l) {
            long l2 = l - this.mStartTime;
            if (this.mState == 0 && this.mSplineDuration <= 0 || this.mState == 1 && this.mDuration <= 0) {
                return false;
            }
            if (l2 > (long)this.mDuration) {
                return false;
            }
            double d = 0.0;
            switch (this.mState) {
                case 0: {
                    float f = (float)l2 / (float)this.mSplineDuration;
                    int n = (int)(100.0f * f);
                    float f2 = 1.0f;
                    float f3 = 0.0f;
                    if (n < 100) {
                        float f4 = (float)n / 100.0f;
                        float f5 = (float)(n + 1) / 100.0f;
                        float f6 = SPLINE_POSITION[n];
                        float f7 = SPLINE_POSITION[n + 1];
                        f3 = (f7 - f6) / (f5 - f4);
                        f2 = f6 + (f - f4) * f3;
                    }
                    d = f2 * (float)this.mSplineDistance;
                    this.mCurrVelocity = f3 * (float)this.mSplineDistance / (float)this.mSplineDuration * 1000.0f;
                    break;
                }
                case 2: {
                    float f = (float)l2 / 1000.0f;
                    this.mCurrVelocity = (float)this.mVelocity + this.mDeceleration * f;
                    d = (float)this.mVelocity * f + this.mDeceleration * f * f / 2.0f;
                    break;
                }
                case 1: {
                    float f = (float)l2 / (float)this.mDuration;
                    float f8 = f * f;
                    float f9 = Math.signum(this.mVelocity);
                    d = f9 * (float)this.mOver * (3.0f * f8 - 2.0f * f * f8);
                    this.mCurrVelocity = f9 * (float)this.mOver * 6.0f * (-f + f8);
                    break;
                }
            }
            this.mCurrentPosition = this.mStart + (int)Math.round(d);
            return true;
        }

        static {
            float f = 0.0f;
            float f2 = 0.0f;
            for (int i = 0; i < 100; ++i) {
                float f3;
                float f4;
                float f5;
                float f6;
                float f7;
                float f8 = (float)i / 100.0f;
                float f9 = 1.0f;
                while (!((double)Math.abs((f7 = (f6 = 3.0f * (f5 = f + (f9 - f) / 2.0f) * (1.0f - f5)) * ((1.0f - f5) * 0.175f + f5 * 0.35000002f) + f5 * f5 * f5) - f8) < 1.0E-5)) {
                    if (f7 > f8) {
                        f9 = f5;
                        continue;
                    }
                    f = f5;
                }
                SplineStackScroller.SPLINE_POSITION[i] = f6 * ((1.0f - f5) * 0.5f + f5) + f5 * f5 * f5;
                float f10 = 1.0f;
                while (!((double)Math.abs((f4 = (f6 = 3.0f * (f3 = f2 + (f10 - f2) / 2.0f) * (1.0f - f3)) * ((1.0f - f3) * 0.5f + f3) + f3 * f3 * f3) - f8) < 1.0E-5)) {
                    if (f4 > f8) {
                        f10 = f3;
                        continue;
                    }
                    f2 = f3;
                }
                SplineStackScroller.SPLINE_TIME[i] = f6 * ((1.0f - f3) * 0.175f + f3 * 0.35000002f) + f3 * f3 * f3;
            }
            SplineStackScroller.SPLINE_TIME[100] = 1.0f;
            SplineStackScroller.SPLINE_POSITION[100] = 1.0f;
        }
    }
}

