/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.R;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.UIAsyncTask;

public class BookmarkFolderView
extends LinearLayout {
    private static final Set<Integer> FOLDERS_WITH_COUNT;
    private final TextView mTitle;
    private final TextView mSubtitle;
    private final ImageView mIcon;

    public BookmarkFolderView(Context context) {
        this(context, null);
    }

    public BookmarkFolderView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        LayoutInflater.from((Context)context).inflate(R.layout.two_line_folder_row, (ViewGroup)this);
        this.mTitle = (TextView)this.findViewById(R.id.title);
        this.mSubtitle = (TextView)this.findViewById(R.id.subtitle);
        this.mIcon = (ImageView)this.findViewById(R.id.icon);
    }

    public void update(String string2, int n) {
        this.setTitle(string2);
        this.setID(n);
    }

    private void setTitle(String string2) {
        this.mTitle.setText((CharSequence)string2);
    }

    private void setID(int n) {
        if (FOLDERS_WITH_COUNT.contains(n)) {
            WeakReference<TextView> weakReference = new WeakReference<TextView>(this.mSubtitle);
            new ItemCountUpdateTask(weakReference, n).execute();
        } else {
            this.mSubtitle.setVisibility(8);
        }
    }

    public void setState(@NonNull FolderState folderState) {
        this.mIcon.setImageResource(folderState.image);
    }

    static {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        treeSet.add(-5);
        FOLDERS_WITH_COUNT = Collections.unmodifiableSet(treeSet);
    }

    private static class ItemCountUpdateTask
    extends UIAsyncTask.WithoutParams<Integer> {
        private final WeakReference<TextView> mTextViewReference;
        private final int mFolderID;

        public ItemCountUpdateTask(WeakReference<TextView> weakReference, int n) {
            super(ThreadUtils.getBackgroundHandler());
            this.mTextViewReference = weakReference;
            this.mFolderID = n;
        }

        protected Integer doInBackground() {
            TextView textView = (TextView)this.mTextViewReference.get();
            if (textView == null) {
                return null;
            }
            BrowserDB browserDB = GeckoProfile.get(textView.getContext()).getDB();
            return browserDB.getBookmarkCountForFolder(textView.getContext().getContentResolver(), this.mFolderID);
        }

        protected void onPostExecute(Integer n) {
            TextView textView = (TextView)this.mTextViewReference.get();
            if (textView == null) {
                return;
            }
            String string2 = n == 1 ? textView.getContext().getResources().getString(R.string.bookmark_folder_one_item) : textView.getContext().getResources().getString(R.string.bookmark_folder_items, new Object[]{n});
            textView.setText((CharSequence)string2);
            textView.setVisibility(0);
        }
    }

    public static enum FolderState {
        FOLDER(R.drawable.folder_closed),
        PARENT(R.drawable.bookmark_folder_arrow_up),
        READING_LIST(R.drawable.reading_list_folder);

        public final int image;

        private FolderState(int n2) {
            this.image = n2;
        }
    }
}

