/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.home.FramePanelLayout;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.home.HomeFragment;
import org.mozilla.gecko.home.PanelAuthCache;
import org.mozilla.gecko.home.PanelAuthLayout;
import org.mozilla.gecko.home.PanelLayout;
import org.mozilla.gecko.home.SimpleCursorLoader;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.UIAsyncTask;

public class DynamicPanel
extends HomeFragment {
    private static final String LOGTAG = "GeckoDynamicPanel";
    private static final String DATASET_REQUEST = "dataset_request";
    private static final int RESULT_LIMIT = 100;
    private FrameLayout mView;
    private PanelLayout mPanelLayout;
    private PanelAuthLayout mPanelAuthLayout;
    private PanelAuthCache mPanelAuthCache;
    private UIAsyncTask.WithoutParams<Boolean> mAuthStateTask;
    private HomeConfig.PanelConfig mPanelConfig;
    private PanelLoaderCallbacks mLoaderCallbacks;
    private UIMode mUIMode;

    @Override
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Bundle bundle2 = this.getArguments();
        if (bundle2 != null) {
            this.mPanelConfig = (HomeConfig.PanelConfig)bundle2.getParcelable("panelConfig");
        }
        if (this.mPanelConfig == null) {
            throw new IllegalStateException("Can't create a DynamicPanel without a PanelConfig");
        }
        this.mPanelAuthCache = new PanelAuthCache((Context)this.getActivity());
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.mView = new FrameLayout((Context)this.getActivity());
        return this.mView;
    }

    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        if (this.mUIMode != null) {
            this.setUIMode(this.mUIMode);
        }
        this.mPanelAuthCache.setOnChangeListener(new PanelAuthChangeListener());
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mView = null;
        this.mPanelLayout = null;
        this.mPanelAuthLayout = null;
        this.mPanelAuthCache.setOnChangeListener(null);
        if (this.mAuthStateTask != null) {
            this.mAuthStateTask.cancel();
            this.mAuthStateTask = null;
        }
    }

    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        this.mLoaderCallbacks = new PanelLoaderCallbacks();
        this.loadIfVisible();
    }

    @Override
    protected void load() {
        Log.d((String)LOGTAG, (String)"Loading layout");
        if (this.requiresAuth()) {
            this.mAuthStateTask = new UIAsyncTask.WithoutParams<Boolean>(ThreadUtils.getBackgroundHandler()){

                public synchronized Boolean doInBackground() {
                    return DynamicPanel.this.mPanelAuthCache.isAuthenticated(DynamicPanel.this.mPanelConfig.getId());
                }

                public void onPostExecute(Boolean bl) {
                    DynamicPanel.this.mAuthStateTask = null;
                    DynamicPanel.this.setUIMode(bl != false ? UIMode.PANEL : UIMode.AUTH);
                }
            };
            this.mAuthStateTask.execute();
        } else {
            this.setUIMode(UIMode.PANEL);
        }
    }

    private boolean requiresAuth() {
        return this.mPanelConfig.getAuthConfig() != null;
    }

    private void createPanelLayout() {
        PanelLayout.ContextMenuRegistry contextMenuRegistry = new PanelLayout.ContextMenuRegistry(){

            @Override
            public void register(View view) {
                DynamicPanel.this.registerForContextMenu(view);
            }
        };
        switch (this.mPanelConfig.getLayoutType()) {
            case FRAME: {
                PanelDatasetHandler panelDatasetHandler = new PanelDatasetHandler();
                this.mPanelLayout = new FramePanelLayout((Context)this.getActivity(), this.mPanelConfig, panelDatasetHandler, this.mUrlOpenListener, contextMenuRegistry);
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized layout type in DynamicPanel");
            }
        }
        Log.d((String)LOGTAG, (String)("Created layout of type: " + (Object)((Object)this.mPanelConfig.getLayoutType())));
        this.mView.addView((View)this.mPanelLayout);
    }

    private void createPanelAuthLayout() {
        this.mPanelAuthLayout = new PanelAuthLayout((Context)this.getActivity(), this.mPanelConfig);
        this.mView.addView((View)this.mPanelAuthLayout, 0);
    }

    private void setUIMode(UIMode uIMode) {
        switch (uIMode) {
            case PANEL: {
                if (this.mPanelAuthLayout != null) {
                    this.mPanelAuthLayout.setVisibility(8);
                }
                if (this.mPanelLayout == null) {
                    this.createPanelLayout();
                }
                this.mPanelLayout.setVisibility(0);
                if (this.mUIMode == uIMode || !this.canLoad()) break;
                this.mPanelLayout.load();
                break;
            }
            case AUTH: {
                if (this.mPanelLayout != null) {
                    this.mPanelLayout.setVisibility(8);
                }
                if (this.mPanelAuthLayout == null) {
                    this.createPanelAuthLayout();
                }
                this.mPanelAuthLayout.setVisibility(0);
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized UIMode in DynamicPanel");
            }
        }
        this.mUIMode = uIMode;
    }

    private class PanelAuthChangeListener
    implements PanelAuthCache.OnChangeListener {
        private PanelAuthChangeListener() {
        }

        @Override
        public void onChange(String string2, boolean bl) {
            if (!DynamicPanel.this.mPanelConfig.getId().equals(string2)) {
                return;
            }
            DynamicPanel.this.setUIMode(bl ? UIMode.PANEL : UIMode.AUTH);
        }
    }

    private class PanelLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Cursor> {
        private PanelLoaderCallbacks() {
        }

        public Loader<Cursor> onCreateLoader(int n, Bundle bundle) {
            PanelLayout.DatasetRequest datasetRequest = (PanelLayout.DatasetRequest)bundle.getParcelable(DynamicPanel.DATASET_REQUEST);
            Log.d((String)DynamicPanel.LOGTAG, (String)("Creating loader for request: " + datasetRequest));
            return new PanelDatasetLoader((Context)DynamicPanel.this.getActivity(), datasetRequest);
        }

        public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
            PanelLayout.DatasetRequest datasetRequest = this.getRequestFromLoader(loader);
            Log.d((String)DynamicPanel.LOGTAG, (String)("Finished loader for request: " + datasetRequest));
            if (DynamicPanel.this.mPanelLayout != null) {
                DynamicPanel.this.mPanelLayout.deliverDataset(datasetRequest, cursor);
            }
        }

        public void onLoaderReset(Loader<Cursor> loader) {
            PanelLayout.DatasetRequest datasetRequest = this.getRequestFromLoader(loader);
            Log.d((String)DynamicPanel.LOGTAG, (String)("Resetting loader for request: " + datasetRequest));
            if (DynamicPanel.this.mPanelLayout != null) {
                DynamicPanel.this.mPanelLayout.releaseDataset(datasetRequest.getViewIndex());
            }
        }

        private PanelLayout.DatasetRequest getRequestFromLoader(Loader<Cursor> loader) {
            PanelDatasetLoader panelDatasetLoader = (PanelDatasetLoader)loader;
            return panelDatasetLoader.getRequest();
        }
    }

    private static class PanelDatasetLoader
    extends SimpleCursorLoader {
        private PanelLayout.DatasetRequest mRequest;

        public PanelDatasetLoader(Context context, PanelLayout.DatasetRequest datasetRequest) {
            super(context);
            this.mRequest = datasetRequest;
        }

        public PanelLayout.DatasetRequest getRequest() {
            return this.mRequest;
        }

        public void onContentChanged() {
            PanelLayout.DatasetRequest datasetRequest;
            this.mRequest = datasetRequest = new PanelLayout.DatasetRequest(this.mRequest.getViewIndex(), PanelLayout.DatasetRequest.Type.DATASET_LOAD, this.mRequest.getDatasetId(), this.mRequest.getFilterDetail());
            super.onContentChanged();
        }

        @Override
        public Cursor loadCursor() {
            String[] stringArray;
            String string2;
            ContentResolver contentResolver = this.getContext().getContentResolver();
            if (this.mRequest.getFilter() == null) {
                string2 = "filter IS NULL";
                stringArray = null;
            } else {
                string2 = "filter = ?";
                stringArray = new String[]{this.mRequest.getFilter()};
            }
            Uri uri = BrowserContract.HomeItems.CONTENT_URI.buildUpon().appendQueryParameter("dataset_id", this.mRequest.getDatasetId()).appendQueryParameter("limit", String.valueOf(100)).build();
            return contentResolver.query(uri, null, string2, stringArray, null);
        }
    }

    private class PanelDatasetHandler
    implements PanelLayout.DatasetHandler {
        private PanelDatasetHandler() {
        }

        @Override
        public void requestDataset(PanelLayout.DatasetRequest datasetRequest) {
            Log.d((String)DynamicPanel.LOGTAG, (String)("Requesting request: " + datasetRequest));
            Bundle bundle = new Bundle();
            bundle.putParcelable(DynamicPanel.DATASET_REQUEST, (Parcelable)datasetRequest);
            DynamicPanel.this.getLoaderManager().restartLoader(datasetRequest.getViewIndex(), bundle, (LoaderManager.LoaderCallbacks)DynamicPanel.this.mLoaderCallbacks);
        }

        @Override
        public void resetDataset(int n) {
            Log.d((String)DynamicPanel.LOGTAG, (String)("Resetting dataset: " + n));
            LoaderManager loaderManager = DynamicPanel.this.getLoaderManager();
            Loader loader = loaderManager.getLoader(n);
            if (loader != null) {
                loader.reset();
            }
        }
    }

    private static enum UIMode {
        PANEL,
        AUTH;

    }
}

