/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.support.v4.widget.SwipeRefreshLayout;
import android.util.Log;
import android.view.View;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.PanelLayout;

class PanelRefreshLayout
extends SwipeRefreshLayout
implements PanelLayout.DatasetBacked {
    private static final String LOGTAG = "GeckoPanelRefreshLayout";
    private static final String JSON_KEY_PANEL_ID = "panelId";
    private static final String JSON_KEY_VIEW_INDEX = "viewIndex";
    private final String panelId;
    private final int viewIndex;
    private final PanelLayout.DatasetBacked datasetBacked;

    public PanelRefreshLayout(Context context, View view, String string2, int n) {
        super(context);
        if (!(view instanceof PanelLayout.DatasetBacked)) {
            throw new IllegalArgumentException("View must implement DatasetBacked to be refreshed");
        }
        this.panelId = string2;
        this.viewIndex = n;
        this.datasetBacked = (PanelLayout.DatasetBacked)view;
        this.setOnRefreshListener(new RefreshListener());
        this.addView(view);
        this.setColorSchemeResources(new int[]{R.color.fennec_ui_orange, R.color.action_orange});
    }

    @Override
    public void setDataset(Cursor cursor) {
        this.datasetBacked.setDataset(cursor);
        this.setRefreshing(false);
    }

    @Override
    public void setFilterManager(PanelLayout.FilterManager filterManager) {
        this.datasetBacked.setFilterManager(filterManager);
    }

    private class RefreshListener
    implements SwipeRefreshLayout.OnRefreshListener {
        private RefreshListener() {
        }

        public void onRefresh() {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put(PanelRefreshLayout.JSON_KEY_PANEL_ID, (Object)PanelRefreshLayout.this.panelId);
                jSONObject.put(PanelRefreshLayout.JSON_KEY_VIEW_INDEX, PanelRefreshLayout.this.viewIndex);
            }
            catch (JSONException jSONException) {
                Log.e((String)PanelRefreshLayout.LOGTAG, (String)"Could not create refresh message", (Throwable)jSONException);
                return;
            }
            GeckoAppShell.notifyObservers("HomePanels:RefreshView", jSONObject.toString());
        }
    }
}

