/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.notifications;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import com.keepsafe.switchboard.SwitchBoard;
import java.util.Locale;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;

public class WhatsNewReceiver
extends BroadcastReceiver {
    public static final String EXTRA_WHATSNEW_NOTIFICATION = "whatsnew_notification";
    private static final String ACTION_NOTIFICATION_CANCELLED = "notification_cancelled";

    public void onReceive(Context context, Intent intent) {
        if (ACTION_NOTIFICATION_CANCELLED.equals(intent.getAction())) {
            Telemetry.sendUIEvent(TelemetryContract.Event.CANCEL, TelemetryContract.Method.NOTIFICATION, EXTRA_WHATSNEW_NOTIFICATION);
            return;
        }
        String string2 = intent.getDataString();
        if (TextUtils.isEmpty((CharSequence)string2) || !string2.contains("org.mozilla.fennec")) {
            return;
        }
        if (!SwitchBoard.isInExperiment((Context)context, (String)"whatsnew-notification")) {
            return;
        }
        if (!this.isPreferenceEnabled(context)) {
            return;
        }
        this.showWhatsNewNotification(context);
    }

    private boolean isPreferenceEnabled(Context context) {
        return GeckoSharedPrefs.forApp(context).getBoolean("android.not_a_preference.notifications.whats_new", true);
    }

    private void showWhatsNewNotification(Context context) {
        Notification notification = new NotificationCompat.Builder(context).setContentTitle((CharSequence)context.getString(R.string.whatsnew_notification_title)).setContentText((CharSequence)context.getString(R.string.whatsnew_notification_summary)).setSmallIcon(R.drawable.ic_status_logo).setAutoCancel(true).setContentIntent(this.getContentIntent(context)).setDeleteIntent(this.getDeleteIntent(context)).build();
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        int n = EXTRA_WHATSNEW_NOTIFICATION.hashCode();
        notificationManager.notify(n, notification);
        Telemetry.sendUIEvent(TelemetryContract.Event.SHOW, TelemetryContract.Method.NOTIFICATION, EXTRA_WHATSNEW_NOTIFICATION);
    }

    private PendingIntent getContentIntent(Context context) {
        String string2 = context.getString(R.string.whatsnew_notification_url, new Object[]{"50.0a1", "Android", Locales.getLanguageTag((Locale)Locale.getDefault())});
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setClassName("org.mozilla.fennec", "org.mozilla.gecko.BrowserApp");
        intent.setData(Uri.parse((String)string2));
        intent.putExtra(EXTRA_WHATSNEW_NOTIFICATION, true);
        return PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0x8000000);
    }

    private PendingIntent getDeleteIntent(Context context) {
        Intent intent = new Intent(context, WhatsNewReceiver.class);
        intent.setAction(ACTION_NOTIFICATION_CANCELLED);
        return PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0x10000000);
    }
}

