/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabs;

import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.tabs.TabHistoryPage;
import org.mozilla.gecko.util.GeckoRequest;
import org.mozilla.gecko.util.NativeJSObject;

public class TabHistoryController {
    private static final String LOGTAG = "TabHistoryController";
    private final OnShowTabHistory showTabHistoryListener;

    public TabHistoryController(OnShowTabHistory onShowTabHistory) {
        this.showTabHistoryListener = onShowTabHistory;
    }

    public boolean showTabHistory(Tab tab, HistoryAction historyAction) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("action", (Object)historyAction.name());
            jSONObject.put("tabId", tab.getId());
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"JSON error", (Throwable)jSONException);
        }
        GeckoAppShell.sendRequestToGecko(new GeckoRequest("Session:GetHistory", jSONObject){

            public void onResponse(NativeJSObject nativeJSObject) {
                NativeJSObject[] nativeJSObjectArray = nativeJSObject.getObjectArray("historyItems");
                if (nativeJSObjectArray.length == 0) {
                    return;
                }
                ArrayList<TabHistoryPage> arrayList = new ArrayList<TabHistoryPage>(nativeJSObjectArray.length);
                int n = nativeJSObject.getInt("toIndex");
                for (NativeJSObject nativeJSObject2 : nativeJSObjectArray) {
                    String string2 = nativeJSObject2.getString("title");
                    String string3 = nativeJSObject2.getString("url");
                    boolean bl = nativeJSObject2.getBoolean("selected");
                    arrayList.add(new TabHistoryPage(string2, string3, bl));
                }
                TabHistoryController.this.showTabHistoryListener.onShowHistory(arrayList, n);
            }
        });
        return true;
    }

    public static interface OnShowTabHistory {
        public void onShowHistory(List<TabHistoryPage> var1, int var2);
    }

    public static enum HistoryAction {
        ALL,
        BACK,
        FORWARD;

    }
}

