/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.telemetry;

import android.content.Context;
import android.support.annotation.WorkerThread;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import org.mozilla.gecko.telemetry.TelemetryPing;
import org.mozilla.gecko.telemetry.pingbuilders.TelemetryCorePingBuilder;
import org.mozilla.gecko.telemetry.schedulers.TelemetryUploadAllPingsImmediatelyScheduler;
import org.mozilla.gecko.telemetry.schedulers.TelemetryUploadScheduler;
import org.mozilla.gecko.telemetry.stores.TelemetryJSONFilePingStore;
import org.mozilla.gecko.telemetry.stores.TelemetryPingStore;
import org.mozilla.gecko.util.ThreadUtils;

public class TelemetryDispatcher {
    private static final String LOGTAG = "Gecko" + TelemetryDispatcher.class.getSimpleName();
    private static final String STORE_CONTAINER_DIR_NAME = "telemetry_java";
    private static final String CORE_STORE_DIR_NAME = "core";
    private final TelemetryJSONFilePingStore coreStore;
    private final TelemetryUploadAllPingsImmediatelyScheduler uploadAllPingsImmediatelyScheduler;

    @WorkerThread
    public TelemetryDispatcher(String string2, String string3) {
        String string4 = string2 + File.separator + STORE_CONTAINER_DIR_NAME;
        this.coreStore = new TelemetryJSONFilePingStore(new File(string4, CORE_STORE_DIR_NAME), string3);
        this.uploadAllPingsImmediatelyScheduler = new TelemetryUploadAllPingsImmediatelyScheduler();
    }

    private void queuePingForUpload(Context context, TelemetryPing telemetryPing, TelemetryPingStore telemetryPingStore, TelemetryUploadScheduler telemetryUploadScheduler) {
        QueuePingRunnable queuePingRunnable = new QueuePingRunnable(context, telemetryPing, telemetryPingStore, telemetryUploadScheduler);
        ThreadUtils.postToBackgroundThread((Runnable)queuePingRunnable);
    }

    public void queuePingForUpload(Context context, TelemetryCorePingBuilder telemetryCorePingBuilder) {
        TelemetryPing telemetryPing = telemetryCorePingBuilder.build();
        this.queuePingForUpload(context, telemetryPing, this.coreStore, this.uploadAllPingsImmediatelyScheduler);
    }

    private static class QueuePingRunnable
    implements Runnable {
        private final Context applicationContext;
        private final TelemetryPing ping;
        private final TelemetryPingStore store;
        private final TelemetryUploadScheduler scheduler;

        public QueuePingRunnable(Context context, TelemetryPing telemetryPing, TelemetryPingStore telemetryPingStore, TelemetryUploadScheduler telemetryUploadScheduler) {
            this.applicationContext = context.getApplicationContext();
            this.ping = telemetryPing;
            this.store = telemetryPingStore;
            this.scheduler = telemetryUploadScheduler;
        }

        @Override
        public void run() {
            try {
                this.store.storePing(this.ping);
            }
            catch (IOException iOException) {
                Log.e((String)LOGTAG, (String)"Unable to write ping to disk. Continuing with upload attempt");
            }
            if (this.scheduler.isReadyToUpload(this.store)) {
                this.scheduler.scheduleUpload(this.applicationContext, this.store);
            }
        }
    }
}

